/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ErrorMessageDisplay;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IncrementalSearcher;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.SearchResultsDialog;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.search.BasicSearch;
import net.sf.jabref.search.SearchExpression;
import net.sf.jabref.search.SearchExpressionParser;
import net.sf.jabref.search.SearchMatcher;

public class SearchManager2
extends SidePaneComponent
implements ActionListener,
KeyListener,
ItemListener,
CaretListener,
ErrorMessageDisplay {
    private JabRefFrame frame;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    IncrementalSearcher incSearcher;
    SearchResultsDialog searchDialog = null;
    AutoCompleteListener autoCompleteListener = null;
    private Vector<SearchTextListener> listeners = new Vector();
    private JTextField searchField = new JTextField("", 12);
    private JPopupMenu settings = new JPopupMenu();
    private JButton openset = new JButton(Globals.lang("Settings"));
    private JButton escape = new JButton(Globals.lang("Clear"));
    private JButton help = new JButton(GUIGlobals.getImage("help"));
    private JButton search = new JButton();
    private JCheckBoxMenuItem searchReq;
    private JCheckBoxMenuItem searchOpt;
    private JCheckBoxMenuItem searchGen;
    private JCheckBoxMenuItem searchAll;
    private JCheckBoxMenuItem caseSensitive;
    private JCheckBoxMenuItem regExpSearch;
    private JCheckBoxMenuItem highLightWords;
    private JCheckBoxMenuItem searchAutoComplete;
    private JRadioButton increment;
    private JRadioButton floatSearch;
    private JRadioButton hideSearch;
    private JRadioButton showResultsInDialog;
    private JRadioButton searchAllBases;
    private JCheckBoxMenuItem select;
    private ButtonGroup types = new ButtonGroup();
    private boolean incSearch = false;
    private boolean startedFloatSearch = false;
    private boolean startedFilterSearch = false;
    private int incSearchPos = -1;

    public SearchManager2(JabRefFrame frame, SidePaneManager manager) {
        super(manager, GUIGlobals.getIconUrl("search"), Globals.lang("Search"));
        this.frame = frame;
        this.incSearcher = new IncrementalSearcher(Globals.prefs);
        this.searchReq = new JCheckBoxMenuItem(Globals.lang("Search required fields"), Globals.prefs.getBoolean("searchReq"));
        this.searchOpt = new JCheckBoxMenuItem(Globals.lang("Search optional fields"), Globals.prefs.getBoolean("searchOpt"));
        this.searchGen = new JCheckBoxMenuItem(Globals.lang("Search general fields"), Globals.prefs.getBoolean("searchGen"));
        this.searchAll = new JCheckBoxMenuItem(Globals.lang("Search all fields"), Globals.prefs.getBoolean("searchAll"));
        this.regExpSearch = new JCheckBoxMenuItem(Globals.lang("Use regular expressions"), Globals.prefs.getBoolean("regExpSearch"));
        this.increment = new JRadioButton(Globals.lang("Incremental"), false);
        this.floatSearch = new JRadioButton(Globals.lang("Float"), true);
        this.hideSearch = new JRadioButton(Globals.lang("Filter"), true);
        this.showResultsInDialog = new JRadioButton(Globals.lang("Show results in dialog"), true);
        this.searchAllBases = new JRadioButton(Globals.lang("Global search"), Globals.prefs.getBoolean("searchAllBases"));
        this.types.add(this.increment);
        this.types.add(this.floatSearch);
        this.types.add(this.hideSearch);
        this.types.add(this.showResultsInDialog);
        this.types.add(this.searchAllBases);
        this.select = new JCheckBoxMenuItem(Globals.lang("Select matches"), false);
        this.increment.setToolTipText(Globals.lang("Incremental search"));
        this.floatSearch.setToolTipText(Globals.lang("Gray out non-matching entries"));
        this.hideSearch.setToolTipText(Globals.lang("Hide non-matching entries"));
        this.showResultsInDialog.setToolTipText(Globals.lang("Show search results in a window"));
        this.increment.addItemListener(this);
        this.floatSearch.addItemListener(this);
        this.hideSearch.addItemListener(this);
        this.showResultsInDialog.addItemListener(this);
        this.searchField.addFocusListener(Globals.focusListener);
        if (this.searchAll.isSelected()) {
            this.searchReq.setEnabled(false);
            this.searchOpt.setEnabled(false);
            this.searchGen.setEnabled(false);
        }
        this.searchAll.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                boolean state = !SearchManager2.this.searchAll.isSelected();
                SearchManager2.this.searchReq.setEnabled(state);
                SearchManager2.this.searchOpt.setEnabled(state);
                SearchManager2.this.searchGen.setEnabled(state);
            }
        });
        this.caseSensitive = new JCheckBoxMenuItem(Globals.lang("Case sensitive"), Globals.prefs.getBoolean("caseSensitiveSearch"));
        this.highLightWords = new JCheckBoxMenuItem(Globals.lang("Highlight Words"), Globals.prefs.getBoolean("highLightWords"));
        this.searchAutoComplete = new JCheckBoxMenuItem(Globals.lang("Autocomplete names"), Globals.prefs.getBoolean("searchAutoComplete"));
        this.settings.add(this.select);
        this.settings.addSeparator();
        this.settings.add(this.caseSensitive);
        this.settings.add(this.regExpSearch);
        this.settings.addSeparator();
        this.settings.add(this.highLightWords);
        this.settings.addSeparator();
        this.settings.add(this.searchAutoComplete);
        this.searchField.addActionListener(this);
        this.searchField.addCaretListener(this);
        this.search.addActionListener(this);
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.searchField.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                SearchManager2.this.incSearch = false;
                SearchManager2.this.incSearchPos = -1;
                if (SearchManager2.this.increment.isSelected()) {
                    // empty if block
                }
            }
        });
        this.escape.addActionListener(this);
        this.escape.setEnabled(false);
        this.openset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchManager2.this.settings.isVisible()) {
                    JButton src = (JButton)e.getSource();
                    SearchManager2.this.settings.show(src, 0, SearchManager2.this.openset.getHeight());
                }
            }
        });
        this.searchAutoComplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("searchAutoComplete", SearchManager2.this.searchAutoComplete.isSelected());
                if (SearchManager2.this.frame.basePanel() != null) {
                    SearchManager2.this.frame.basePanel().updateSearchManager();
                }
            }
        });
        Insets margin = new Insets(0, 2, 0, 2);
        this.escape.setMargin(margin);
        this.openset.setMargin(margin);
        int butSize = this.help.getIcon().getIconHeight() + 5;
        Dimension butDim = new Dimension(butSize, butSize);
        this.help.setPreferredSize(butDim);
        this.help.setMinimumSize(butDim);
        this.help.setMargin(margin);
        this.help.addActionListener(new HelpAction(Globals.helpDiag, "SearchHelp.html", "Help"));
        if (Globals.prefs.getBoolean("incrementS")) {
            this.increment.setSelected(true);
        } else if (Globals.prefs.getBoolean("floatSearch")) {
            this.floatSearch.setSelected(true);
        } else if (Globals.prefs.getBoolean("showSearchInDialog")) {
            this.showResultsInDialog.setSelected(true);
        } else if (Globals.prefs.getBoolean("searchAllBases")) {
            this.searchAllBases.setSelected(true);
        } else {
            this.hideSearch.setSelected(true);
        }
        JPanel main = new JPanel();
        main.setLayout(this.gbl);
        this.con.gridwidth = 0;
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.gbl.setConstraints(this.searchField, this.con);
        main.add(this.searchField);
        this.gbl.setConstraints(this.search, this.con);
        main.add(this.search);
        this.con.gridwidth = 0;
        this.gbl.setConstraints(this.escape, this.con);
        main.add(this.escape);
        this.con.insets = new Insets(0, 2, 0, 0);
        this.gbl.setConstraints(this.increment, this.con);
        main.add(this.increment);
        this.gbl.setConstraints(this.floatSearch, this.con);
        main.add(this.floatSearch);
        this.gbl.setConstraints(this.hideSearch, this.con);
        main.add(this.hideSearch);
        this.gbl.setConstraints(this.showResultsInDialog, this.con);
        main.add(this.showResultsInDialog);
        this.gbl.setConstraints(this.searchAllBases, this.con);
        main.add(this.searchAllBases);
        this.con.insets = new Insets(0, 0, 0, 0);
        JPanel pan = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        this.gbl.setConstraints(pan, this.con);
        pan.setLayout(gb);
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        gb.setConstraints(this.openset, this.con);
        pan.add(this.openset);
        this.con.weightx = 0.0;
        gb.setConstraints(this.help, this.con);
        pan.add(this.help);
        main.add(pan);
        main.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setContent(main);
        this.searchField.getInputMap().put(Globals.prefs.getKey("Repeat incremental search"), "repeat");
        this.searchField.getActionMap().put("repeat", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.repeatIncremental();
                }
            }
        });
        this.searchField.getInputMap().put(Globals.prefs.getKey("Clear search"), "escape");
        this.searchField.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchManager2.this.hideAway();
            }
        });
        this.setSearchButtonSizes();
        this.updateSearchButtonText();
    }

    public void setAutoCompleteListener(AutoCompleteListener listener) {
        this.autoCompleteListener = listener;
        this.updateKeyListeners();
    }

    protected void updateKeyListeners() {
        KeyListener[] listeners = this.searchField.getKeyListeners();
        for (int i = 0; i < listeners.length; ++i) {
            this.searchField.removeKeyListener(listeners[i]);
        }
        if (this.increment.isSelected()) {
            this.searchField.addKeyListener(this);
        } else if (this.searchAutoComplete.isSelected() && this.autoCompleteListener != null) {
            this.searchField.addKeyListener(this.autoCompleteListener);
        }
    }

    public void addSearchListener(SearchTextListener l) {
        if (this.listeners.contains(l)) {
            return;
        }
        this.listeners.add(l);
        l.searchText(this.getSearchwords(this.searchField.getText()));
    }

    public void removeSearchListener(SearchTextListener l) {
        this.listeners.remove(l);
    }

    private ArrayList<String> getSearchwords(String t) {
        String[] strings = t.split(" ");
        ArrayList<String> words = new ArrayList<String>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            words.add(strings[i]);
        }
        return words;
    }

    private void fireSearchlistenerEvent(String t) {
        ArrayList<String> words = t == null || t.isEmpty() ? null : this.getSearchwords(t);
        for (SearchTextListener s : this.listeners) {
            s.searchText(words);
        }
    }

    private void setSearchButtonSizes() {
        this.search.setText(Globals.lang("Search Specified Field(s)"));
        Dimension size1 = this.search.getPreferredSize();
        this.search.setText(Globals.lang("Search All Fields"));
        Dimension size2 = this.search.getPreferredSize();
        size2.width = Math.max(size1.width, size2.width);
        this.search.setMinimumSize(size2);
        this.search.setPreferredSize(size2);
    }

    protected void instantiateSearchDialog() {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchResultsDialog(this.frame, Globals.lang("Search results"));
        }
    }

    public void updatePrefs() {
        Globals.prefs.putBoolean("searchReq", this.searchReq.isSelected());
        Globals.prefs.putBoolean("searchOpt", this.searchOpt.isSelected());
        Globals.prefs.putBoolean("searchGen", this.searchGen.isSelected());
        Globals.prefs.putBoolean("searchAll", this.searchAll.isSelected());
        Globals.prefs.putBoolean("incrementS", this.increment.isSelected());
        Globals.prefs.putBoolean("selectS", this.select.isSelected());
        Globals.prefs.putBoolean("floatSearch", this.floatSearch.isSelected());
        Globals.prefs.putBoolean("caseSensitiveSearch", this.caseSensitive.isSelected());
        Globals.prefs.putBoolean("regExpSearch", this.regExpSearch.isSelected());
        Globals.prefs.putBoolean("highLightWords", this.highLightWords.isSelected());
        Globals.prefs.putBoolean("showSearchInDialog", this.showResultsInDialog.isSelected());
        Globals.prefs.putBoolean("searchAllBases", this.searchAllBases.isSelected());
    }

    public void startIncrementalSearch() {
        this.increment.setSelected(true);
        this.searchField.setText("");
        this.searchField.requestFocus();
    }

    public void startSearch() {
        if (this.increment.isSelected() && this.incSearch) {
            this.repeatIncremental();
            return;
        }
        if (!this.searchField.hasFocus()) {
            this.searchField.selectAll();
            this.searchField.requestFocus();
        } else {
            if (this.increment.isSelected()) {
                this.floatSearch.setSelected(true);
            } else if (this.floatSearch.isSelected()) {
                this.hideSearch.setSelected(true);
            } else if (this.hideSearch.isSelected()) {
                this.showResultsInDialog.setSelected(true);
            } else if (this.showResultsInDialog.isSelected()) {
                this.searchAllBases.setSelected(true);
            } else {
                this.increment.setSelected(true);
            }
            this.increment.revalidate();
            this.increment.repaint();
            this.searchField.requestFocus();
        }
    }

    private void clearSearchLater() {
        if (this.panel != null) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    SearchManager2.this.clearSearch();
                }
            };
            SwingUtilities.invokeLater(t);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.escape) {
            this.incSearch = false;
            this.clearSearchLater();
        } else if (!(e.getSource() != this.searchField && e.getSource() != this.search || this.increment.isSelected() || this.panel == null)) {
            this.updatePrefs();
            if (this.searchField.getText().equals("")) {
                this.clearSearchLater();
                return;
            }
            this.fireSearchlistenerEvent(this.searchField.getText());
            Hashtable<String, String> searchOptions = new Hashtable<String, String>();
            searchOptions.put("option", this.searchField.getText());
            SearchRuleSet searchRules = new SearchRuleSet();
            SearchRule rule1 = new BasicSearch(Globals.prefs.getBoolean("caseSensitiveSearch"), Globals.prefs.getBoolean("regExpSearch"));
            try {
                rule1 = new SearchExpression(Globals.prefs, searchOptions);
            }
            catch (Exception ex) {
                // empty catch block
            }
            searchRules.addRule(rule1);
            if (!searchRules.validateSearchStrings(searchOptions)) {
                this.panel.output(Globals.lang("Search failed: illegal search expression"));
                this.panel.stopShowingSearchResults();
                return;
            }
            SearchWorker worker = new SearchWorker(searchRules, searchOptions);
            worker.getWorker().run();
            worker.getCallBack().update();
            this.escape.setEnabled(true);
        }
    }

    public void clearSearch() {
        if (this.panel.isShowingFloatSearch()) {
            this.startedFloatSearch = false;
            this.panel.mainTable.stopShowingFloatSearch();
        } else if (this.panel.isShowingFilterSearch()) {
            this.startedFilterSearch = false;
            this.panel.stopShowingSearchResults();
        }
        this.fireSearchlistenerEvent(null);
        this.escape.setEnabled(false);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.increment) {
            if (this.startedFilterSearch || this.startedFloatSearch) {
                this.clearSearch();
            }
            this.updateSearchButtonText();
            this.updateKeyListeners();
        } else {
            this.updateSearchButtonText();
        }
    }

    private void repeatIncremental() {
        ++this.incSearchPos;
        if (this.panel != null) {
            this.goIncremental();
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (e.isControlDown()) {
            return;
        }
        if (this.panel != null) {
            this.goIncremental();
        }
    }

    private void goIncremental() {
        this.incSearch = true;
        this.escape.setEnabled(true);
        SwingUtilities.invokeLater(new Thread(){

            @Override
            public void run() {
                String text = SearchManager2.this.searchField.getText();
                if (SearchManager2.this.incSearchPos >= SearchManager2.this.panel.getDatabase().getEntryCount()) {
                    SearchManager2.this.panel.output("'" + text + "' : " + Globals.lang("Incremental search failed. Repeat to search from top.") + ".");
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.searchField.getText().equals("")) {
                    return;
                }
                if (SearchManager2.this.incSearchPos < 0) {
                    SearchManager2.this.incSearchPos = 0;
                }
                BibtexEntry be = SearchManager2.this.panel.mainTable.getEntryAt(SearchManager2.this.incSearchPos);
                while (!SearchManager2.this.incSearcher.search(text, be)) {
                    SearchManager2.this.incSearchPos++;
                    if (SearchManager2.this.incSearchPos < SearchManager2.this.panel.getDatabase().getEntryCount()) {
                        be = SearchManager2.this.panel.mainTable.getEntryAt(SearchManager2.this.incSearchPos);
                        continue;
                    }
                    SearchManager2.this.panel.output("'" + text + "' : " + Globals.lang("Incremental search failed. Repeat to search from top."));
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.incSearchPos >= 0) {
                    SearchManager2.this.panel.selectSingleEntry(SearchManager2.this.incSearchPos);
                    SearchManager2.this.panel.output("'" + text + "' " + Globals.lang("found") + ".");
                }
            }
        });
    }

    @Override
    public void componentClosing() {
        this.frame.searchToggle.setSelected(false);
        if (this.panel != null && (this.startedFilterSearch || this.startedFloatSearch)) {
            this.clearSearch();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (e.getSource() == this.searchField) {
            this.updateSearchButtonText();
        }
    }

    private void updateSearchButtonText() {
        this.search.setText(!this.increment.isSelected() && SearchExpressionParser.checkSyntax(this.searchField.getText(), this.caseSensitive.isSelected(), this.regExpSearch.isSelected()) != null ? Globals.lang("Search Specified Field(s)") : Globals.lang("Search All Fields"));
    }

    @Override
    public void reportError(String errorMessage) {
        JOptionPane.showMessageDialog(this.panel, errorMessage, Globals.lang("Search error"), 0);
    }

    @Override
    public void reportError(String errorMessage, Exception exception) {
        this.reportError(errorMessage);
    }

    @Override
    public void setActiveBasePanel(BasePanel panel) {
        super.setActiveBasePanel(panel);
        if (panel != null) {
            this.escape.setEnabled(panel.isShowingFloatSearch() || panel.isShowingFilterSearch());
        } else {
            this.escape.setEnabled(false);
        }
    }

    class SearchWorker
    extends AbstractWorker {
        private SearchRuleSet rules;
        Hashtable<String, String> searchTerm;
        int hits = 0;

        public SearchWorker(SearchRuleSet rules, Hashtable<String, String> searchTerm) {
            this.rules = rules;
            this.searchTerm = searchTerm;
        }

        @Override
        public void run() {
            if (!SearchManager2.this.searchAllBases.isSelected()) {
                for (BibtexEntry entry : SearchManager2.this.panel.getDatabase().getEntries()) {
                    boolean hit = this.rules.applyRule(this.searchTerm, entry) > 0;
                    entry.setSearchHit(hit);
                    if (!hit) continue;
                    ++this.hits;
                }
            } else {
                for (int i = 0; i < SearchManager2.this.frame.getTabbedPane().getTabCount(); ++i) {
                    BasePanel p = SearchManager2.this.frame.baseAt(i);
                    for (BibtexEntry entry : p.getDatabase().getEntries()) {
                        boolean hit = this.rules.applyRule(this.searchTerm, entry) > 0;
                        entry.setSearchHit(hit);
                        if (!hit) continue;
                        ++this.hits;
                    }
                }
            }
        }

        @Override
        public void update() {
            SearchManager2.this.panel.output(Globals.lang("Searched database. Number of hits") + ": " + this.hits);
            if (SearchManager2.this.searchAllBases.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.instantiateSearchDialog();
                SearchManager2.this.searchDialog.clear();
                for (int i = 0; i < SearchManager2.this.frame.getTabbedPane().getTabCount(); ++i) {
                    BasePanel p = SearchManager2.this.frame.baseAt(i);
                    for (BibtexEntry entry : p.getDatabase().getEntries()) {
                        if (!entry.isSearchHit()) continue;
                        SearchManager2.this.searchDialog.addEntry(entry, p);
                    }
                }
                SearchManager2.this.searchDialog.selectFirstEntry();
                SearchManager2.this.searchDialog.setVisible(true);
            } else if (SearchManager2.this.showResultsInDialog.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.instantiateSearchDialog();
                SearchManager2.this.searchDialog.clear();
                for (BibtexEntry entry : SearchManager2.this.panel.getDatabase().getEntries()) {
                    if (!entry.isSearchHit()) continue;
                    SearchManager2.this.searchDialog.addEntry(entry, SearchManager2.this.panel);
                }
                SearchManager2.this.searchDialog.selectFirstEntry();
                SearchManager2.this.searchDialog.setVisible(true);
            } else if (SearchManager2.this.hideSearch.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                SearchManager2.this.startedFilterSearch = true;
                SearchManager2.this.panel.setSearchMatcher(SearchMatcher.INSTANCE);
            } else {
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.startedFloatSearch = true;
                SearchManager2.this.panel.mainTable.showFloatSearch(SearchMatcher.INSTANCE);
            }
            SearchManager2.this.searchField.select(0, SearchManager2.this.searchField.getText().length());
        }
    }
}

