/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.util.ArrayList;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.LayoutEntry;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.StringInt;

public class Layout {
    private LayoutEntry[] layoutEntries;
    private ArrayList<String> missingFormatters = new ArrayList();

    public Layout(Vector<StringInt> parsedEntries, String classPrefix) throws Exception {
        int i;
        Vector<LayoutEntry> tmpEntries = new Vector<LayoutEntry>(parsedEntries.size());
        Vector<StringInt> blockEntries = null;
        String blockStart = null;
        for (i = 0; i < parsedEntries.size(); ++i) {
            StringInt si = parsedEntries.get(i);
            if (si.i != 1 && si.i != 2) {
                LayoutEntry le;
                if (si.i == 3) {
                    blockEntries = new Vector<StringInt>();
                    blockStart = si.s;
                } else if (si.i == 4) {
                    if (blockStart != null && blockEntries != null) {
                        if (blockStart.equals(si.s)) {
                            blockEntries.add(si);
                            le = new LayoutEntry(blockEntries, classPrefix, 3);
                            tmpEntries.add(le);
                            blockEntries = null;
                        } else {
                            System.out.println(blockStart + "\n" + si.s);
                            System.out.println("Nested field entries are not implemented !!!");
                            Thread.dumpStack();
                        }
                    }
                } else if (si.i == 6) {
                    blockEntries = new Vector();
                    blockStart = si.s;
                } else if (si.i == 7) {
                    if (blockStart != null && blockEntries != null) {
                        if (blockStart.equals(si.s)) {
                            blockEntries.add(si);
                            le = new LayoutEntry(blockEntries, classPrefix, 6);
                            tmpEntries.add(le);
                            blockEntries = null;
                        } else {
                            System.out.println("Nested field entries are not implemented !!!");
                            Thread.dumpStack();
                        }
                    }
                } else if (si.i == 5) {
                    // empty if block
                }
            }
            if (blockEntries == null) {
                tmpEntries.add(new LayoutEntry(si, classPrefix));
                continue;
            }
            blockEntries.add(si);
        }
        this.layoutEntries = new LayoutEntry[tmpEntries.size()];
        for (i = 0; i < tmpEntries.size(); ++i) {
            this.layoutEntries[i] = (LayoutEntry)tmpEntries.get(i);
            if (!this.layoutEntries[i].isInvalidFormatter()) continue;
            this.missingFormatters.addAll(this.layoutEntries[i].getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter formatter) {
        for (int i = 0; i < this.layoutEntries.length; ++i) {
            LayoutEntry layoutEntry = this.layoutEntries[i];
            layoutEntry.setPostFormatter(formatter);
        }
    }

    public String doLayout(BibtexEntry bibtex, BibtexDatabase database) {
        return this.doLayout(bibtex, database, null);
    }

    public String doLayout(BibtexEntry bibtex, BibtexDatabase database, ArrayList<String> wordsToHighlight) {
        StringBuffer sb = new StringBuffer(100);
        for (int i = 0; i < this.layoutEntries.length; ++i) {
            String fieldText = this.layoutEntries[i].doLayout(bibtex, database, wordsToHighlight);
            if (fieldText == null) {
                fieldText = "";
            }
            sb.append(fieldText);
        }
        return sb.toString();
    }

    public String doLayout(BibtexDatabase database, String encoding) {
        StringBuffer sb = new StringBuffer(100);
        boolean previousSkipped = false;
        for (int i = 0; i < this.layoutEntries.length; ++i) {
            String fieldText = this.layoutEntries[i].doLayout(database, encoding);
            if (fieldText == null) {
                fieldText = "";
                if (previousSkipped) {
                    int eol;
                    for (eol = 0; eol < fieldText.length() && (fieldText.charAt(eol) == '\n' || fieldText.charAt(eol) == '\r'); ++eol) {
                    }
                    if (eol < fieldText.length()) {
                        sb.append(fieldText.substring(eol));
                    }
                }
            } else {
                sb.append(fieldText);
            }
            previousSkipped = false;
        }
        return sb.toString();
    }

    public ArrayList<String> getMissingFormatters() {
        return this.missingFormatters;
    }
}

