/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import net.sf.jabref.EntryContainer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.groups.EntryTableTransferHandler;

public class FileListEditorTransferHandler
extends TransferHandler {
    protected DataFlavor urlFlavor;
    protected DataFlavor stringFlavor;
    protected JabRefFrame frame;
    protected EntryContainer entryContainer;
    private TransferHandler textTransferHandler;
    private DroppedFileHandler dfh = null;

    public FileListEditorTransferHandler(JabRefFrame frame, EntryContainer entryContainer, TransferHandler textTransferHandler) {
        this.frame = frame;
        this.entryContainer = entryContainer;
        this.textTransferHandler = textTransferHandler;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException e) {
            Globals.logger("Unable to configure drag and drop for file link table");
            e.printStackTrace();
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 0x40000001;
    }

    @Override
    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        if (this.textTransferHandler != null) {
            this.textTransferHandler.exportToClipboard(comp, clip, action);
        }
    }

    @Override
    public boolean importData(JComponent comp, Transferable t) {
        try {
            List<File> files = null;
            if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                files = (List<File>)t.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (t.isDataFlavorSupported(this.urlFlavor)) {
                URL dropLink = (URL)t.getTransferData(this.urlFlavor);
                System.out.println("URL: " + dropLink);
            }
            if (t.isDataFlavorSupported(this.stringFlavor)) {
                String dropStr = (String)t.getTransferData(this.stringFlavor);
                files = EntryTableTransferHandler.getFilesFromDraggedFilesString(dropStr);
            }
            if (files != null) {
                final List<File> theFiles = files;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (File f : theFiles) {
                            String name = f.getAbsolutePath();
                            String extension = "";
                            ExternalFileType fileType = null;
                            int index = name.lastIndexOf(46);
                            if (index >= 0 && index < name.length()) {
                                extension = name.substring(index + 1).toLowerCase();
                                fileType = Globals.prefs.getExternalFileTypeByExt(extension);
                            }
                            if (fileType == null) continue;
                            if (FileListEditorTransferHandler.this.dfh == null) {
                                FileListEditorTransferHandler.this.dfh = new DroppedFileHandler(FileListEditorTransferHandler.this.frame, FileListEditorTransferHandler.this.frame.basePanel());
                            }
                            FileListEditorTransferHandler.this.dfh.handleDroppedfile(name, fileType, true, FileListEditorTransferHandler.this.entryContainer.getEntry());
                        }
                    }
                });
                return true;
            }
        }
        catch (IOException ioe) {
            System.err.println("failed to read dropped data: " + ioe.toString());
        }
        catch (UnsupportedFlavorException ufe) {
            System.err.println("drop type error: " + ufe.toString());
        }
        System.err.println("can't transfer input: ");
        DataFlavor[] inflavs = t.getTransferDataFlavors();
        for (int i = 0; i < inflavs.length; ++i) {
            System.out.println("  " + inflavs[i].toString());
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent comp, DataFlavor[] transferFlavors) {
        for (int i = 0; i < transferFlavors.length; ++i) {
            DataFlavor inflav = transferFlavors[i];
            if (!inflav.match(this.urlFlavor) && !inflav.match(this.stringFlavor) && !inflav.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }
}

