/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class HtmlTransferable
implements Transferable {
    private static final int HTML = 0;
    private static final int STRING = 1;
    public static final DataFlavor HTML_FLAVOR = new DataFlavor("text/html;charset=utf-8;class=java.lang.String", "HTML Format");
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{HTML_FLAVOR, DataFlavor.stringFlavor};
    private String htmlText;
    private String plainText;

    public HtmlTransferable(String htmlText, String plainText) {
        this.htmlText = htmlText;
        this.plainText = plainText;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])FLAVORS.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!flavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(FLAVORS[1])) {
            return this.plainText;
        }
        if (flavor.equals(FLAVORS[0])) {
            return this.htmlText;
        }
        throw new UnsupportedFlavorException(flavor);
    }
}

