/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.ImportInspector;
import net.sf.jabref.imports.MedlineImporter;

public class MedlineFetcher
implements EntryFetcher {
    public static final int PACING = 20;
    boolean shouldContinue;
    OutputPrinter frame;
    ImportInspector dialog;

    public String toSearchTerm(String in) {
        Pattern part1 = Pattern.compile(", ");
        Pattern part2 = Pattern.compile(",");
        Pattern part3 = Pattern.compile(" ");
        Matcher matcher = part1.matcher(in);
        in = matcher.replaceAll("\\+AND\\+");
        matcher = part2.matcher(in);
        in = matcher.replaceAll("\\+AND\\+");
        matcher = part3.matcher(in);
        in = matcher.replaceAll("+");
        return in;
    }

    public SearchResult getIds(String term, int start, int pacing) {
        String baseUrl = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils";
        String medlineUrl = baseUrl + "/esearch.fcgi?db=pubmed&retmax=" + Integer.toString(pacing) + "&retstart=" + Integer.toString(start) + "&term=";
        Pattern idPattern = Pattern.compile("<Id>(\\d+)</Id>");
        Pattern countPattern = Pattern.compile("<Count>(\\d+)<\\/Count>");
        Pattern retMaxPattern = Pattern.compile("<RetMax>(\\d+)<\\/RetMax>");
        Pattern retStartPattern = Pattern.compile("<RetStart>(\\d+)<\\/RetStart>");
        boolean doCount = true;
        SearchResult result = new SearchResult();
        try {
            String inLine;
            URL ncbi = new URL(medlineUrl + term);
            BufferedReader in = new BufferedReader(new InputStreamReader(ncbi.openStream()));
            while ((inLine = in.readLine()) != null) {
                Matcher retStartMatcher;
                Matcher retMaxMatcher;
                Matcher idMatcher = idPattern.matcher(inLine);
                if (idMatcher.find()) {
                    result.addID(idMatcher.group(1));
                }
                if ((retMaxMatcher = retMaxPattern.matcher(inLine)).find()) {
                    result.retmax = Integer.parseInt(retMaxMatcher.group(1));
                }
                if ((retStartMatcher = retStartPattern.matcher(inLine)).find()) {
                    result.retstart = Integer.parseInt(retStartMatcher.group(1));
                }
                Matcher countMatcher = countPattern.matcher(inLine);
                if (!doCount || !countMatcher.find()) continue;
                result.count = Integer.parseInt(countMatcher.group(1));
                doCount = false;
            }
        }
        catch (MalformedURLException e) {
            System.out.println("bad url");
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("connection failed");
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public void stopFetching() {
        this.shouldContinue = false;
    }

    @Override
    public String getHelpPage() {
        return "MedlineHelp.html";
    }

    @Override
    public URL getIcon() {
        return GUIGlobals.getIconUrl("www");
    }

    @Override
    public String getKeyName() {
        return "Medline";
    }

    @Override
    public JPanel getOptionsPanel() {
        return null;
    }

    @Override
    public String getTitle() {
        return "Medline";
    }

    @Override
    public boolean processQuery(String query, ImportInspector dialog, OutputPrinter frame) {
        this.shouldContinue = true;
        if ((query = query.trim().replace(';', ',')).matches("\\d+[,\\d+]*")) {
            frame.setStatus(Globals.lang("Fetching Medline by id..."));
            List<BibtexEntry> bibs = MedlineImporter.fetchMedline(query, frame);
            if (bibs.size() == 0) {
                frame.showMessage(Globals.lang("No references found"));
            }
            for (BibtexEntry entry : bibs) {
                dialog.addEntry(entry);
            }
            return true;
        }
        if (query.length() > 0) {
            frame.setStatus(Globals.lang("Fetching Medline by term..."));
            String searchTerm = this.toSearchTerm(query);
            SearchResult result = this.getIds(searchTerm, 0, 1);
            if (result.count == 0) {
                frame.showMessage(Globals.lang("No references found"));
                return false;
            }
            int numberToFetch = result.count;
            if (numberToFetch > 20) {
                while (true) {
                    String strCount;
                    if ((strCount = JOptionPane.showInputDialog(Globals.lang("References found") + ": " + numberToFetch + "  " + Globals.lang("Number of references to fetch?"), (Object)Integer.toString(numberToFetch))) == null) {
                        frame.setStatus(Globals.lang("Medline import canceled"));
                        return false;
                    }
                    try {
                        numberToFetch = Integer.parseInt(strCount.trim());
                    }
                    catch (RuntimeException ex) {
                        frame.showMessage(Globals.lang("Please enter a valid number"));
                        continue;
                    }
                    break;
                }
            }
            for (int i = 0; i < numberToFetch && this.shouldContinue; i += 20) {
                int noToFetch = Math.min(20, numberToFetch - i);
                result = this.getIds(searchTerm, i, noToFetch);
                List<BibtexEntry> bibs = MedlineImporter.fetchMedline(result.ids, frame);
                for (BibtexEntry entry : bibs) {
                    dialog.addEntry(entry);
                }
                dialog.setProgress(i + noToFetch, numberToFetch);
            }
            return true;
        }
        frame.showMessage(Globals.lang("Please enter a comma separated list of Medline IDs (numbers) or search terms."), Globals.lang("Input error"), 0);
        return false;
    }

    protected class SearchResult {
        public int count = 0;
        public int retmax = 0;
        public int retstart = 0;
        public String ids = "";

        protected SearchResult() {
        }

        public void addID(String id) {
            this.ids = this.ids.equals("") ? id : this.ids + "," + id;
        }
    }
}

