/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.oo;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.bst.VM;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.format.FormatChars;
import org.antlr.runtime.RecognitionException;

public class BstWrapper {
    LayoutFormatter formatter = new FormatChars();
    VM vm = null;
    static Pattern bibitemTag = Pattern.compile("\\\\[a-zA-Z]*item\\{.*\\}");

    public void loadBstFile(File f) throws IOException, RecognitionException {
        this.vm = new VM(f);
    }

    public Map<String, String> processEntries(Collection<BibtexEntry> entries, BibtexDatabase database) {
        String result = this.vm.run(entries);
        return this.parseResult(result);
    }

    private Map<String, String> parseResult(String result) {
        HashMap<String, String> map = new HashMap<String, String>();
        Matcher m = bibitemTag.matcher(result);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ArrayList<Integer> endIndices = new ArrayList<Integer>();
        ArrayList<String> keys = new ArrayList<String>();
        while (m.find()) {
            if (indices.size() > 0) {
                endIndices.add(m.start());
            }
            System.out.println(m.start() + "  " + m.end());
            String tag = m.group();
            String key = tag.substring(9, tag.length() - 1);
            indices.add(m.end());
            keys.add(key);
        }
        int lastI = result.lastIndexOf("\\end{thebibliography}");
        if (lastI > 0 && lastI > (Integer)indices.get(indices.size() - 1)) {
            endIndices.add(lastI);
        }
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            int index = (Integer)indices.get(i);
            int endIndex = (Integer)endIndices.get(i);
            String part = result.substring(index, endIndex);
            map.put(key, this.formatter.format(part.trim().replaceAll("\\\\newblock ", " ")));
        }
        return map;
    }
}

