/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.sql.importer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexString;
import net.sf.jabref.MetaData;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.KeywordGroup;
import net.sf.jabref.groups.SearchGroup;
import net.sf.jabref.sql.DBImporterExporter;
import net.sf.jabref.sql.DBStrings;
import net.sf.jabref.sql.SQLUtil;

public abstract class DBImporter
extends DBImporterExporter {
    private final ArrayList<String> columnsNotConsideredForEntries = new ArrayList<String>(Arrays.asList("cite_key", "entry_types_id", "database_id", "jabref_eid", "entries_id"));

    protected abstract Connection connectToDB(DBStrings var1) throws Exception;

    protected abstract ResultSet readColumnNames(Connection var1) throws SQLException;

    public ArrayList<Object[]> performImport(Set<String> keySet, DBStrings dbs, List<String> listOfDBs) throws Exception {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        Connection conn = this.connectToDB(dbs);
        Iterator<String> itLista = listOfDBs.iterator();
        String jabrefDBs = "(";
        while (itLista.hasNext()) {
            jabrefDBs = jabrefDBs + "'" + itLista.next() + "',";
        }
        jabrefDBs = jabrefDBs.substring(0, jabrefDBs.length() - 1) + ")";
        ResultSet rsDatabase = SQLUtil.queryAllFromTable(conn, "jabref_database WHERE database_name IN " + jabrefDBs);
        while (rsDatabase.next()) {
            BibtexDatabase database = new BibtexDatabase();
            HashMap<String, BibtexEntryType> types = new HashMap<String, BibtexEntryType>();
            ResultSet rsEntryType = SQLUtil.queryAllFromTable(conn, "entry_types");
            while (rsEntryType.next()) {
                types.put(rsEntryType.getString("entry_types_id"), BibtexEntryType.getType(rsEntryType.getString("label")));
            }
            rsEntryType.getStatement().close();
            Iterator iterator = types.keySet().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
            ResultSet rsColumns = this.readColumnNames(conn);
            ArrayList<String> colNames = new ArrayList<String>();
            while (rsColumns.next()) {
                if (this.columnsNotConsideredForEntries.contains(rsColumns.getString(1))) continue;
                colNames.add(rsColumns.getString(1));
            }
            rsColumns.getStatement().close();
            String database_id = rsDatabase.getString("database_id");
            HashMap<String, BibtexEntry> entries = new HashMap<String, BibtexEntry>();
            ResultSet rsEntries = SQLUtil.queryAllFromTable(conn, "entries WHERE database_id= '" + database_id + "';");
            while (rsEntries.next()) {
                String id = rsEntries.getString("entries_id");
                BibtexEntry entry = new BibtexEntry(Util.createNeutralId(), (BibtexEntryType)types.get(rsEntries.getString("entry_types_id")));
                entry.setField("bibtexkey", rsEntries.getString("cite_key"));
                for (String col : colNames) {
                    String value = rsEntries.getString(col);
                    if (value == null) continue;
                    col = col.charAt(col.length() - 1) == '_' ? col.substring(0, col.length() - 1) : col;
                    entry.setField(col, value);
                }
                entries.put(id, entry);
                database.insertEntry(entry);
            }
            rsEntries.getStatement().close();
            ResultSet rsStrings = SQLUtil.queryAllFromTable(conn, "strings WHERE database_id='" + database_id + "'");
            while (rsStrings.next()) {
                String label = rsStrings.getString("label");
                String content = rsStrings.getString("content");
                if (label.equals("@PREAMBLE")) {
                    database.setPreamble(content);
                    continue;
                }
                BibtexString string = new BibtexString(Util.createNeutralId(), label, content);
                database.addString(string);
            }
            rsStrings.getStatement().close();
            MetaData metaData = new MetaData();
            metaData.initializeNewDatabase();
            this.importGroupsTree(metaData, entries, conn, database_id);
            result.add(new Object[]{database, metaData, rsDatabase.getString("database_name")});
        }
        return result;
    }

    public String findGroupTypeName(String groupId, Connection conn) throws SQLException {
        return SQLUtil.processQueryWithSingleResult(conn, "SELECT label FROM group_types WHERE group_types_id='" + groupId + "';");
    }

    public void importGroupsTree(MetaData metaData, HashMap<String, BibtexEntry> entries, Connection conn, String database_id) throws SQLException {
        HashMap<String, GroupTreeNode> groups = new HashMap<String, GroupTreeNode>();
        LinkedHashMap<GroupTreeNode, String> parentIds = new LinkedHashMap<GroupTreeNode, String>();
        GroupTreeNode rootNode = new GroupTreeNode(new AllEntriesGroup());
        ResultSet rsGroups = SQLUtil.queryAllFromTable(conn, "groups WHERE database_id='" + database_id + "' ORDER BY groups_id");
        while (rsGroups.next()) {
            AbstractGroup group = null;
            String typeId = this.findGroupTypeName(rsGroups.getString("group_types_id"), conn);
            if (typeId.equals("AllEntriesGroup:")) {
                groups.put(rsGroups.getString("groups_id"), rootNode);
            } else if (typeId.equals("ExplicitGroup:")) {
                group = new ExplicitGroup(rsGroups.getString("label"), rsGroups.getInt("hierarchical_context"));
            } else if (typeId.equals("KeywordGroup:")) {
                System.out.println("Keyw: " + rsGroups.getBoolean("case_sensitive"));
                group = new KeywordGroup(rsGroups.getString("label"), Util.unquote(rsGroups.getString("search_field"), '\\'), Util.unquote(rsGroups.getString("search_expression"), '\\'), rsGroups.getBoolean("case_sensitive"), rsGroups.getBoolean("reg_exp"), rsGroups.getInt("hierarchical_context"));
            } else if (typeId.equals("SearchGroup:")) {
                System.out.println("Search: " + rsGroups.getBoolean("case_sensitive"));
                group = new SearchGroup(rsGroups.getString("label"), Util.unquote(rsGroups.getString("search_expression"), '\\'), rsGroups.getBoolean("case_sensitive"), rsGroups.getBoolean("reg_exp"), rsGroups.getInt("hierarchical_context"));
            }
            if (group != null) {
                GroupTreeNode node = new GroupTreeNode(group);
                parentIds.put(node, rsGroups.getString("parent_id"));
                groups.put(rsGroups.getString("groups_id"), node);
            }
            for (GroupTreeNode node : parentIds.keySet()) {
                String parentId = (String)parentIds.get(node);
                GroupTreeNode parent = (GroupTreeNode)groups.get(parentId);
                if (parent == null) continue;
                parent.add(node);
            }
            ResultSet rsEntryGroup = SQLUtil.queryAllFromTable(conn, "entry_group");
            while (rsEntryGroup.next()) {
                String entryId = rsEntryGroup.getString("entries_id");
                String groupId = rsEntryGroup.getString("groups_id");
                GroupTreeNode node = (GroupTreeNode)groups.get(groupId);
                if (node == null || !(node.getGroup() instanceof ExplicitGroup)) continue;
                ExplicitGroup expGroup = (ExplicitGroup)node.getGroup();
                expGroup.addEntry(entries.get(entryId));
            }
            rsEntryGroup.getStatement().close();
            metaData.setGroups(rootNode);
        }
        rsGroups.getStatement().close();
    }
}

