/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.wizard.text.gui;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.imports.FreeCiteImporter;
import net.sf.jabref.wizard.integrity.gui.IntegrityMessagePanel;
import net.sf.jabref.wizard.text.TagToMarkedTextStore;
import net.sf.jabref.wizard.text.gui.BasicAction;
import net.sf.jabref.wizard.text.gui.OverlayPanel;
import net.sf.jabref.wizard.text.gui.PopupListener;

public class TextInputDialog
extends JDialog
implements ActionListener {
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private JButton insertButton = new JButton();
    private JButton parseWithFreeCiteButton = new JButton();
    private JPanel panel1 = new JPanel();
    private JPanel buttons = new JPanel();
    private JPanel rawPanel = new JPanel();
    private JPanel sourcePanel = new JPanel();
    private IntegrityMessagePanel warnPanel;
    private JList fieldList;
    private JRadioButton overRadio;
    private JRadioButton appRadio;
    private OverlayPanel testPanel;
    private BibtexEntry entry;
    public JPopupMenu inputMenu = new JPopupMenu();
    private StyledDocument doc;
    private JTextPane textPane;
    private JTextArea preview;
    private boolean inputChanged;
    private TagToMarkedTextStore marked;
    private JabRefFrame _frame;
    private boolean okPressed = false;

    public TextInputDialog(JabRefFrame frame, BasePanel panel, String title, boolean modal, BibtexEntry bibEntry) {
        super(frame, title, modal);
        this.warnPanel = new IntegrityMessagePanel(panel);
        this.inputChanged = true;
        this._frame = frame;
        this.entry = bibEntry;
        this.marked = new TagToMarkedTextStore();
        try {
            this.jbInit(frame);
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updateSourceView();
    }

    private void jbInit(JabRefFrame parent) {
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        String typeStr = Globals.lang("for");
        if (this.entry != null && this.entry.getType() != null) {
            typeStr = typeStr + " " + this.entry.getType().getName();
        }
        this.setTitle(Globals.lang("Plain_text_import") + " " + typeStr);
        this.getContentPane().add((Component)this.panel1, "Center");
        this.initRawPanel();
        this.initButtonPanel();
        this.initSourcePanel();
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (TextInputDialog.this.inputChanged) {
                    TextInputDialog.this.warnPanel.updateView(TextInputDialog.this.entry);
                }
            }
        });
        tabbed.add((Component)this.rawPanel, Globals.lang("Raw_source"));
        tabbed.add((Component)this.sourcePanel, Globals.lang("BibTeX_source"));
        tabbed.add((Component)this.warnPanel, Globals.lang("Messages_and_Hints"));
        this.panel1.setLayout(new BorderLayout());
        this.panel1.add((Component)tabbed, "Center");
        this.panel1.add((Component)this.buttons, "South");
        ActionMap am = this.buttons.getActionMap();
        InputMap im = this.buttons.getInputMap(2);
        im.put(parent.prefs().getKey("Close dialog"), "close");
        am.put("close", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TextInputDialog.this.dispose();
            }
        });
    }

    private void initRawPanel() {
        this.rawPanel.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.doc = this.textPane.getStyledDocument();
        this.addStylesToDocument(this.doc);
        try {
            this.doc.insertString(0, "", this.doc.getStyle("regular"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.testPanel = new OverlayPanel(this.textPane, Globals.lang("Text_Input_Area"));
        this.testPanel.setPreferredSize(new Dimension(450, 255));
        this.testPanel.setMaximumSize(new Dimension(450, Integer.MAX_VALUE));
        PasteAction pasteAction = new PasteAction();
        JMenuItem pasteMI = new JMenuItem(pasteAction);
        this.inputMenu.add(new MenuHeaderAction());
        this.inputMenu.addSeparator();
        this.inputMenu.add(pasteMI);
        PopupListener popupListener = new PopupListener(this.inputMenu);
        this.textPane.addMouseListener(popupListener);
        this.testPanel.addMouseListener(popupListener);
        JToolBar toolBar = new JToolBar();
        toolBar.add(new ClearAction());
        toolBar.setBorderPainted(false);
        toolBar.addSeparator();
        toolBar.add(pasteAction);
        toolBar.add(new LoadAction());
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)toolBar, "North");
        leftPanel.add((Component)this.testPanel, "Center");
        JPanel inputPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints con = new GridBagConstraints();
        con.weightx = 0.0;
        con.insets = new Insets(5, 5, 0, 5);
        con.fill = 2;
        inputPanel.setLayout(gbl);
        TitledBorder titledBorder1 = new TitledBorder(BorderFactory.createLineBorder(new Color(153, 153, 153), 2), Globals.lang("Input"));
        inputPanel.setBorder(titledBorder1);
        inputPanel.setMinimumSize(new Dimension(10, 10));
        this.fieldList = new JList<String>(this.getAllFields());
        this.fieldList.setCellRenderer(new SimpleCellRenderer(this.fieldList.getFont()));
        ListSelectionModel listSelectionModel = this.fieldList.getSelectionModel();
        listSelectionModel.setSelectionMode(0);
        listSelectionModel.addListSelectionListener(new FieldListSelectionHandler());
        this.fieldList.addMouseListener(new FieldListMouseListener());
        JScrollPane fieldScroller = new JScrollPane(this.fieldList);
        fieldScroller.setVerticalScrollBarPolicy(20);
        this.insertButton.setText(Globals.lang("Insert"));
        this.insertButton.addActionListener(this);
        this.parseWithFreeCiteButton.setText(Globals.lang("Parse with FreeCite"));
        this.parseWithFreeCiteButton.addActionListener(this);
        this.appRadio = new JRadioButton(Globals.lang("Append"));
        this.appRadio.setToolTipText(Globals.lang("append_the_selected_text_to_bibtex_key"));
        this.appRadio.setMnemonic(65);
        this.appRadio.setSelected(true);
        this.overRadio = new JRadioButton(Globals.lang("Override"));
        this.overRadio.setToolTipText(Globals.lang("override_the_bibtex_key_by_the_selected_text"));
        this.overRadio.setMnemonic(79);
        this.overRadio.setSelected(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.appRadio);
        group.add(this.overRadio);
        JPanel radioPanel = new JPanel(new GridLayout(0, 1));
        radioPanel.add(this.appRadio);
        radioPanel.add(this.overRadio);
        JLabel label1 = new JLabel(Globals.lang("Available fields"));
        con.gridwidth = 0;
        gbl.setConstraints(label1, con);
        inputPanel.add(label1);
        con.gridwidth = 0;
        con.gridheight = 8;
        con.weighty = 1.0;
        con.fill = 1;
        gbl.setConstraints(fieldScroller, con);
        inputPanel.add(fieldScroller);
        con.fill = 2;
        con.weighty = 0.0;
        con.gridwidth = 2;
        gbl.setConstraints(radioPanel, con);
        inputPanel.add(radioPanel);
        con.gridwidth = 0;
        gbl.setConstraints(this.insertButton, con);
        inputPanel.add(this.insertButton);
        this.rawPanel.add((Component)leftPanel, "Center");
        this.rawPanel.add((Component)inputPanel, "East");
        boolean loaded = false;
        JLabel desc = new JLabel("<html><h3>" + Globals.lang("Plain text import") + "</h3><p>" + Globals.lang("This is a simple copy and paste dialog. First load or paste some text into the text input area.<br>After that, you can mark text and assign it to a BibTeX field.") + "</p></html>");
        desc.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.rawPanel.add((Component)desc, "South");
    }

    private void initButtonPanel() {
        this.okButton.setText(Globals.lang("Accept"));
        this.okButton.addActionListener(this);
        this.cancelButton.setText(Globals.lang("Cancel"));
        this.cancelButton.addActionListener(this);
        ButtonBarBuilder bb = new ButtonBarBuilder(this.buttons);
        this.buttons.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        bb.addGlue();
        bb.addButton((JComponent)this.okButton);
        bb.addButton((JComponent)this.parseWithFreeCiteButton);
        bb.addButton((JComponent)this.cancelButton);
        bb.addGlue();
    }

    private void initSourcePanel() {
        this.preview = new JTextArea();
        this.preview.setEditable(false);
        JScrollPane paneScrollPane = new JScrollPane(this.preview);
        paneScrollPane.setVerticalScrollBarPolicy(22);
        paneScrollPane.setPreferredSize(new Dimension(500, 255));
        paneScrollPane.setMinimumSize(new Dimension(10, 10));
        this.sourcePanel.setLayout(new BorderLayout());
        this.sourcePanel.add((Component)paneScrollPane, "Center");
    }

    protected void addStylesToDocument(StyledDocument doc) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style regular = doc.addStyle("regular", def);
        StyleConstants.setFontFamily(def, "SansSerif");
        StyleConstants.setFontSize(def, 12);
        Style s = doc.addStyle("oldused", regular);
        StyleConstants.setItalic(s, true);
        StyleConstants.setForeground(s, Color.blue);
        s = doc.addStyle("used", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.blue);
        s = doc.addStyle("marked", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.red);
        s = doc.addStyle("small", regular);
        StyleConstants.setFontSize(s, 10);
        s = doc.addStyle("large", regular);
        StyleConstants.setFontSize(s, 16);
    }

    private void insertTextForTag() {
        String txt;
        String type = (String)this.fieldList.getSelectedValue();
        if (type != null && (txt = this.textPane.getSelectedText()) != null) {
            int selStart = this.textPane.getSelectionStart();
            int selEnd = this.textPane.getSelectionEnd();
            this.textPane.setSelectionEnd(selStart);
            this.doc.setCharacterAttributes(selStart, selEnd - selStart, this.doc.getStyle("marked"), true);
            if (this.overRadio.isSelected()) {
                this.entry.setField(type, txt);
                this.marked.setStyleForTag(type, "regular", this.doc);
                this.marked.insertPosition(type, selStart, selEnd);
            } else {
                this.marked.appendPosition(type, selStart, selEnd);
                String old = this.entry.getField(type);
                if (old != null) {
                    if (type.hashCode() == "author".hashCode()) {
                        this.entry.setField(type, old + " and " + txt);
                    } else {
                        this.entry.setField(type, old + txt);
                    }
                } else {
                    this.entry.setField(type, txt);
                }
            }
            this.updateSourceView();
        }
    }

    public boolean okPressed() {
        return this.okPressed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.okPressed = true;
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        } else if (source == this.insertButton) {
            this.insertTextForTag();
        } else if (source == this.parseWithFreeCiteButton && this.parseWithFreeCiteAndAddEntries()) {
            this.okPressed = false;
            this.dispose();
        }
    }

    private boolean parseWithFreeCiteAndAddEntries() {
        FreeCiteImporter fimp = new FreeCiteImporter();
        String text = this.textPane.getText();
        text = text.replace(Globals.NEWLINE.concat(Globals.NEWLINE), "##NEWLINE##");
        text = text.replace("/".concat(Globals.NEWLINE), "/");
        text = text.replace(Globals.NEWLINE, " ");
        List<BibtexEntry> importedEntries = fimp.importEntries(text = text.replace("##NEWLINE##", Globals.NEWLINE), (OutputPrinter)JabRef.jrf);
        if (importedEntries != null) {
            Util.setAutomaticFields(importedEntries, false, false, true);
            for (BibtexEntry e : importedEntries) {
                JabRef.jrf.basePanel().insertEntry(e);
            }
            return true;
        }
        return false;
    }

    private final void updateSourceView() {
        StringWriter sw = new StringWriter(200);
        try {
            this.entry.write(sw, new LatexFieldFormatter(), false);
            String srcString = sw.getBuffer().toString();
            this.preview.setText(srcString);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fieldList.clearSelection();
    }

    private final String[] getAllFields() {
        int i;
        ArrayList<String> f = new ArrayList<String>();
        String[] req = this.entry.getRequiredFields();
        String[] opt = this.entry.getOptionalFields();
        String[] allFields = BibtexFields.getAllFieldNames();
        for (i = 0; i < req.length; ++i) {
            f.add(req[i]);
        }
        for (i = 0; i < opt.length; ++i) {
            f.add(opt[i]);
        }
        for (i = 0; i < allFields.length; ++i) {
            if (f.contains(allFields[i])) continue;
            f.add(allFields[i]);
        }
        return f.toArray(new String[f.size()]);
    }

    class FieldListMouseListener
    extends MouseAdapter {
        FieldListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TextInputDialog.this.insertTextForTag();
            }
        }
    }

    class SimpleCellRenderer
    extends DefaultListCellRenderer {
        private Font baseFont;
        private Font usedFont;
        private ImageIcon okIcon = GUIGlobals.getImage("complete");
        private ImageIcon needIcon = GUIGlobals.getImage("wrong");

        public SimpleCellRenderer(Font normFont) {
            this.baseFont = normFont;
            this.usedFont = this.baseFont.deriveFont(2);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean iss, boolean chf) {
            super.getListCellRendererComponent((JList<?>)list, value, index, iss, chf);
            String s = value.toString();
            if (TextInputDialog.this.entry.getField(s) != null) {
                this.setForeground(Color.gray);
                this.setFont(this.usedFont);
                this.setIcon(this.okIcon);
                this.setToolTipText("filled");
            } else {
                this.setIcon(this.needIcon);
                this.setToolTipText("field is missing");
            }
            return this;
        }
    }

    class FieldListSelectionHandler
    implements ListSelectionListener {
        private int lastIndex = -1;

        FieldListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isAdjusting;
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int index = lsm.getAnchorSelectionIndex();
            if (index != this.lastIndex && !(isAdjusting = e.getValueIsAdjusting())) {
                if (this.lastIndex > -1) {
                    String tag1 = TextInputDialog.this.fieldList.getModel().getElementAt(this.lastIndex).toString();
                    TextInputDialog.this.marked.setStyleForTag(tag1, "used", TextInputDialog.this.doc);
                }
                String tag2 = TextInputDialog.this.fieldList.getModel().getElementAt(index).toString();
                TextInputDialog.this.marked.setStyleForTag(tag2, "marked", TextInputDialog.this.doc);
                this.lastIndex = index;
            }
        }
    }

    class MenuHeaderAction
    extends BasicAction {
        public MenuHeaderAction() {
            super("Edit");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    class ClearAction
    extends BasicAction {
        public ClearAction() {
            super("Clear", "Clear_inputarea", GUIGlobals.getIconUrl("new"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TextInputDialog.this.textPane.setText("");
        }
    }

    class LoadAction
    extends BasicAction {
        public LoadAction() {
            super("Open", "Open_file", GUIGlobals.getIconUrl("open"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                String chosen = null;
                chosen = FileDialogs.getNewFile((JFrame)TextInputDialog.this._frame, null, null, ".txt", 0, false);
                if (chosen != null) {
                    File newFile = new File(chosen);
                    TextInputDialog.this.doc.remove(0, TextInputDialog.this.doc.getLength());
                    EditorKit eKit = TextInputDialog.this.textPane.getEditorKit();
                    if (eKit != null) {
                        eKit.read(new FileInputStream(newFile), (Document)TextInputDialog.this.doc, 0);
                        TextInputDialog.this.doc.setLogicalStyle(0, TextInputDialog.this.doc.getStyle("regular"));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String data = ClipBoardManager.clipBoard.getClipboardContents();
            if (data != null) {
                int selStart = TextInputDialog.this.textPane.getSelectionStart();
                int selEnd = TextInputDialog.this.textPane.getSelectionEnd();
                if (selEnd - selStart > 0) {
                    TextInputDialog.this.textPane.replaceSelection("");
                }
                int cPos = TextInputDialog.this.textPane.getCaretPosition();
                try {
                    TextInputDialog.this.doc.insertString(cPos, data, TextInputDialog.this.doc.getStyle("regular"));
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }
}

