/*
 * Decompiled with CFR 0.152.
 */
package org.sciplore.deserialize.reader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sciplore.deserialize.reader.ObjectCreatorMapper;
import org.sciplore.deserialize.reader.ObjectReader;
import org.sciplore.io.StringInputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlResourceReader<K>
extends ObjectReader {
    public XmlResourceReader(ObjectCreatorMapper creatorMapper) {
        super(creatorMapper);
    }

    @Override
    protected Document getDom(InputStream is) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(is);
            doc.normalize();
            return doc;
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return null;
    }

    public K parse(File file) {
        try {
            return (K)this.parse(new FileReader(file));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public K parse(String uri) {
        return this.parse(new File(uri));
    }

    public K parse(URI uri) {
        return this.parse(new File(uri));
    }

    public K parseContent(String content, String charsetName) throws UnsupportedEncodingException {
        return (K)this.parse(new StringInputStream(content, charsetName));
    }
}

