/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil;

public final class EncogMath {
    public static double deg2rad(double deg) {
        return deg * (Math.PI / 180);
    }

    public static boolean doubleEquals(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-13;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static int maxIndex(double[] array) {
        int result = -1;
        for (int i = 0; i < array.length; ++i) {
            if (result != -1 && !(array[result] < array[i])) continue;
            result = i;
        }
        return result;
    }

    public static int minIndex(double[] array) {
        int result = -1;
        for (int i = 0; i < array.length; ++i) {
            if (result != -1 && !(array[result] > array[i])) continue;
            result = i;
        }
        return result;
    }

    public static double rad2deg(double rad) {
        return rad * 57.29577951308232;
    }

    public static double factorial(int x) {
        double result = 1.0;
        for (int i = 1; i <= x; ++i) {
            result *= (double)i;
        }
        return result;
    }

    private EncogMath() {
    }

    public static double square(double d) {
        return d * d;
    }

    public static int sign(double value) {
        if (Math.abs(value) < 1.0E-13) {
            return 0;
        }
        if (value > 0.0) {
            return 1;
        }
        return -1;
    }

    public static int thirds(double value) {
        if (value < -0.3333333333333333) {
            return -1;
        }
        if (value > 0.3333333333333333) {
            return 1;
        }
        return 0;
    }
}

