/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import org.encog.mathutil.ComplexNumber;
import org.encog.ml.data.MLComplexData;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.util.kmeans.Centroid;

public class BasicMLComplexData
implements MLComplexData {
    private ComplexNumber[] data;

    public BasicMLComplexData(double[] d) {
        this(d.length);
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new ComplexNumber(d[i], 0.0);
        }
    }

    public BasicMLComplexData(ComplexNumber[] d) {
        this.data = d;
    }

    public BasicMLComplexData(int size) {
        this.data = new ComplexNumber[size];
    }

    public BasicMLComplexData(MLData d) {
        this(d.size());
        if (d instanceof MLComplexData) {
            MLComplexData c = (MLComplexData)d;
            for (int i = 0; i < d.size(); ++i) {
                this.data[i] = new ComplexNumber(c.getComplexData(i));
            }
        } else {
            for (int i = 0; i < d.size(); ++i) {
                this.data[i] = new ComplexNumber(d.getData(i), 0.0);
            }
        }
    }

    @Override
    public void add(int index, double value) {
        this.data[index].plus(new ComplexNumber(value, 0.0));
    }

    @Override
    public void add(int index, ComplexNumber value) {
        this.data[index] = this.data[index].plus(value);
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new ComplexNumber(0.0, 0.0);
        }
    }

    @Override
    public MLData clone() {
        return new BasicMLData(this);
    }

    @Override
    public double[] getData() {
        double[] d = new double[this.data.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = this.data[i].getReal();
        }
        return d;
    }

    @Override
    public ComplexNumber[] getComplexData() {
        return this.data;
    }

    @Override
    public double getData(int index) {
        return this.data[index].getReal();
    }

    @Override
    public ComplexNumber getComplexData(int index) {
        return this.data[index];
    }

    @Override
    public void setData(double[] theData) {
        for (int i = 0; i < theData.length; ++i) {
            this.data[i] = new ComplexNumber(theData[i], 0.0);
        }
    }

    @Override
    public void setData(ComplexNumber[] theData) {
        this.data = theData;
    }

    @Override
    public void setData(int index, double d) {
        this.data[index] = new ComplexNumber(d, 0.0);
    }

    @Override
    public void setData(int index, ComplexNumber d) {
        this.data[index] = d;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.data[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Centroid<MLData> createCentroid() {
        return null;
    }
}

