/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.util.EngineArray;
import org.encog.util.obj.ObjectCloner;

public class BasicMLDataSet
implements Serializable,
MLDataSet {
    private static final long serialVersionUID = -2279722928570071183L;
    private List<MLDataPair> data = new ArrayList<MLDataPair>();

    public BasicMLDataSet() {
    }

    public BasicMLDataSet(double[][] input, double[][] ideal) {
        if (ideal != null) {
            for (int i = 0; i < input.length; ++i) {
                BasicMLData inputData = new BasicMLData(input[i]);
                BasicMLData idealData = new BasicMLData(ideal[i]);
                this.add(inputData, idealData);
            }
        } else {
            for (double[] element : input) {
                BasicMLData inputData = new BasicMLData(element);
                this.add(inputData);
            }
        }
    }

    public BasicMLDataSet(List<MLDataPair> theData) {
        this.data = theData;
    }

    public BasicMLDataSet(MLDataSet set) {
        int inputCount = set.getInputSize();
        int idealCount = set.getIdealSize();
        for (MLDataPair pair : set) {
            BasicMLData input = null;
            BasicMLData ideal = null;
            if (inputCount > 0) {
                input = new BasicMLData(inputCount);
                EngineArray.arrayCopy(pair.getInputArray(), input.getData());
            }
            if (idealCount > 0) {
                ideal = new BasicMLData(idealCount);
                EngineArray.arrayCopy(pair.getIdealArray(), ideal.getData());
            }
            this.add(new BasicMLDataPair(input, ideal));
        }
    }

    @Override
    public void add(MLData theData) {
        this.data.add(new BasicMLDataPair(theData));
    }

    @Override
    public void add(MLData inputData, MLData idealData) {
        BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
        this.data.add(pair);
    }

    @Override
    public void add(MLDataPair inputData) {
        this.data.add(inputData);
    }

    public Object clone() {
        return ObjectCloner.deepCopy(this);
    }

    @Override
    public void close() {
    }

    public List<MLDataPair> getData() {
        return this.data;
    }

    @Override
    public int getIdealSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        MLDataPair first = this.data.get(0);
        if (first.getIdeal() == null) {
            return 0;
        }
        return first.getIdeal().size();
    }

    @Override
    public int getInputSize() {
        if (this.data.isEmpty()) {
            return 0;
        }
        MLDataPair first = this.data.get(0);
        return first.getInput().size();
    }

    @Override
    public void getRecord(long index, MLDataPair pair) {
        MLDataPair source = this.data.get((int)index);
        pair.setInputArray(source.getInputArray());
        if (pair.getIdealArray() != null) {
            pair.setIdealArray(source.getIdealArray());
        }
    }

    @Override
    public long getRecordCount() {
        return this.data.size();
    }

    @Override
    public boolean isSupervised() {
        if (this.data.size() == 0) {
            return false;
        }
        return this.data.get(0).isSupervised();
    }

    @Override
    public Iterator<MLDataPair> iterator() {
        BasicMLIterator result = new BasicMLIterator();
        return result;
    }

    @Override
    public MLDataSet openAdditional() {
        return new BasicMLDataSet(this.data);
    }

    public void setData(List<MLDataPair> theData) {
        this.data = theData;
    }

    public static List<MLDataPair> toList(MLDataSet theSet) {
        ArrayList<MLDataPair> list = new ArrayList<MLDataPair>();
        for (MLDataPair pair : theSet) {
            list.add(pair);
        }
        return list;
    }

    @Override
    public int size() {
        return (int)this.getRecordCount();
    }

    @Override
    public MLDataPair get(int index) {
        return this.data.get(index);
    }

    public class BasicMLIterator
    implements Iterator<MLDataPair> {
        private int currentIndex = 0;

        @Override
        public final boolean hasNext() {
            return this.currentIndex < BasicMLDataSet.this.data.size();
        }

        @Override
        public final MLDataPair next() {
            if (!this.hasNext()) {
                return null;
            }
            return (MLDataPair)BasicMLDataSet.this.data.get(this.currentIndex++);
        }

        @Override
        public final void remove() {
            throw new EncogError("Called remove, unsupported operation.");
        }
    }
}

