/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataError;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.MLSequenceSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;
import org.encog.util.EngineArray;
import org.encog.util.obj.ObjectCloner;

public class BasicMLSequenceSet
implements Serializable,
MLSequenceSet {
    private static final long serialVersionUID = -2279722928570071183L;
    private List<MLDataSet> sequences = new ArrayList<MLDataSet>();
    private MLDataSet currentSequence;

    public BasicMLSequenceSet() {
        this.currentSequence = new BasicMLDataSet();
        this.sequences.add(this.currentSequence);
    }

    public BasicMLSequenceSet(BasicMLSequenceSet other) {
        this.sequences = other.sequences;
        this.currentSequence = other.currentSequence;
    }

    public BasicMLSequenceSet(double[][] input, double[][] ideal) {
        this.currentSequence = new BasicMLDataSet(input, ideal);
        this.sequences.add(this.currentSequence);
    }

    public BasicMLSequenceSet(List<MLDataPair> theData) {
        this.currentSequence = new BasicMLDataSet(theData);
        this.sequences.add(this.currentSequence);
    }

    public BasicMLSequenceSet(MLDataSet set) {
        this.currentSequence = new BasicMLDataSet();
        this.sequences.add(this.currentSequence);
        int inputCount = set.getInputSize();
        int idealCount = set.getIdealSize();
        for (MLDataPair pair : set) {
            BasicMLData input = null;
            BasicMLData ideal = null;
            if (inputCount > 0) {
                input = new BasicMLData(inputCount);
                EngineArray.arrayCopy(pair.getInputArray(), input.getData());
            }
            if (idealCount > 0) {
                ideal = new BasicMLData(idealCount);
                EngineArray.arrayCopy(pair.getIdealArray(), ideal.getData());
            }
            this.currentSequence.add(new BasicMLDataPair(input, ideal));
        }
    }

    @Override
    public void add(MLData theData) {
        this.currentSequence.add(theData);
    }

    @Override
    public void add(MLData inputData, MLData idealData) {
        BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
        this.currentSequence.add(pair);
    }

    @Override
    public void add(MLDataPair inputData) {
        this.currentSequence.add(inputData);
    }

    public Object clone() {
        return ObjectCloner.deepCopy(this);
    }

    @Override
    public void close() {
    }

    @Override
    public int getIdealSize() {
        if (this.sequences.get(0).getRecordCount() == 0L) {
            return 0;
        }
        return this.sequences.get(0).getIdealSize();
    }

    @Override
    public int getInputSize() {
        if (this.sequences.get(0).getRecordCount() == 0L) {
            return 0;
        }
        return this.sequences.get(0).getIdealSize();
    }

    @Override
    public void getRecord(long index, MLDataPair pair) {
        long recordIndex;
        int sequenceIndex = 0;
        for (recordIndex = index; this.sequences.get(sequenceIndex).getRecordCount() < recordIndex; recordIndex -= this.sequences.get(sequenceIndex).getRecordCount()) {
            if (++sequenceIndex <= this.sequences.size()) continue;
            throw new MLDataError("Record out of range: " + index);
        }
        this.sequences.get(sequenceIndex).getRecord(recordIndex, pair);
    }

    @Override
    public long getRecordCount() {
        long result = 0L;
        for (MLDataSet ds : this.sequences) {
            result += ds.getRecordCount();
        }
        return result;
    }

    @Override
    public boolean isSupervised() {
        if (this.sequences.get(0).getRecordCount() == 0L) {
            return false;
        }
        return this.sequences.get(0).isSupervised();
    }

    @Override
    public Iterator<MLDataPair> iterator() {
        BasicMLSeqIterator result = new BasicMLSeqIterator();
        return result;
    }

    @Override
    public MLDataSet openAdditional() {
        return new BasicMLSequenceSet(this);
    }

    @Override
    public void startNewSequence() {
        if (this.currentSequence.getRecordCount() > 0L) {
            this.currentSequence = new BasicMLDataSet();
            this.sequences.add(this.currentSequence);
        }
    }

    @Override
    public int getSequenceCount() {
        return this.sequences.size();
    }

    @Override
    public MLDataSet getSequence(int i) {
        return this.sequences.get(i);
    }

    @Override
    public Collection<MLDataSet> getSequences() {
        return this.sequences;
    }

    @Override
    public int size() {
        return (int)this.getRecordCount();
    }

    @Override
    public MLDataPair get(int index) {
        MLDataPair result = BasicMLDataPair.createPair(this.getInputSize(), this.getIdealSize());
        this.getRecord(index, result);
        return result;
    }

    @Override
    public void add(MLDataSet sequence) {
        for (MLDataPair pair : sequence) {
            this.add(pair);
        }
    }

    public class BasicMLSeqIterator
    implements Iterator<MLDataPair> {
        private int currentIndex = 0;
        private int currentSequenceIndex = 0;

        @Override
        public boolean hasNext() {
            if (this.currentSequenceIndex >= BasicMLSequenceSet.this.sequences.size()) {
                return false;
            }
            MLDataSet seq = (MLDataSet)BasicMLSequenceSet.this.sequences.get(this.currentSequenceIndex);
            return (long)this.currentIndex < seq.getRecordCount();
        }

        @Override
        public MLDataPair next() {
            if (!this.hasNext()) {
                return null;
            }
            MLDataSet target = (MLDataSet)BasicMLSequenceSet.this.sequences.get(this.currentSequenceIndex);
            MLDataPair result = ((BasicMLDataSet)target).getData().get(this.currentIndex);
            ++this.currentIndex;
            if ((long)this.currentIndex >= target.getRecordCount()) {
                this.currentIndex = 0;
                ++this.currentSequenceIndex;
            }
            return result;
        }

        @Override
        public void remove() {
            throw new EncogError("Called remove, unsupported operation.");
        }
    }
}

