/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.freeform.basic;

import java.io.Serializable;
import org.encog.neural.freeform.FreeformConnection;
import org.encog.neural.freeform.FreeformNeuron;

public class BasicFreeformConnection
implements FreeformConnection,
Serializable {
    private static final long serialVersionUID = 1L;
    private double weight = 0.0;
    private FreeformNeuron source;
    private FreeformNeuron target;
    private boolean recurrent = false;
    private double[] tempTraining;

    public BasicFreeformConnection(FreeformNeuron theSource, FreeformNeuron theTarget) {
        this.source = theSource;
        this.target = theTarget;
    }

    @Override
    public void addTempTraining(int i, double value) {
        int n = i;
        this.tempTraining[n] = this.tempTraining[n] + value;
    }

    @Override
    public void addWeight(double delta) {
        this.weight += delta;
    }

    @Override
    public void allocateTempTraining(int l) {
        this.tempTraining = new double[l];
    }

    @Override
    public void clearTempTraining() {
        this.tempTraining = null;
    }

    @Override
    public FreeformNeuron getSource() {
        return this.source;
    }

    @Override
    public FreeformNeuron getTarget() {
        return this.target;
    }

    @Override
    public double getTempTraining(int index) {
        return this.tempTraining[index];
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    public boolean isRecurrent() {
        return this.recurrent;
    }

    @Override
    public void setRecurrent(boolean recurrent) {
        this.recurrent = recurrent;
    }

    @Override
    public void setSource(FreeformNeuron source) {
        this.source = source;
    }

    @Override
    public void setTarget(FreeformNeuron target) {
        this.target = target;
    }

    @Override
    public void setTempTraining(int index, double value) {
        this.tempTraining[index] = value;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[BasicFreeformConnection: ");
        result.append("source=");
        result.append(this.source.toString());
        result.append(",target=");
        result.append(this.target.toString());
        result.append(",weight=");
        result.append(this.weight);
        result.append("]");
        return result.toString();
    }
}

