/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;
import org.encog.neural.pattern.NeuralNetworkPattern;

public class FeedForwardPattern
implements NeuralNetworkPattern {
    private int inputNeurons;
    private int outputNeurons;
    private ActivationFunction activationHidden;
    private ActivationFunction activationOutput;
    private final List<Integer> hidden = new ArrayList<Integer>();

    @Override
    public void addHiddenLayer(int count) {
        this.hidden.add(count);
    }

    @Override
    public void clear() {
        this.hidden.clear();
    }

    @Override
    public MLMethod generate() {
        if (this.activationOutput == null) {
            this.activationOutput = this.activationHidden;
        }
        BasicLayer input = new BasicLayer(null, true, this.inputNeurons);
        BasicNetwork result = new BasicNetwork();
        result.addLayer(input);
        for (Integer count : this.hidden) {
            BasicLayer hidden = new BasicLayer(this.activationHidden, true, count);
            result.addLayer(hidden);
        }
        BasicLayer output = new BasicLayer(this.activationOutput, false, this.outputNeurons);
        result.addLayer(output);
        result.getStructure().finalizeStructure();
        result.reset();
        return result;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        this.activationHidden = activation;
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public ActivationFunction getActivationOutput() {
        return this.activationOutput;
    }

    public void setActivationOutput(ActivationFunction activationOutput) {
        this.activationOutput = activationOutput;
    }
}

