/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.automaton;

import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RegExp;

public class TooComplexToDeterminizeException
extends RuntimeException {
    private final Automaton automaton;
    private final RegExp regExp;
    private final int maxDeterminizedStates;

    public TooComplexToDeterminizeException(RegExp regExp, TooComplexToDeterminizeException cause) {
        super("Determinizing " + regExp.getOriginalString() + " would result in more than " + cause.maxDeterminizedStates + " states.", cause);
        this.regExp = regExp;
        this.automaton = cause.automaton;
        this.maxDeterminizedStates = cause.maxDeterminizedStates;
    }

    public TooComplexToDeterminizeException(Automaton automaton, int maxDeterminizedStates) {
        super("Determinizing automaton would result in more than " + maxDeterminizedStates + " states.");
        this.automaton = automaton;
        this.regExp = null;
        this.maxDeterminizedStates = maxDeterminizedStates;
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public RegExp getRegExp() {
        return this.regExp;
    }

    public int getMaxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }
}

