## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(networkscaleup)
library(ggplot2)

## -----------------------------------------------------------------------------
set.seed(2)
sim_dat_1 <- make_ard(family = "poisson")
sim_dat_2 <- make_ard(
  p = 6,
  p_local_nonzero = 2,
  p_global_nonzero = 1,
  family = "poisson"
)

## -----------------------------------------------------------------------------
pois_fit_list_1 <- fit_mle(sim_dat_1$ard, family = "poisson")

pois_root_1 <- hang_rootogram_ard(
  ard = sim_dat_1$ard,
  model_fit = pois_fit_list_1
)

pois_root_1 + labs(subtitle = "Fitting True Poisson Model, no covariates.")

## -----------------------------------------------------------------------------
pois_fit_list_2 <- fit_mle(sim_dat_2$ard, family = "poisson")

pois_root_2 <- hang_rootogram_ard(
  ard = sim_dat_2$ard,
  model_fit = pois_fit_list_2
)

pois_root_2 + labs(subtitle = "Fitting Poisson Model, ignoring true covariates.")

## -----------------------------------------------------------------------------
cov_p_list <- cov_plots(
  ard = sim_dat_2$ard,
  model_fit = pois_fit_list_2,
  x_cov = sim_dat_2$x_cov,
  se = T
)

local_cov_plot <- cov_p_list$Group_plot
global_cov_plot <- cov_p_list$Respondent_plot

local_cov_plot # Suggests x2 and x4
global_cov_plot # Suggests x1

