% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{str_which}
\alias{str_which}
\title{Find matching indices}
\usage{
str_which(string, pattern, negate = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{negate}{If \code{TRUE}, inverts the resulting boolean vector.}
}
\value{
An integer vector, usually smaller than \code{string}.
}
\description{
\code{str_which()} returns the indices of \code{string} where there's at least
one match to \code{pattern}. It's a wrapper around
\code{which(str_detect(x, pattern))}, and is equivalent to \code{grep(pattern, x)}.
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_which(fruit, "a")

# Elements that don't match
str_which(fruit, "^p", negate = TRUE)

# Missings never match
str_which(c("a", NA, "b"), ".")
}
