## ----include = FALSE----------------------------------------------------------
Sys.setenv(R_USER_LIBS = tempdir())  #Just in case for CRAN
library(biodosetools)
knitr::opts_chunk$set(
  fig.dpi = 96,
  collapse = TRUE,
  comment = "#>"
)

## ----sc-trans-fit-01, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Stains color options', 'Chromosome data' and 'Genomic conversion factor' boxes in the dose-effect fitting module."----
knitr::include_graphics("figures/screenshot-translocations-fit-01.png")

## ----trans-genome-factpr-fit, tidy=FALSE--------------------------------------
genome_factor <- calculate_genome_factor(
  dna_table = dna_content_fractions_morton,
  chromosome = c(1, 4, 11),
  color = rep("Red", 3),
  sex = "female"
)

## -----------------------------------------------------------------------------
genome_factor

## ----trans-count-data, tidy=TRUE, tidy.opts=list(width.cutoff=60)-------------
count_data <- system.file("extdata", "count-data-rodriguez-2004.csv", package = "biodosetools") %>%
  utils::read.csv() %>%
  calculate_aberr_table(type = "count") %>%
  dplyr::mutate(N = N * genome_factor)

## -----------------------------------------------------------------------------
count_data

## ----sc-trans-fit-04, echo=FALSE, out.width='100%', fig.align='center', fig.cap="'Results' tabbed box, 'Curve plot' and 'Export results' boxes in the dose-effect fitting module."----
knitr::include_graphics("figures/screenshot-translocations-fit-04.png")

## ----trans-fit-results--------------------------------------------------------
fit_results <- fit(
  count_data = count_data,
  model_formula = "lin-quad",
  model_family = "automatic",
  fit_link = "identity",
  aberr_module = "translocations"
)

## -----------------------------------------------------------------------------
names(fit_results)

## ----trans-fit-coeffs-r-------------------------------------------------------
fit_results$fit_coeffs

## ----trans-fit-dose-curve, fig.width=6, fig.height=3.5, fig.align='center', fig.cap="Plot of dose-effect curve generated by \\{biodosetools\\}. The grey shading indicates the uncertainties associated with the calibration curve."----
plot_fit_dose_curve(
  fit_results,
  aberr_name = "Translocations",
  place = "UI"
)

