library(R6)
# Create the test cases
test_that("AMap class methods work correctly", {
  # Mock the fastmap function
  mock_fastmap <- mockery::mock(
    get = function(key) "mocked_value",
    set = function(key, value) NULL,
    mget = function(keys) list(a = "mocked_value_a", b = "mocked_value_b"),
    mset = function(...) NULL,
    has = function(key) TRUE,
    keys = function(sort = FALSE) c("a", "b"),
    as_list = function(sort = FALSE) list(a = "mocked_value_a", b = "mocked_value_b"),
    reset = function() NULL,
    size = function() 2
  )

  # Stub the fastmap function
  mockery::stub(AMap$new()$initialize, "fastmap", mock_fastmap)

  # Create an instance of Map
  map_instance <- AMap$new()

  # Test set and get methods
  map_instance$set("key1", "value1")
  expect_equal(map_instance$get("key1"), "value1")

  # Test mget and mset methods
  map_instance$mset(a = "value_a", b = "value_b")
  expect_equal(map_instance$mget(c("a", "b")), list(a = "value_a", b = "value_b"))

  # Test remove method
  expect_equal(map_instance$remove("key1"), "value1")

  # Test containsKey method
  # expect_true(map_instance$containsKey("key1"))

  # Test keys method
  expect_equal(map_instance$keys(), c("b", "a"))

  # Test values method
  expect_equal(map_instance$values(), list(b = "value_b", a = "value_a"))

  # Test clear method
  map_instance$clear()
  expect_equal(map_instance$size(), 0)

  # Test size method
  expect_equal(map_instance$size(), 0)

  # Test as.list.Map function
  # expect_equal(as.list(map_instance), list(a = "mocked_value_a", b = "mocked_value_b"))

  # Test length.Map function
  expect_equal(length(map_instance), 0)
})

