/*
 * Decompiled with CFR 0.152.
 */
package org.ohdsi.simpleDesign;

import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.DesignMatrix;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.NormalDistribution;

public class SimpleLinearModel
extends AbstractModelLikelihood {
    private final Parameter argument;
    private final DesignMatrix designMatrix;
    private final Parameter effects;
    private final Parameter precision;
    private boolean likelihoodKnown;
    private boolean storedLikelihoodKnown;
    private boolean innerProductKnown;
    private boolean storedInnerProductKnown;
    private double logLikelihood;
    private double storedLogLikelihood;
    private double[] innerProduct;
    private double[] storedInnerProduct;

    public SimpleLinearModel(String name, Parameter argument, DesignMatrix designMatrix, Parameter effects, Parameter precision) {
        super(name);
        this.argument = argument;
        this.designMatrix = designMatrix;
        this.effects = effects;
        this.precision = precision;
        if (designMatrix.getRowDimension() != argument.getDimension()) {
            throw new IllegalArgumentException("Invalid parameter dimensions");
        }
        if (designMatrix.getColumnDimension() != effects.getDimension()) {
            throw new IllegalArgumentException("Invalid parameter dimensions");
        }
        this.addVariable((Variable)argument);
        this.addVariable((Variable)designMatrix);
        this.addVariable((Variable)effects);
        this.addVariable((Variable)precision);
        this.innerProduct = new double[designMatrix.getRowDimension()];
        this.storedInnerProduct = new double[designMatrix.getRowDimension()];
        this.likelihoodKnown = false;
        this.innerProductKnown = false;
    }

    private void computeInnerProduct(double[] product) {
        int i = 0;
        while (i < this.designMatrix.getRowDimension()) {
            product[i] = 0.0;
            int j = 0;
            while (j < this.designMatrix.getColumnDimension()) {
                int n = i;
                product[n] = product[n] + this.designMatrix.getParameterValue(i, j) * this.effects.getParameterValue(j);
                ++j;
            }
            ++i;
        }
    }

    private double calculateLogLikelihood() {
        if (!this.innerProductKnown) {
            this.computeInnerProduct(this.innerProduct);
            this.innerProductKnown = true;
        }
        double tau = this.precision.getParameterValue(0);
        double sd = 1.0 / Math.sqrt(tau);
        double logLikelihood = 0.0;
        int i = 0;
        while (i < this.argument.getDimension()) {
            logLikelihood += NormalDistribution.logPdf((double)this.argument.getParameterValue(i), (double)this.innerProduct[i], (double)sd);
            ++i;
        }
        return logLikelihood;
    }

    protected void handleModelChangedEvent(Model model, Object o, int i) {
        throw new RuntimeException("Should not occur");
    }

    protected void handleVariableChangedEvent(Variable variable, int i, Variable.ChangeType changeType) {
        if (variable == this.precision || variable == this.argument) {
            this.likelihoodKnown = false;
        } else if (variable == this.designMatrix || variable == this.effects) {
            this.likelihoodKnown = false;
            this.innerProductKnown = false;
        } else {
            throw new RuntimeException("Should not get here");
        }
    }

    protected void storeState() {
        this.storedLikelihoodKnown = this.likelihoodKnown;
        this.storedLogLikelihood = this.logLikelihood;
        this.storedInnerProductKnown = this.innerProductKnown;
        if (this.innerProductKnown) {
            System.arraycopy(this.innerProduct, 0, this.storedInnerProduct, 0, this.innerProduct.length);
        }
    }

    protected void restoreState() {
        this.likelihoodKnown = this.storedLikelihoodKnown;
        this.logLikelihood = this.storedLogLikelihood;
        this.innerProductKnown = this.storedInnerProductKnown;
        if (this.innerProductKnown) {
            double[] swap = this.innerProduct;
            this.innerProduct = this.storedInnerProduct;
            this.storedInnerProduct = swap;
        }
    }

    protected void acceptState() {
    }

    public Model getModel() {
        return this;
    }

    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.calculateLogLikelihood();
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    public void makeDirty() {
        this.likelihoodKnown = false;
        this.innerProductKnown = false;
    }

    public final Parameter getArgument() {
        return this.argument;
    }

    public final DesignMatrix getDesignMatrix() {
        return this.designMatrix;
    }

    public final Parameter getEffects() {
        return this.effects;
    }

    public final Parameter getPrecision() {
        return this.precision;
    }

    public final double[] getInnerProduct() {
        if (!this.innerProductKnown) {
            this.computeInnerProduct(this.innerProduct);
            this.innerProductKnown = true;
        }
        return this.innerProduct;
    }
}

