/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store.jdbc.adapter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.activemq.store.jdbc.adapter.DefaultJDBCAdapter;
import org.apache.activemq.util.ByteArrayInputStream;

public class StreamJDBCAdapter
extends DefaultJDBCAdapter {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getBinaryData(ResultSet rs, int index) throws SQLException {
        try (InputStream is = rs.getBinaryStream(index);){
            byte[] byArray;
            try (ByteArrayOutputStream os = new ByteArrayOutputStream(4096);){
                int ch;
                while ((ch = is.read()) >= 0) {
                    os.write(ch);
                }
                byArray = os.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw (SQLException)new SQLException("Error reading binary parameter: " + index).initCause(e);
        }
    }

    @Override
    protected void setBinaryData(PreparedStatement s, int index, byte[] data) throws SQLException {
        s.setBinaryStream(index, (InputStream)new ByteArrayInputStream(data), data.length);
    }
}

