/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing")
@XmlRootElement(name="to")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ToDefinition
extends SendDefinition<ToDefinition> {
    @XmlAttribute
    private String variableSend;
    @XmlAttribute
    private String variableReceive;
    @XmlAttribute
    @Metadata(label="advanced", javaType="org.apache.camel.ExchangePattern", enums="InOnly,InOut")
    private String pattern;

    public ToDefinition() {
    }

    protected ToDefinition(ToDefinition source) {
        super(source);
        this.variableSend = source.variableSend;
        this.variableReceive = source.variableReceive;
        this.pattern = source.pattern;
    }

    public ToDefinition(String uri) {
        this();
        this.setUri(uri);
    }

    public ToDefinition(Endpoint endpoint) {
        this();
        this.setEndpoint(endpoint);
    }

    public ToDefinition(EndpointProducerBuilder endpointDefinition) {
        this();
        this.setEndpointProducerBuilder(endpointDefinition);
    }

    public ToDefinition(String uri, ExchangePattern pattern) {
        this(uri);
        this.pattern = pattern.name();
    }

    public ToDefinition(Endpoint endpoint, ExchangePattern pattern) {
        this(endpoint);
        this.pattern = pattern.name();
    }

    public ToDefinition(EndpointProducerBuilder endpoint, ExchangePattern pattern) {
        this(endpoint);
        this.pattern = pattern.name();
    }

    public String getShortName() {
        return "to";
    }

    public String toString() {
        return "To[" + this.getLabel() + "]";
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getVariableSend() {
        return this.variableSend;
    }

    public void setVariableSend(String variableSend) {
        this.variableSend = variableSend;
    }

    public String getVariableReceive() {
        return this.variableReceive;
    }

    public void setVariableReceive(String variableReceive) {
        this.variableReceive = variableReceive;
    }

    @Override
    public ToDefinition copyDefinition() {
        return new ToDefinition(this);
    }
}

