<?php
namespace Airavata\Model\AppCatalog\ComputeResource;

/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * * Enumeration of local resource job manager types supported by Airavata
 * *
 * * FORK:
 * *  Forking of commands without any job manager
 * *
 * * PBS:
 * *  Job manager supporting the Portal Batch System (PBS) protocol. Some examples include TORQUE, PBSPro, Grid Engine.
 * *
 * * SLURM:
 * *  The Simple Linux Utility for Resource Management is a open source workload manager.
 *  *
 *  * UGE:
 *  *  Univa Grid Engine, a variation of PBS implementation.
 *  *
 *  * LSF:
 *  *  IBM Platform Load Sharing Facility is dominantly installed on IBM clusters.
 * *
 */
final class ResourceJobManagerType {
  const FORK = 0;
  const PBS = 1;
  const SLURM = 2;
  const LSF = 3;
  const UGE = 4;
  const CLOUD = 5;
  const AIRAVATA_CUSTOM = 6;
  static public $__names = array(
    0 => 'FORK',
    1 => 'PBS',
    2 => 'SLURM',
    3 => 'LSF',
    4 => 'UGE',
    5 => 'CLOUD',
    6 => 'AIRAVATA_CUSTOM',
  );
}

/**
 * Enumeration of resource job manager commands
 * 
 * SUBMISSION:
 *  Ex: qsub, sbatch
 * 
 * JOBMONITORING:
 *  Ex: qstat, squeue
 * 
 * DELETION:
 *  Ex: qdel, scancel
 * 
 * CHECK_JOB:
 *  Detailed Status about the Job. Ex: checkjob
 * 
 * SHOW_QUEUE:
 *  List of Queued Job by the schedular. Ex: showq
 * 
 * SHOW_RESERVATION:
 *  List all reservations. Ex:showres, show_res
 * 
 * SHOW_START:
 *  Display the start time of the specified job. Ex: showstart
 * 
 */
final class JobManagerCommand {
  const SUBMISSION = 0;
  const JOB_MONITORING = 1;
  const DELETION = 2;
  const CHECK_JOB = 3;
  const SHOW_QUEUE = 4;
  const SHOW_RESERVATION = 5;
  const SHOW_START = 6;
  static public $__names = array(
    0 => 'SUBMISSION',
    1 => 'JOB_MONITORING',
    2 => 'DELETION',
    3 => 'CHECK_JOB',
    4 => 'SHOW_QUEUE',
    5 => 'SHOW_RESERVATION',
    6 => 'SHOW_START',
  );
}

/**
 * Enumeration of File Systems on the resource
 * 
 * FORK:
 *  Forking of commands without any job manager
 * 
 * PBS:
 *  Job manager supporting the Portal Batch System (PBS) protocol. Some examples include TORQUE, PBSPro, Grid Engine.
 * 
 * UGE:
 *  Univa Grid Engine, a variation of PBS implementation.
 * 
 * SLURM:
 *  The Simple Linux Utility for Resource Management is a open source workload manager.
 * 
 */
final class FileSystems {
  const HOME = 0;
  const WORK = 1;
  const LOCALTMP = 2;
  const SCRATCH = 3;
  const ARCHIVE = 4;
  static public $__names = array(
    0 => 'HOME',
    1 => 'WORK',
    2 => 'LOCALTMP',
    3 => 'SCRATCH',
    4 => 'ARCHIVE',
  );
}

/**
 * Enumeration of Airavata supported Job Submission Mechanisms for High Performance Computing Clusters.
 * 
 * SSH:
 *  Execute remote job submission commands using via secure shell protocol.
 * 
 * GRAM:
 *  Execute remote jobs via Globus GRAM service.
 * 
 * UNICORE:
 *  Execute remote jobs via Unicore services
 * 
 */
final class JobSubmissionProtocol {
  const LOCAL = 0;
  const SSH = 1;
  const GLOBUS = 2;
  const UNICORE = 3;
  const CLOUD = 4;
  const SSH_FORK = 5;
  const LOCAL_FORK = 6;
  static public $__names = array(
    0 => 'LOCAL',
    1 => 'SSH',
    2 => 'GLOBUS',
    3 => 'UNICORE',
    4 => 'CLOUD',
    5 => 'SSH_FORK',
    6 => 'LOCAL_FORK',
  );
}

/**
 * Monitoring modes
 * 
 * POLL_JOB_MANAGER:
 * GFac need to pull job status changes.
 * 
 * XSEDE_AMQP_SUBSCRIBE:
 * Server will publish job status changes to amqp servert.
 * 
 * 
 */
final class MonitorMode {
  const POLL_JOB_MANAGER = 0;
  const CLOUD_JOB_MONITOR = 1;
  const JOB_EMAIL_NOTIFICATION_MONITOR = 2;
  const XSEDE_AMQP_SUBSCRIBE = 3;
  const FORK = 4;
  const LOCAL = 5;
  static public $__names = array(
    0 => 'POLL_JOB_MANAGER',
    1 => 'CLOUD_JOB_MONITOR',
    2 => 'JOB_EMAIL_NOTIFICATION_MONITOR',
    3 => 'XSEDE_AMQP_SUBSCRIBE',
    4 => 'FORK',
    5 => 'LOCAL',
  );
}

final class DMType {
  const COMPUTE_RESOURCE = 0;
  const STORAGE_RESOURCE = 1;
  static public $__names = array(
    0 => 'COMPUTE_RESOURCE',
    1 => 'STORAGE_RESOURCE',
  );
}

/**
 * Provider name
 * 
 */
final class ProviderName {
  const EC2 = 0;
  const AWSEC2 = 1;
  const RACKSPACE = 2;
  static public $__names = array(
    0 => 'EC2',
    1 => 'AWSEC2',
    2 => 'RACKSPACE',
  );
}

/**
 * Resource Job Manager Information
 * 
 * resourceJobManagerType:
 *  A typical HPC cluster has a single Job Manager to manage the resources.
 * 
 * pushMonitoringEndpoint:
 *  If the job manager pushes out state changes to a database or bus, specify the service endpoint.
 *   Ex: Moab Web Service, Moab MongoDB URL, AMQP (GLUE2) Broker
 * 
 * jobManagerBinPath:
 *  Path to the Job Manager Installation Binary directory.
 * 
 * jobManagerCommands:
 *  An enumeration of commonly used manager commands.
 * 
 */
class ResourceJobManager {
  static $_TSPEC;

  /**
   * @var string
   */
  public $resourceJobManagerId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var int
   */
  public $resourceJobManagerType = null;
  /**
   * @var string
   */
  public $pushMonitoringEndpoint = null;
  /**
   * @var string
   */
  public $jobManagerBinPath = null;
  /**
   * @var array
   */
  public $jobManagerCommands = null;
  /**
   * @var array
   */
  public $parallelismPrefix = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'resourceJobManagerId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'resourceJobManagerType',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'pushMonitoringEndpoint',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'jobManagerBinPath',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'jobManagerCommands',
          'type' => TType::MAP,
          'ktype' => TType::I32,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::I32,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        6 => array(
          'var' => 'parallelismPrefix',
          'type' => TType::MAP,
          'ktype' => TType::I32,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::I32,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['resourceJobManagerId'])) {
        $this->resourceJobManagerId = $vals['resourceJobManagerId'];
      }
      if (isset($vals['resourceJobManagerType'])) {
        $this->resourceJobManagerType = $vals['resourceJobManagerType'];
      }
      if (isset($vals['pushMonitoringEndpoint'])) {
        $this->pushMonitoringEndpoint = $vals['pushMonitoringEndpoint'];
      }
      if (isset($vals['jobManagerBinPath'])) {
        $this->jobManagerBinPath = $vals['jobManagerBinPath'];
      }
      if (isset($vals['jobManagerCommands'])) {
        $this->jobManagerCommands = $vals['jobManagerCommands'];
      }
      if (isset($vals['parallelismPrefix'])) {
        $this->parallelismPrefix = $vals['parallelismPrefix'];
      }
    }
  }

  public function getName() {
    return 'ResourceJobManager';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceJobManagerId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->resourceJobManagerType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pushMonitoringEndpoint);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobManagerBinPath);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::MAP) {
            $this->jobManagerCommands = array();
            $_size0 = 0;
            $_ktype1 = 0;
            $_vtype2 = 0;
            $xfer += $input->readMapBegin($_ktype1, $_vtype2, $_size0);
            for ($_i4 = 0; $_i4 < $_size0; ++$_i4)
            {
              $key5 = 0;
              $val6 = '';
              $xfer += $input->readI32($key5);
              $xfer += $input->readString($val6);
              $this->jobManagerCommands[$key5] = $val6;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::MAP) {
            $this->parallelismPrefix = array();
            $_size7 = 0;
            $_ktype8 = 0;
            $_vtype9 = 0;
            $xfer += $input->readMapBegin($_ktype8, $_vtype9, $_size7);
            for ($_i11 = 0; $_i11 < $_size7; ++$_i11)
            {
              $key12 = 0;
              $val13 = '';
              $xfer += $input->readI32($key12);
              $xfer += $input->readString($val13);
              $this->parallelismPrefix[$key12] = $val13;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ResourceJobManager');
    if ($this->resourceJobManagerId !== null) {
      $xfer += $output->writeFieldBegin('resourceJobManagerId', TType::STRING, 1);
      $xfer += $output->writeString($this->resourceJobManagerId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceJobManagerType !== null) {
      $xfer += $output->writeFieldBegin('resourceJobManagerType', TType::I32, 2);
      $xfer += $output->writeI32($this->resourceJobManagerType);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pushMonitoringEndpoint !== null) {
      $xfer += $output->writeFieldBegin('pushMonitoringEndpoint', TType::STRING, 3);
      $xfer += $output->writeString($this->pushMonitoringEndpoint);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->jobManagerBinPath !== null) {
      $xfer += $output->writeFieldBegin('jobManagerBinPath', TType::STRING, 4);
      $xfer += $output->writeString($this->jobManagerBinPath);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->jobManagerCommands !== null) {
      if (!is_array($this->jobManagerCommands)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('jobManagerCommands', TType::MAP, 5);
      {
        $output->writeMapBegin(TType::I32, TType::STRING, count($this->jobManagerCommands));
        {
          foreach ($this->jobManagerCommands as $kiter14 => $viter15)
          {
            $xfer += $output->writeI32($kiter14);
            $xfer += $output->writeString($viter15);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->parallelismPrefix !== null) {
      if (!is_array($this->parallelismPrefix)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('parallelismPrefix', TType::MAP, 6);
      {
        $output->writeMapBegin(TType::I32, TType::STRING, count($this->parallelismPrefix));
        {
          foreach ($this->parallelismPrefix as $kiter16 => $viter17)
          {
            $xfer += $output->writeI32($kiter16);
            $xfer += $output->writeString($viter17);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Batch Queue Information on SuperComputers
 * 
 * maxRunTime:
 *  Maximum allowed run time in hours.
 */
class BatchQueue {
  static $_TSPEC;

  /**
   * @var string
   */
  public $queueName = null;
  /**
   * @var string
   */
  public $queueDescription = null;
  /**
   * @var int
   */
  public $maxRunTime = null;
  /**
   * @var int
   */
  public $maxNodes = null;
  /**
   * @var int
   */
  public $maxProcessors = null;
  /**
   * @var int
   */
  public $maxJobsInQueue = null;
  /**
   * @var int
   */
  public $maxMemory = null;
  /**
   * @var int
   */
  public $cpuPerNode = null;
  /**
   * @var int
   */
  public $defaultNodeCount = null;
  /**
   * @var int
   */
  public $defaultCPUCount = null;
  /**
   * @var int
   */
  public $defaultWalltime = null;
  /**
   * @var string
   */
  public $queueSpecificMacros = null;
  /**
   * @var bool
   */
  public $isDefaultQueue = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'queueName',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'queueDescription',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'maxRunTime',
          'type' => TType::I32,
          ),
        4 => array(
          'var' => 'maxNodes',
          'type' => TType::I32,
          ),
        5 => array(
          'var' => 'maxProcessors',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'maxJobsInQueue',
          'type' => TType::I32,
          ),
        7 => array(
          'var' => 'maxMemory',
          'type' => TType::I32,
          ),
        8 => array(
          'var' => 'cpuPerNode',
          'type' => TType::I32,
          ),
        9 => array(
          'var' => 'defaultNodeCount',
          'type' => TType::I32,
          ),
        10 => array(
          'var' => 'defaultCPUCount',
          'type' => TType::I32,
          ),
        11 => array(
          'var' => 'defaultWalltime',
          'type' => TType::I32,
          ),
        12 => array(
          'var' => 'queueSpecificMacros',
          'type' => TType::STRING,
          ),
        13 => array(
          'var' => 'isDefaultQueue',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['queueName'])) {
        $this->queueName = $vals['queueName'];
      }
      if (isset($vals['queueDescription'])) {
        $this->queueDescription = $vals['queueDescription'];
      }
      if (isset($vals['maxRunTime'])) {
        $this->maxRunTime = $vals['maxRunTime'];
      }
      if (isset($vals['maxNodes'])) {
        $this->maxNodes = $vals['maxNodes'];
      }
      if (isset($vals['maxProcessors'])) {
        $this->maxProcessors = $vals['maxProcessors'];
      }
      if (isset($vals['maxJobsInQueue'])) {
        $this->maxJobsInQueue = $vals['maxJobsInQueue'];
      }
      if (isset($vals['maxMemory'])) {
        $this->maxMemory = $vals['maxMemory'];
      }
      if (isset($vals['cpuPerNode'])) {
        $this->cpuPerNode = $vals['cpuPerNode'];
      }
      if (isset($vals['defaultNodeCount'])) {
        $this->defaultNodeCount = $vals['defaultNodeCount'];
      }
      if (isset($vals['defaultCPUCount'])) {
        $this->defaultCPUCount = $vals['defaultCPUCount'];
      }
      if (isset($vals['defaultWalltime'])) {
        $this->defaultWalltime = $vals['defaultWalltime'];
      }
      if (isset($vals['queueSpecificMacros'])) {
        $this->queueSpecificMacros = $vals['queueSpecificMacros'];
      }
      if (isset($vals['isDefaultQueue'])) {
        $this->isDefaultQueue = $vals['isDefaultQueue'];
      }
    }
  }

  public function getName() {
    return 'BatchQueue';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->queueName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->queueDescription);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->maxRunTime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->maxNodes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->maxProcessors);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->maxJobsInQueue);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->maxMemory);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 8:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->cpuPerNode);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->defaultNodeCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 10:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->defaultCPUCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->defaultWalltime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 12:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->queueSpecificMacros);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->isDefaultQueue);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('BatchQueue');
    if ($this->queueName !== null) {
      $xfer += $output->writeFieldBegin('queueName', TType::STRING, 1);
      $xfer += $output->writeString($this->queueName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->queueDescription !== null) {
      $xfer += $output->writeFieldBegin('queueDescription', TType::STRING, 2);
      $xfer += $output->writeString($this->queueDescription);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxRunTime !== null) {
      $xfer += $output->writeFieldBegin('maxRunTime', TType::I32, 3);
      $xfer += $output->writeI32($this->maxRunTime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxNodes !== null) {
      $xfer += $output->writeFieldBegin('maxNodes', TType::I32, 4);
      $xfer += $output->writeI32($this->maxNodes);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxProcessors !== null) {
      $xfer += $output->writeFieldBegin('maxProcessors', TType::I32, 5);
      $xfer += $output->writeI32($this->maxProcessors);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxJobsInQueue !== null) {
      $xfer += $output->writeFieldBegin('maxJobsInQueue', TType::I32, 6);
      $xfer += $output->writeI32($this->maxJobsInQueue);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxMemory !== null) {
      $xfer += $output->writeFieldBegin('maxMemory', TType::I32, 7);
      $xfer += $output->writeI32($this->maxMemory);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cpuPerNode !== null) {
      $xfer += $output->writeFieldBegin('cpuPerNode', TType::I32, 8);
      $xfer += $output->writeI32($this->cpuPerNode);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultNodeCount !== null) {
      $xfer += $output->writeFieldBegin('defaultNodeCount', TType::I32, 9);
      $xfer += $output->writeI32($this->defaultNodeCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultCPUCount !== null) {
      $xfer += $output->writeFieldBegin('defaultCPUCount', TType::I32, 10);
      $xfer += $output->writeI32($this->defaultCPUCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultWalltime !== null) {
      $xfer += $output->writeFieldBegin('defaultWalltime', TType::I32, 11);
      $xfer += $output->writeI32($this->defaultWalltime);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->queueSpecificMacros !== null) {
      $xfer += $output->writeFieldBegin('queueSpecificMacros', TType::STRING, 12);
      $xfer += $output->writeString($this->queueSpecificMacros);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->isDefaultQueue !== null) {
      $xfer += $output->writeFieldBegin('isDefaultQueue', TType::BOOL, 13);
      $xfer += $output->writeBool($this->isDefaultQueue);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Locally Fork Jobs as OS processes
 * 
 * alternativeSSHHostName:
 *  If the login to ssh is different than the hostname itself, specify it here
 * 
 * sshPort:
 *  If a non-default port needs to used, specify it.
 */
class LOCALSubmission {
  static $_TSPEC;

  /**
   * @var string
   */
  public $jobSubmissionInterfaceId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager
   */
  public $resourceJobManager = null;
  /**
   * @var int
   */
  public $securityProtocol = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'resourceJobManager',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager',
          ),
        3 => array(
          'var' => 'securityProtocol',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['resourceJobManager'])) {
        $this->resourceJobManager = $vals['resourceJobManager'];
      }
      if (isset($vals['securityProtocol'])) {
        $this->securityProtocol = $vals['securityProtocol'];
      }
    }
  }

  public function getName() {
    return 'LOCALSubmission';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->resourceJobManager = new \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager();
            $xfer += $this->resourceJobManager->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->securityProtocol);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('LOCALSubmission');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceJobManager !== null) {
      if (!is_object($this->resourceJobManager)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resourceJobManager', TType::STRUCT, 2);
      $xfer += $this->resourceJobManager->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->securityProtocol !== null) {
      $xfer += $output->writeFieldBegin('securityProtocol', TType::I32, 3);
      $xfer += $output->writeI32($this->securityProtocol);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Authenticate using Secured Shell
 * 
 * alternativeSSHHostName:
 *  If the login to ssh is different than the hostname itself, specify it here
 * 
 * sshPort:
 *  If a non-default port needs to used, specify it.
 * 
 * batchQueueEmailSenders:
 *  If a resource always sends the monitoring from a specific address, specify the
 *   full email address. If a resource sends emails from multiple addresses (
 *    example: based on the submitted login node) then use the wildchar * to indicate
 *    the same. Example: *@*.example.com or *@example.com
 * 
 */
class SSHJobSubmission {
  static $_TSPEC;

  /**
   * @var string
   */
  public $jobSubmissionInterfaceId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var int
   */
  public $securityProtocol = null;
  /**
   * @var \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager
   */
  public $resourceJobManager = null;
  /**
   * @var string
   */
  public $alternativeSSHHostName = null;
  /**
   * @var int
   */
  public $sshPort = 22;
  /**
   * @var int
   */
  public $monitorMode = null;
  /**
   * @var string[]
   */
  public $batchQueueEmailSenders = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'securityProtocol',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'resourceJobManager',
          'type' => TType::STRUCT,
          'class' => '\Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager',
          ),
        4 => array(
          'var' => 'alternativeSSHHostName',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'sshPort',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'monitorMode',
          'type' => TType::I32,
          ),
        7 => array(
          'var' => 'batchQueueEmailSenders',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['securityProtocol'])) {
        $this->securityProtocol = $vals['securityProtocol'];
      }
      if (isset($vals['resourceJobManager'])) {
        $this->resourceJobManager = $vals['resourceJobManager'];
      }
      if (isset($vals['alternativeSSHHostName'])) {
        $this->alternativeSSHHostName = $vals['alternativeSSHHostName'];
      }
      if (isset($vals['sshPort'])) {
        $this->sshPort = $vals['sshPort'];
      }
      if (isset($vals['monitorMode'])) {
        $this->monitorMode = $vals['monitorMode'];
      }
      if (isset($vals['batchQueueEmailSenders'])) {
        $this->batchQueueEmailSenders = $vals['batchQueueEmailSenders'];
      }
    }
  }

  public function getName() {
    return 'SSHJobSubmission';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->securityProtocol);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->resourceJobManager = new \Airavata\Model\AppCatalog\ComputeResource\ResourceJobManager();
            $xfer += $this->resourceJobManager->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->alternativeSSHHostName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->sshPort);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->monitorMode);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::LST) {
            $this->batchQueueEmailSenders = array();
            $_size18 = 0;
            $_etype21 = 0;
            $xfer += $input->readListBegin($_etype21, $_size18);
            for ($_i22 = 0; $_i22 < $_size18; ++$_i22)
            {
              $elem23 = null;
              $xfer += $input->readString($elem23);
              $this->batchQueueEmailSenders []= $elem23;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('SSHJobSubmission');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->securityProtocol !== null) {
      $xfer += $output->writeFieldBegin('securityProtocol', TType::I32, 2);
      $xfer += $output->writeI32($this->securityProtocol);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceJobManager !== null) {
      if (!is_object($this->resourceJobManager)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('resourceJobManager', TType::STRUCT, 3);
      $xfer += $this->resourceJobManager->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->alternativeSSHHostName !== null) {
      $xfer += $output->writeFieldBegin('alternativeSSHHostName', TType::STRING, 4);
      $xfer += $output->writeString($this->alternativeSSHHostName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->sshPort !== null) {
      $xfer += $output->writeFieldBegin('sshPort', TType::I32, 5);
      $xfer += $output->writeI32($this->sshPort);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->monitorMode !== null) {
      $xfer += $output->writeFieldBegin('monitorMode', TType::I32, 6);
      $xfer += $output->writeI32($this->monitorMode);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->batchQueueEmailSenders !== null) {
      if (!is_array($this->batchQueueEmailSenders)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('batchQueueEmailSenders', TType::LST, 7);
      {
        $output->writeListBegin(TType::STRING, count($this->batchQueueEmailSenders));
        {
          foreach ($this->batchQueueEmailSenders as $iter24)
          {
            $xfer += $output->writeString($iter24);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class GlobusJobSubmission {
  static $_TSPEC;

  /**
   * @var string
   */
  public $jobSubmissionInterfaceId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var int
   */
  public $securityProtocol = null;
  /**
   * @var string[]
   */
  public $globusGateKeeperEndPoint = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'securityProtocol',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'globusGateKeeperEndPoint',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['securityProtocol'])) {
        $this->securityProtocol = $vals['securityProtocol'];
      }
      if (isset($vals['globusGateKeeperEndPoint'])) {
        $this->globusGateKeeperEndPoint = $vals['globusGateKeeperEndPoint'];
      }
    }
  }

  public function getName() {
    return 'GlobusJobSubmission';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->securityProtocol);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->globusGateKeeperEndPoint = array();
            $_size25 = 0;
            $_etype28 = 0;
            $xfer += $input->readListBegin($_etype28, $_size25);
            for ($_i29 = 0; $_i29 < $_size25; ++$_i29)
            {
              $elem30 = null;
              $xfer += $input->readString($elem30);
              $this->globusGateKeeperEndPoint []= $elem30;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('GlobusJobSubmission');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->securityProtocol !== null) {
      $xfer += $output->writeFieldBegin('securityProtocol', TType::I32, 2);
      $xfer += $output->writeI32($this->securityProtocol);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->globusGateKeeperEndPoint !== null) {
      if (!is_array($this->globusGateKeeperEndPoint)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('globusGateKeeperEndPoint', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->globusGateKeeperEndPoint));
        {
          foreach ($this->globusGateKeeperEndPoint as $iter31)
          {
            $xfer += $output->writeString($iter31);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Unicore Job Submission
 * 
 * unicoreEndPointURL:
 *  unicoreGateway End Point. The provider will query this service to fetch required service end points.
 * authenticationMode
 *  The authenticationMode defines the way certificate is fetched.
 */
class UnicoreJobSubmission {
  static $_TSPEC;

  /**
   * @var string
   */
  public $jobSubmissionInterfaceId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var int
   */
  public $securityProtocol = null;
  /**
   * @var string
   */
  public $unicoreEndPointURL = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'securityProtocol',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'unicoreEndPointURL',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['securityProtocol'])) {
        $this->securityProtocol = $vals['securityProtocol'];
      }
      if (isset($vals['unicoreEndPointURL'])) {
        $this->unicoreEndPointURL = $vals['unicoreEndPointURL'];
      }
    }
  }

  public function getName() {
    return 'UnicoreJobSubmission';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->securityProtocol);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->unicoreEndPointURL);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('UnicoreJobSubmission');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->securityProtocol !== null) {
      $xfer += $output->writeFieldBegin('securityProtocol', TType::I32, 2);
      $xfer += $output->writeI32($this->securityProtocol);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->unicoreEndPointURL !== null) {
      $xfer += $output->writeFieldBegin('unicoreEndPointURL', TType::STRING, 3);
      $xfer += $output->writeString($this->unicoreEndPointURL);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Cloud Job Submission
 * 
 * 
 */
class CloudJobSubmission {
  static $_TSPEC;

  /**
   * @var string
   */
  public $jobSubmissionInterfaceId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var int
   */
  public $securityProtocol = null;
  /**
   * @var string
   */
  public $nodeId = null;
  /**
   * @var string
   */
  public $executableType = null;
  /**
   * @var int
   */
  public $providerName = null;
  /**
   * @var string
   */
  public $userAccountName = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'securityProtocol',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'nodeId',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'executableType',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'providerName',
          'type' => TType::I32,
          ),
        6 => array(
          'var' => 'userAccountName',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['securityProtocol'])) {
        $this->securityProtocol = $vals['securityProtocol'];
      }
      if (isset($vals['nodeId'])) {
        $this->nodeId = $vals['nodeId'];
      }
      if (isset($vals['executableType'])) {
        $this->executableType = $vals['executableType'];
      }
      if (isset($vals['providerName'])) {
        $this->providerName = $vals['providerName'];
      }
      if (isset($vals['userAccountName'])) {
        $this->userAccountName = $vals['userAccountName'];
      }
    }
  }

  public function getName() {
    return 'CloudJobSubmission';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->securityProtocol);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->nodeId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->executableType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->providerName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->userAccountName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('CloudJobSubmission');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->securityProtocol !== null) {
      $xfer += $output->writeFieldBegin('securityProtocol', TType::I32, 2);
      $xfer += $output->writeI32($this->securityProtocol);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->nodeId !== null) {
      $xfer += $output->writeFieldBegin('nodeId', TType::STRING, 3);
      $xfer += $output->writeString($this->nodeId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->executableType !== null) {
      $xfer += $output->writeFieldBegin('executableType', TType::STRING, 4);
      $xfer += $output->writeString($this->executableType);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->providerName !== null) {
      $xfer += $output->writeFieldBegin('providerName', TType::I32, 5);
      $xfer += $output->writeI32($this->providerName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->userAccountName !== null) {
      $xfer += $output->writeFieldBegin('userAccountName', TType::STRING, 6);
      $xfer += $output->writeString($this->userAccountName);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Job Submission Interfaces
 * 
 * jobSubmissionInterfaceId: The Job Submission Interface has to be previously registered and referenced here.
 * 
 * priorityOrder:
 *  For resources with multiple interfaces, the priority order should be selected.
 *   Lower the numerical number, higher the priority
 * 
 */
class JobSubmissionInterface {
  static $_TSPEC;

  /**
   * @var string
   */
  public $jobSubmissionInterfaceId = null;
  /**
   * @var int
   */
  public $jobSubmissionProtocol = null;
  /**
   * @var int
   */
  public $priorityOrder = 0;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'jobSubmissionInterfaceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'jobSubmissionProtocol',
          'type' => TType::I32,
          ),
        3 => array(
          'var' => 'priorityOrder',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['jobSubmissionInterfaceId'])) {
        $this->jobSubmissionInterfaceId = $vals['jobSubmissionInterfaceId'];
      }
      if (isset($vals['jobSubmissionProtocol'])) {
        $this->jobSubmissionProtocol = $vals['jobSubmissionProtocol'];
      }
      if (isset($vals['priorityOrder'])) {
        $this->priorityOrder = $vals['priorityOrder'];
      }
    }
  }

  public function getName() {
    return 'JobSubmissionInterface';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->jobSubmissionInterfaceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->jobSubmissionProtocol);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->priorityOrder);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('JobSubmissionInterface');
    if ($this->jobSubmissionInterfaceId !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaceId', TType::STRING, 1);
      $xfer += $output->writeString($this->jobSubmissionInterfaceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->jobSubmissionProtocol !== null) {
      $xfer += $output->writeFieldBegin('jobSubmissionProtocol', TType::I32, 2);
      $xfer += $output->writeI32($this->jobSubmissionProtocol);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->priorityOrder !== null) {
      $xfer += $output->writeFieldBegin('priorityOrder', TType::I32, 3);
      $xfer += $output->writeI32($this->priorityOrder);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

/**
 * Computational Resource Description
 * 
 * computeResourceId: Airavata Internal Unique Identifier to distinguish Compute Resource.
 * 
 * hostName:
 *   Fully Qualified Host Name.
 * 
 * hostAliases:
 *   Aliases if any.
 * 
 * ipAddress:
 *   IP Addresses of the Resource.
 * 
 * resourceDescription:
 *  A user friendly description of the resource.
 * 
 * JobSubmissionProtocols:
 *  A computational resources may have one or more ways of submitting Jobs. This structure
 *    will hold all available mechanisms to interact with the resource.
 *  The key is the priority
 * 
 * DataMovementProtocol:
 *  Option to specify a prefered data movement mechanism of the available options.
 * 
 * fileSystems:
 *  Map of file systems type and the path.
 * 
 */
class ComputeResourceDescription {
  static $_TSPEC;

  /**
   * @var string
   */
  public $computeResourceId = "DO_NOT_SET_AT_CLIENTS";
  /**
   * @var string
   */
  public $hostName = null;
  /**
   * @var string[]
   */
  public $hostAliases = null;
  /**
   * @var string[]
   */
  public $ipAddresses = null;
  /**
   * @var string
   */
  public $resourceDescription = null;
  /**
   * @var bool
   */
  public $enabled = null;
  /**
   * @var \Airavata\Model\AppCatalog\ComputeResource\BatchQueue[]
   */
  public $batchQueues = null;
  /**
   * @var array
   */
  public $fileSystems = null;
  /**
   * @var \Airavata\Model\AppCatalog\ComputeResource\JobSubmissionInterface[]
   */
  public $jobSubmissionInterfaces = null;
  /**
   * @var \Airavata\Model\Data\Movement\DataMovementInterface[]
   */
  public $dataMovementInterfaces = null;
  /**
   * @var int
   */
  public $maxMemoryPerNode = null;
  /**
   * @var bool
   */
  public $gatewayUsageReporting = null;
  /**
   * @var string
   */
  public $gatewayUsageModuleLoadCommand = null;
  /**
   * @var string
   */
  public $gatewayUsageExecutable = null;
  /**
   * @var int
   */
  public $cpusPerNode = null;
  /**
   * @var int
   */
  public $defaultNodeCount = null;
  /**
   * @var int
   */
  public $defaultCPUCount = null;
  /**
   * @var int
   */
  public $defaultWalltime = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'computeResourceId',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'hostName',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'hostAliases',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'ipAddresses',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        5 => array(
          'var' => 'resourceDescription',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'enabled',
          'type' => TType::BOOL,
          ),
        7 => array(
          'var' => 'batchQueues',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\ComputeResource\BatchQueue',
            ),
          ),
        8 => array(
          'var' => 'fileSystems',
          'type' => TType::MAP,
          'ktype' => TType::I32,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::I32,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        9 => array(
          'var' => 'jobSubmissionInterfaces',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\AppCatalog\ComputeResource\JobSubmissionInterface',
            ),
          ),
        10 => array(
          'var' => 'dataMovementInterfaces',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\Airavata\Model\Data\Movement\DataMovementInterface',
            ),
          ),
        11 => array(
          'var' => 'maxMemoryPerNode',
          'type' => TType::I32,
          ),
        12 => array(
          'var' => 'gatewayUsageReporting',
          'type' => TType::BOOL,
          ),
        13 => array(
          'var' => 'gatewayUsageModuleLoadCommand',
          'type' => TType::STRING,
          ),
        14 => array(
          'var' => 'gatewayUsageExecutable',
          'type' => TType::STRING,
          ),
        15 => array(
          'var' => 'cpusPerNode',
          'type' => TType::I32,
          ),
        16 => array(
          'var' => 'defaultNodeCount',
          'type' => TType::I32,
          ),
        17 => array(
          'var' => 'defaultCPUCount',
          'type' => TType::I32,
          ),
        18 => array(
          'var' => 'defaultWalltime',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['computeResourceId'])) {
        $this->computeResourceId = $vals['computeResourceId'];
      }
      if (isset($vals['hostName'])) {
        $this->hostName = $vals['hostName'];
      }
      if (isset($vals['hostAliases'])) {
        $this->hostAliases = $vals['hostAliases'];
      }
      if (isset($vals['ipAddresses'])) {
        $this->ipAddresses = $vals['ipAddresses'];
      }
      if (isset($vals['resourceDescription'])) {
        $this->resourceDescription = $vals['resourceDescription'];
      }
      if (isset($vals['enabled'])) {
        $this->enabled = $vals['enabled'];
      }
      if (isset($vals['batchQueues'])) {
        $this->batchQueues = $vals['batchQueues'];
      }
      if (isset($vals['fileSystems'])) {
        $this->fileSystems = $vals['fileSystems'];
      }
      if (isset($vals['jobSubmissionInterfaces'])) {
        $this->jobSubmissionInterfaces = $vals['jobSubmissionInterfaces'];
      }
      if (isset($vals['dataMovementInterfaces'])) {
        $this->dataMovementInterfaces = $vals['dataMovementInterfaces'];
      }
      if (isset($vals['maxMemoryPerNode'])) {
        $this->maxMemoryPerNode = $vals['maxMemoryPerNode'];
      }
      if (isset($vals['gatewayUsageReporting'])) {
        $this->gatewayUsageReporting = $vals['gatewayUsageReporting'];
      }
      if (isset($vals['gatewayUsageModuleLoadCommand'])) {
        $this->gatewayUsageModuleLoadCommand = $vals['gatewayUsageModuleLoadCommand'];
      }
      if (isset($vals['gatewayUsageExecutable'])) {
        $this->gatewayUsageExecutable = $vals['gatewayUsageExecutable'];
      }
      if (isset($vals['cpusPerNode'])) {
        $this->cpusPerNode = $vals['cpusPerNode'];
      }
      if (isset($vals['defaultNodeCount'])) {
        $this->defaultNodeCount = $vals['defaultNodeCount'];
      }
      if (isset($vals['defaultCPUCount'])) {
        $this->defaultCPUCount = $vals['defaultCPUCount'];
      }
      if (isset($vals['defaultWalltime'])) {
        $this->defaultWalltime = $vals['defaultWalltime'];
      }
    }
  }

  public function getName() {
    return 'ComputeResourceDescription';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->computeResourceId);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->hostName);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->hostAliases = array();
            $_size32 = 0;
            $_etype35 = 0;
            $xfer += $input->readListBegin($_etype35, $_size32);
            for ($_i36 = 0; $_i36 < $_size32; ++$_i36)
            {
              $elem37 = null;
              $xfer += $input->readString($elem37);
              $this->hostAliases []= $elem37;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::LST) {
            $this->ipAddresses = array();
            $_size38 = 0;
            $_etype41 = 0;
            $xfer += $input->readListBegin($_etype41, $_size38);
            for ($_i42 = 0; $_i42 < $_size38; ++$_i42)
            {
              $elem43 = null;
              $xfer += $input->readString($elem43);
              $this->ipAddresses []= $elem43;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->resourceDescription);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->enabled);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 7:
          if ($ftype == TType::LST) {
            $this->batchQueues = array();
            $_size44 = 0;
            $_etype47 = 0;
            $xfer += $input->readListBegin($_etype47, $_size44);
            for ($_i48 = 0; $_i48 < $_size44; ++$_i48)
            {
              $elem49 = null;
              $elem49 = new \Airavata\Model\AppCatalog\ComputeResource\BatchQueue();
              $xfer += $elem49->read($input);
              $this->batchQueues []= $elem49;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 8:
          if ($ftype == TType::MAP) {
            $this->fileSystems = array();
            $_size50 = 0;
            $_ktype51 = 0;
            $_vtype52 = 0;
            $xfer += $input->readMapBegin($_ktype51, $_vtype52, $_size50);
            for ($_i54 = 0; $_i54 < $_size50; ++$_i54)
            {
              $key55 = 0;
              $val56 = '';
              $xfer += $input->readI32($key55);
              $xfer += $input->readString($val56);
              $this->fileSystems[$key55] = $val56;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 9:
          if ($ftype == TType::LST) {
            $this->jobSubmissionInterfaces = array();
            $_size57 = 0;
            $_etype60 = 0;
            $xfer += $input->readListBegin($_etype60, $_size57);
            for ($_i61 = 0; $_i61 < $_size57; ++$_i61)
            {
              $elem62 = null;
              $elem62 = new \Airavata\Model\AppCatalog\ComputeResource\JobSubmissionInterface();
              $xfer += $elem62->read($input);
              $this->jobSubmissionInterfaces []= $elem62;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 10:
          if ($ftype == TType::LST) {
            $this->dataMovementInterfaces = array();
            $_size63 = 0;
            $_etype66 = 0;
            $xfer += $input->readListBegin($_etype66, $_size63);
            for ($_i67 = 0; $_i67 < $_size63; ++$_i67)
            {
              $elem68 = null;
              $elem68 = new \Airavata\Model\Data\Movement\DataMovementInterface();
              $xfer += $elem68->read($input);
              $this->dataMovementInterfaces []= $elem68;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 11:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->maxMemoryPerNode);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 12:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->gatewayUsageReporting);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 13:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayUsageModuleLoadCommand);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 14:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->gatewayUsageExecutable);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 15:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->cpusPerNode);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 16:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->defaultNodeCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 17:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->defaultCPUCount);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 18:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->defaultWalltime);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ComputeResourceDescription');
    if ($this->computeResourceId !== null) {
      $xfer += $output->writeFieldBegin('computeResourceId', TType::STRING, 1);
      $xfer += $output->writeString($this->computeResourceId);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->hostName !== null) {
      $xfer += $output->writeFieldBegin('hostName', TType::STRING, 2);
      $xfer += $output->writeString($this->hostName);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->hostAliases !== null) {
      if (!is_array($this->hostAliases)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('hostAliases', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->hostAliases));
        {
          foreach ($this->hostAliases as $iter69)
          {
            $xfer += $output->writeString($iter69);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->ipAddresses !== null) {
      if (!is_array($this->ipAddresses)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('ipAddresses', TType::LST, 4);
      {
        $output->writeListBegin(TType::STRING, count($this->ipAddresses));
        {
          foreach ($this->ipAddresses as $iter70)
          {
            $xfer += $output->writeString($iter70);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->resourceDescription !== null) {
      $xfer += $output->writeFieldBegin('resourceDescription', TType::STRING, 5);
      $xfer += $output->writeString($this->resourceDescription);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->enabled !== null) {
      $xfer += $output->writeFieldBegin('enabled', TType::BOOL, 6);
      $xfer += $output->writeBool($this->enabled);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->batchQueues !== null) {
      if (!is_array($this->batchQueues)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('batchQueues', TType::LST, 7);
      {
        $output->writeListBegin(TType::STRUCT, count($this->batchQueues));
        {
          foreach ($this->batchQueues as $iter71)
          {
            $xfer += $iter71->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->fileSystems !== null) {
      if (!is_array($this->fileSystems)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('fileSystems', TType::MAP, 8);
      {
        $output->writeMapBegin(TType::I32, TType::STRING, count($this->fileSystems));
        {
          foreach ($this->fileSystems as $kiter72 => $viter73)
          {
            $xfer += $output->writeI32($kiter72);
            $xfer += $output->writeString($viter73);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->jobSubmissionInterfaces !== null) {
      if (!is_array($this->jobSubmissionInterfaces)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('jobSubmissionInterfaces', TType::LST, 9);
      {
        $output->writeListBegin(TType::STRUCT, count($this->jobSubmissionInterfaces));
        {
          foreach ($this->jobSubmissionInterfaces as $iter74)
          {
            $xfer += $iter74->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dataMovementInterfaces !== null) {
      if (!is_array($this->dataMovementInterfaces)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('dataMovementInterfaces', TType::LST, 10);
      {
        $output->writeListBegin(TType::STRUCT, count($this->dataMovementInterfaces));
        {
          foreach ($this->dataMovementInterfaces as $iter75)
          {
            $xfer += $iter75->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->maxMemoryPerNode !== null) {
      $xfer += $output->writeFieldBegin('maxMemoryPerNode', TType::I32, 11);
      $xfer += $output->writeI32($this->maxMemoryPerNode);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayUsageReporting !== null) {
      $xfer += $output->writeFieldBegin('gatewayUsageReporting', TType::BOOL, 12);
      $xfer += $output->writeBool($this->gatewayUsageReporting);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayUsageModuleLoadCommand !== null) {
      $xfer += $output->writeFieldBegin('gatewayUsageModuleLoadCommand', TType::STRING, 13);
      $xfer += $output->writeString($this->gatewayUsageModuleLoadCommand);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->gatewayUsageExecutable !== null) {
      $xfer += $output->writeFieldBegin('gatewayUsageExecutable', TType::STRING, 14);
      $xfer += $output->writeString($this->gatewayUsageExecutable);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cpusPerNode !== null) {
      $xfer += $output->writeFieldBegin('cpusPerNode', TType::I32, 15);
      $xfer += $output->writeI32($this->cpusPerNode);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultNodeCount !== null) {
      $xfer += $output->writeFieldBegin('defaultNodeCount', TType::I32, 16);
      $xfer += $output->writeI32($this->defaultNodeCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultCPUCount !== null) {
      $xfer += $output->writeFieldBegin('defaultCPUCount', TType::I32, 17);
      $xfer += $output->writeI32($this->defaultCPUCount);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultWalltime !== null) {
      $xfer += $output->writeFieldBegin('defaultWalltime', TType::I32, 18);
      $xfer += $output->writeI32($this->defaultWalltime);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}


