/**
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
package org.apache.airavata.cloud.aurora.client.sdk;

import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;

import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;
import org.apache.thrift.server.AbstractNonblockingServer.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.EnumMap;
import java.util.Set;
import java.util.HashSet;
import java.util.EnumSet;
import java.util.Collections;
import java.util.BitSet;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.annotation.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressWarnings({"cast", "rawtypes", "serial", "unchecked"})
/**
 * Description of an Aurora job. One task will be scheduled for each instance within the job.
 */
@Generated(value = "Autogenerated by Thrift Compiler (0.9.3)", date = "2016-10-21")
public class JobConfiguration implements org.apache.thrift.TBase<JobConfiguration, JobConfiguration._Fields>, java.io.Serializable, Cloneable, Comparable<JobConfiguration> {
  private static final org.apache.thrift.protocol.TStruct STRUCT_DESC = new org.apache.thrift.protocol.TStruct("JobConfiguration");

  private static final org.apache.thrift.protocol.TField KEY_FIELD_DESC = new org.apache.thrift.protocol.TField("key", org.apache.thrift.protocol.TType.STRUCT, (short)9);
  private static final org.apache.thrift.protocol.TField OWNER_FIELD_DESC = new org.apache.thrift.protocol.TField("owner", org.apache.thrift.protocol.TType.STRUCT, (short)7);
  private static final org.apache.thrift.protocol.TField CRON_SCHEDULE_FIELD_DESC = new org.apache.thrift.protocol.TField("cronSchedule", org.apache.thrift.protocol.TType.STRING, (short)4);
  private static final org.apache.thrift.protocol.TField CRON_COLLISION_POLICY_FIELD_DESC = new org.apache.thrift.protocol.TField("cronCollisionPolicy", org.apache.thrift.protocol.TType.I32, (short)5);
  private static final org.apache.thrift.protocol.TField TASK_CONFIG_FIELD_DESC = new org.apache.thrift.protocol.TField("taskConfig", org.apache.thrift.protocol.TType.STRUCT, (short)6);
  private static final org.apache.thrift.protocol.TField INSTANCE_COUNT_FIELD_DESC = new org.apache.thrift.protocol.TField("instanceCount", org.apache.thrift.protocol.TType.I32, (short)8);

  private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
  static {
    schemes.put(StandardScheme.class, new JobConfigurationStandardSchemeFactory());
    schemes.put(TupleScheme.class, new JobConfigurationTupleSchemeFactory());
  }

  /**
   * Key for this job. If not specified name, owner.role, and a reasonable default environment are
   * used to construct it server-side.
   */
  public JobKey key; // required
  /**
   * Owner of this job.
   */
  public Identity owner; // required
  /**
   * If present, the job will be handled as a cron job with this crontab-syntax schedule.
   */
  public String cronSchedule; // optional
  /**
   * Collision policy to use when handling overlapping cron runs.  Default is KILL_EXISTING.
   * 
   * @see CronCollisionPolicy
   */
  public CronCollisionPolicy cronCollisionPolicy; // required
  /**
   * Task configuration for this job.
   */
  public TaskConfig taskConfig; // required
  /**
   * The number of instances in the job. Generated instance IDs for tasks will be in the range
   * [0, instances).
   */
  public int instanceCount; // required

  /** The set of fields this struct contains, along with convenience methods for finding and manipulating them. */
  public enum _Fields implements org.apache.thrift.TFieldIdEnum {
    /**
     * Key for this job. If not specified name, owner.role, and a reasonable default environment are
     * used to construct it server-side.
     */
    KEY((short)9, "key"),
    /**
     * Owner of this job.
     */
    OWNER((short)7, "owner"),
    /**
     * If present, the job will be handled as a cron job with this crontab-syntax schedule.
     */
    CRON_SCHEDULE((short)4, "cronSchedule"),
    /**
     * Collision policy to use when handling overlapping cron runs.  Default is KILL_EXISTING.
     * 
     * @see CronCollisionPolicy
     */
    CRON_COLLISION_POLICY((short)5, "cronCollisionPolicy"),
    /**
     * Task configuration for this job.
     */
    TASK_CONFIG((short)6, "taskConfig"),
    /**
     * The number of instances in the job. Generated instance IDs for tasks will be in the range
     * [0, instances).
     */
    INSTANCE_COUNT((short)8, "instanceCount");

    private static final Map<String, _Fields> byName = new HashMap<String, _Fields>();

    static {
      for (_Fields field : EnumSet.allOf(_Fields.class)) {
        byName.put(field.getFieldName(), field);
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, or null if its not found.
     */
    public static _Fields findByThriftId(int fieldId) {
      switch(fieldId) {
        case 9: // KEY
          return KEY;
        case 7: // OWNER
          return OWNER;
        case 4: // CRON_SCHEDULE
          return CRON_SCHEDULE;
        case 5: // CRON_COLLISION_POLICY
          return CRON_COLLISION_POLICY;
        case 6: // TASK_CONFIG
          return TASK_CONFIG;
        case 8: // INSTANCE_COUNT
          return INSTANCE_COUNT;
        default:
          return null;
      }
    }

    /**
     * Find the _Fields constant that matches fieldId, throwing an exception
     * if it is not found.
     */
    public static _Fields findByThriftIdOrThrow(int fieldId) {
      _Fields fields = findByThriftId(fieldId);
      if (fields == null) throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
      return fields;
    }

    /**
     * Find the _Fields constant that matches name, or null if its not found.
     */
    public static _Fields findByName(String name) {
      return byName.get(name);
    }

    private final short _thriftId;
    private final String _fieldName;

    _Fields(short thriftId, String fieldName) {
      _thriftId = thriftId;
      _fieldName = fieldName;
    }

    public short getThriftFieldId() {
      return _thriftId;
    }

    public String getFieldName() {
      return _fieldName;
    }
  }

  // isset id assignments
  private static final int __INSTANCECOUNT_ISSET_ID = 0;
  private byte __isset_bitfield = 0;
  private static final _Fields optionals[] = {_Fields.CRON_SCHEDULE};
  public static final Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> metaDataMap;
  static {
    Map<_Fields, org.apache.thrift.meta_data.FieldMetaData> tmpMap = new EnumMap<_Fields, org.apache.thrift.meta_data.FieldMetaData>(_Fields.class);
    tmpMap.put(_Fields.KEY, new org.apache.thrift.meta_data.FieldMetaData("key", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, JobKey.class)));
    tmpMap.put(_Fields.OWNER, new org.apache.thrift.meta_data.FieldMetaData("owner", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, Identity.class)));
    tmpMap.put(_Fields.CRON_SCHEDULE, new org.apache.thrift.meta_data.FieldMetaData("cronSchedule", org.apache.thrift.TFieldRequirementType.OPTIONAL, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.STRING)));
    tmpMap.put(_Fields.CRON_COLLISION_POLICY, new org.apache.thrift.meta_data.FieldMetaData("cronCollisionPolicy", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.EnumMetaData(org.apache.thrift.protocol.TType.ENUM, CronCollisionPolicy.class)));
    tmpMap.put(_Fields.TASK_CONFIG, new org.apache.thrift.meta_data.FieldMetaData("taskConfig", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.StructMetaData(org.apache.thrift.protocol.TType.STRUCT, TaskConfig.class)));
    tmpMap.put(_Fields.INSTANCE_COUNT, new org.apache.thrift.meta_data.FieldMetaData("instanceCount", org.apache.thrift.TFieldRequirementType.DEFAULT, 
        new org.apache.thrift.meta_data.FieldValueMetaData(org.apache.thrift.protocol.TType.I32)));
    metaDataMap = Collections.unmodifiableMap(tmpMap);
    org.apache.thrift.meta_data.FieldMetaData.addStructMetaDataMap(JobConfiguration.class, metaDataMap);
  }

  public JobConfiguration() {
  }

  public JobConfiguration(
    JobKey key,
    Identity owner,
    CronCollisionPolicy cronCollisionPolicy,
    TaskConfig taskConfig,
    int instanceCount)
  {
    this();
    this.key = key;
    this.owner = owner;
    this.cronCollisionPolicy = cronCollisionPolicy;
    this.taskConfig = taskConfig;
    this.instanceCount = instanceCount;
    setInstanceCountIsSet(true);
  }

  /**
   * Performs a deep copy on <i>other</i>.
   */
  public JobConfiguration(JobConfiguration other) {
    __isset_bitfield = other.__isset_bitfield;
    if (other.isSetKey()) {
      this.key = new JobKey(other.key);
    }
    if (other.isSetOwner()) {
      this.owner = new Identity(other.owner);
    }
    if (other.isSetCronSchedule()) {
      this.cronSchedule = other.cronSchedule;
    }
    if (other.isSetCronCollisionPolicy()) {
      this.cronCollisionPolicy = other.cronCollisionPolicy;
    }
    if (other.isSetTaskConfig()) {
      this.taskConfig = new TaskConfig(other.taskConfig);
    }
    this.instanceCount = other.instanceCount;
  }

  public JobConfiguration deepCopy() {
    return new JobConfiguration(this);
  }

  @Override
  public void clear() {
    this.key = null;
    this.owner = null;
    this.cronSchedule = null;
    this.cronCollisionPolicy = null;
    this.taskConfig = null;
    setInstanceCountIsSet(false);
    this.instanceCount = 0;
  }

  /**
   * Key for this job. If not specified name, owner.role, and a reasonable default environment are
   * used to construct it server-side.
   */
  public JobKey getKey() {
    return this.key;
  }

  /**
   * Key for this job. If not specified name, owner.role, and a reasonable default environment are
   * used to construct it server-side.
   */
  public JobConfiguration setKey(JobKey key) {
    this.key = key;
    return this;
  }

  public void unsetKey() {
    this.key = null;
  }

  /** Returns true if field key is set (has been assigned a value) and false otherwise */
  public boolean isSetKey() {
    return this.key != null;
  }

  public void setKeyIsSet(boolean value) {
    if (!value) {
      this.key = null;
    }
  }

  /**
   * Owner of this job.
   */
  public Identity getOwner() {
    return this.owner;
  }

  /**
   * Owner of this job.
   */
  public JobConfiguration setOwner(Identity owner) {
    this.owner = owner;
    return this;
  }

  public void unsetOwner() {
    this.owner = null;
  }

  /** Returns true if field owner is set (has been assigned a value) and false otherwise */
  public boolean isSetOwner() {
    return this.owner != null;
  }

  public void setOwnerIsSet(boolean value) {
    if (!value) {
      this.owner = null;
    }
  }

  /**
   * If present, the job will be handled as a cron job with this crontab-syntax schedule.
   */
  public String getCronSchedule() {
    return this.cronSchedule;
  }

  /**
   * If present, the job will be handled as a cron job with this crontab-syntax schedule.
   */
  public JobConfiguration setCronSchedule(String cronSchedule) {
    this.cronSchedule = cronSchedule;
    return this;
  }

  public void unsetCronSchedule() {
    this.cronSchedule = null;
  }

  /** Returns true if field cronSchedule is set (has been assigned a value) and false otherwise */
  public boolean isSetCronSchedule() {
    return this.cronSchedule != null;
  }

  public void setCronScheduleIsSet(boolean value) {
    if (!value) {
      this.cronSchedule = null;
    }
  }

  /**
   * Collision policy to use when handling overlapping cron runs.  Default is KILL_EXISTING.
   * 
   * @see CronCollisionPolicy
   */
  public CronCollisionPolicy getCronCollisionPolicy() {
    return this.cronCollisionPolicy;
  }

  /**
   * Collision policy to use when handling overlapping cron runs.  Default is KILL_EXISTING.
   * 
   * @see CronCollisionPolicy
   */
  public JobConfiguration setCronCollisionPolicy(CronCollisionPolicy cronCollisionPolicy) {
    this.cronCollisionPolicy = cronCollisionPolicy;
    return this;
  }

  public void unsetCronCollisionPolicy() {
    this.cronCollisionPolicy = null;
  }

  /** Returns true if field cronCollisionPolicy is set (has been assigned a value) and false otherwise */
  public boolean isSetCronCollisionPolicy() {
    return this.cronCollisionPolicy != null;
  }

  public void setCronCollisionPolicyIsSet(boolean value) {
    if (!value) {
      this.cronCollisionPolicy = null;
    }
  }

  /**
   * Task configuration for this job.
   */
  public TaskConfig getTaskConfig() {
    return this.taskConfig;
  }

  /**
   * Task configuration for this job.
   */
  public JobConfiguration setTaskConfig(TaskConfig taskConfig) {
    this.taskConfig = taskConfig;
    return this;
  }

  public void unsetTaskConfig() {
    this.taskConfig = null;
  }

  /** Returns true if field taskConfig is set (has been assigned a value) and false otherwise */
  public boolean isSetTaskConfig() {
    return this.taskConfig != null;
  }

  public void setTaskConfigIsSet(boolean value) {
    if (!value) {
      this.taskConfig = null;
    }
  }

  /**
   * The number of instances in the job. Generated instance IDs for tasks will be in the range
   * [0, instances).
   */
  public int getInstanceCount() {
    return this.instanceCount;
  }

  /**
   * The number of instances in the job. Generated instance IDs for tasks will be in the range
   * [0, instances).
   */
  public JobConfiguration setInstanceCount(int instanceCount) {
    this.instanceCount = instanceCount;
    setInstanceCountIsSet(true);
    return this;
  }

  public void unsetInstanceCount() {
    __isset_bitfield = EncodingUtils.clearBit(__isset_bitfield, __INSTANCECOUNT_ISSET_ID);
  }

  /** Returns true if field instanceCount is set (has been assigned a value) and false otherwise */
  public boolean isSetInstanceCount() {
    return EncodingUtils.testBit(__isset_bitfield, __INSTANCECOUNT_ISSET_ID);
  }

  public void setInstanceCountIsSet(boolean value) {
    __isset_bitfield = EncodingUtils.setBit(__isset_bitfield, __INSTANCECOUNT_ISSET_ID, value);
  }

  public void setFieldValue(_Fields field, Object value) {
    switch (field) {
    case KEY:
      if (value == null) {
        unsetKey();
      } else {
        setKey((JobKey)value);
      }
      break;

    case OWNER:
      if (value == null) {
        unsetOwner();
      } else {
        setOwner((Identity)value);
      }
      break;

    case CRON_SCHEDULE:
      if (value == null) {
        unsetCronSchedule();
      } else {
        setCronSchedule((String)value);
      }
      break;

    case CRON_COLLISION_POLICY:
      if (value == null) {
        unsetCronCollisionPolicy();
      } else {
        setCronCollisionPolicy((CronCollisionPolicy)value);
      }
      break;

    case TASK_CONFIG:
      if (value == null) {
        unsetTaskConfig();
      } else {
        setTaskConfig((TaskConfig)value);
      }
      break;

    case INSTANCE_COUNT:
      if (value == null) {
        unsetInstanceCount();
      } else {
        setInstanceCount((Integer)value);
      }
      break;

    }
  }

  public Object getFieldValue(_Fields field) {
    switch (field) {
    case KEY:
      return getKey();

    case OWNER:
      return getOwner();

    case CRON_SCHEDULE:
      return getCronSchedule();

    case CRON_COLLISION_POLICY:
      return getCronCollisionPolicy();

    case TASK_CONFIG:
      return getTaskConfig();

    case INSTANCE_COUNT:
      return getInstanceCount();

    }
    throw new IllegalStateException();
  }

  /** Returns true if field corresponding to fieldID is set (has been assigned a value) and false otherwise */
  public boolean isSet(_Fields field) {
    if (field == null) {
      throw new IllegalArgumentException();
    }

    switch (field) {
    case KEY:
      return isSetKey();
    case OWNER:
      return isSetOwner();
    case CRON_SCHEDULE:
      return isSetCronSchedule();
    case CRON_COLLISION_POLICY:
      return isSetCronCollisionPolicy();
    case TASK_CONFIG:
      return isSetTaskConfig();
    case INSTANCE_COUNT:
      return isSetInstanceCount();
    }
    throw new IllegalStateException();
  }

  @Override
  public boolean equals(Object that) {
    if (that == null)
      return false;
    if (that instanceof JobConfiguration)
      return this.equals((JobConfiguration)that);
    return false;
  }

  public boolean equals(JobConfiguration that) {
    if (that == null)
      return false;

    boolean this_present_key = true && this.isSetKey();
    boolean that_present_key = true && that.isSetKey();
    if (this_present_key || that_present_key) {
      if (!(this_present_key && that_present_key))
        return false;
      if (!this.key.equals(that.key))
        return false;
    }

    boolean this_present_owner = true && this.isSetOwner();
    boolean that_present_owner = true && that.isSetOwner();
    if (this_present_owner || that_present_owner) {
      if (!(this_present_owner && that_present_owner))
        return false;
      if (!this.owner.equals(that.owner))
        return false;
    }

    boolean this_present_cronSchedule = true && this.isSetCronSchedule();
    boolean that_present_cronSchedule = true && that.isSetCronSchedule();
    if (this_present_cronSchedule || that_present_cronSchedule) {
      if (!(this_present_cronSchedule && that_present_cronSchedule))
        return false;
      if (!this.cronSchedule.equals(that.cronSchedule))
        return false;
    }

    boolean this_present_cronCollisionPolicy = true && this.isSetCronCollisionPolicy();
    boolean that_present_cronCollisionPolicy = true && that.isSetCronCollisionPolicy();
    if (this_present_cronCollisionPolicy || that_present_cronCollisionPolicy) {
      if (!(this_present_cronCollisionPolicy && that_present_cronCollisionPolicy))
        return false;
      if (!this.cronCollisionPolicy.equals(that.cronCollisionPolicy))
        return false;
    }

    boolean this_present_taskConfig = true && this.isSetTaskConfig();
    boolean that_present_taskConfig = true && that.isSetTaskConfig();
    if (this_present_taskConfig || that_present_taskConfig) {
      if (!(this_present_taskConfig && that_present_taskConfig))
        return false;
      if (!this.taskConfig.equals(that.taskConfig))
        return false;
    }

    boolean this_present_instanceCount = true;
    boolean that_present_instanceCount = true;
    if (this_present_instanceCount || that_present_instanceCount) {
      if (!(this_present_instanceCount && that_present_instanceCount))
        return false;
      if (this.instanceCount != that.instanceCount)
        return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    List<Object> list = new ArrayList<Object>();

    boolean present_key = true && (isSetKey());
    list.add(present_key);
    if (present_key)
      list.add(key);

    boolean present_owner = true && (isSetOwner());
    list.add(present_owner);
    if (present_owner)
      list.add(owner);

    boolean present_cronSchedule = true && (isSetCronSchedule());
    list.add(present_cronSchedule);
    if (present_cronSchedule)
      list.add(cronSchedule);

    boolean present_cronCollisionPolicy = true && (isSetCronCollisionPolicy());
    list.add(present_cronCollisionPolicy);
    if (present_cronCollisionPolicy)
      list.add(cronCollisionPolicy.getValue());

    boolean present_taskConfig = true && (isSetTaskConfig());
    list.add(present_taskConfig);
    if (present_taskConfig)
      list.add(taskConfig);

    boolean present_instanceCount = true;
    list.add(present_instanceCount);
    if (present_instanceCount)
      list.add(instanceCount);

    return list.hashCode();
  }

  @Override
  public int compareTo(JobConfiguration other) {
    if (!getClass().equals(other.getClass())) {
      return getClass().getName().compareTo(other.getClass().getName());
    }

    int lastComparison = 0;

    lastComparison = Boolean.valueOf(isSetKey()).compareTo(other.isSetKey());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetKey()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.key, other.key);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetOwner()).compareTo(other.isSetOwner());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetOwner()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.owner, other.owner);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCronSchedule()).compareTo(other.isSetCronSchedule());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCronSchedule()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cronSchedule, other.cronSchedule);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetCronCollisionPolicy()).compareTo(other.isSetCronCollisionPolicy());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetCronCollisionPolicy()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.cronCollisionPolicy, other.cronCollisionPolicy);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetTaskConfig()).compareTo(other.isSetTaskConfig());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetTaskConfig()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.taskConfig, other.taskConfig);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    lastComparison = Boolean.valueOf(isSetInstanceCount()).compareTo(other.isSetInstanceCount());
    if (lastComparison != 0) {
      return lastComparison;
    }
    if (isSetInstanceCount()) {
      lastComparison = org.apache.thrift.TBaseHelper.compareTo(this.instanceCount, other.instanceCount);
      if (lastComparison != 0) {
        return lastComparison;
      }
    }
    return 0;
  }

  public _Fields fieldForId(int fieldId) {
    return _Fields.findByThriftId(fieldId);
  }

  public void read(org.apache.thrift.protocol.TProtocol iprot) throws org.apache.thrift.TException {
    schemes.get(iprot.getScheme()).getScheme().read(iprot, this);
  }

  public void write(org.apache.thrift.protocol.TProtocol oprot) throws org.apache.thrift.TException {
    schemes.get(oprot.getScheme()).getScheme().write(oprot, this);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder("JobConfiguration(");
    boolean first = true;

    sb.append("key:");
    if (this.key == null) {
      sb.append("null");
    } else {
      sb.append(this.key);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("owner:");
    if (this.owner == null) {
      sb.append("null");
    } else {
      sb.append(this.owner);
    }
    first = false;
    if (isSetCronSchedule()) {
      if (!first) sb.append(", ");
      sb.append("cronSchedule:");
      if (this.cronSchedule == null) {
        sb.append("null");
      } else {
        sb.append(this.cronSchedule);
      }
      first = false;
    }
    if (!first) sb.append(", ");
    sb.append("cronCollisionPolicy:");
    if (this.cronCollisionPolicy == null) {
      sb.append("null");
    } else {
      sb.append(this.cronCollisionPolicy);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("taskConfig:");
    if (this.taskConfig == null) {
      sb.append("null");
    } else {
      sb.append(this.taskConfig);
    }
    first = false;
    if (!first) sb.append(", ");
    sb.append("instanceCount:");
    sb.append(this.instanceCount);
    first = false;
    sb.append(")");
    return sb.toString();
  }

  public void validate() throws org.apache.thrift.TException {
    // check for required fields
    // check for sub-struct validity
    if (key != null) {
      key.validate();
    }
    if (owner != null) {
      owner.validate();
    }
    if (taskConfig != null) {
      taskConfig.validate();
    }
  }

  private void writeObject(java.io.ObjectOutputStream out) throws java.io.IOException {
    try {
      write(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(out)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private void readObject(java.io.ObjectInputStream in) throws java.io.IOException, ClassNotFoundException {
    try {
      // it doesn't seem like you should have to do this, but java serialization is wacky, and doesn't call the default constructor.
      __isset_bitfield = 0;
      read(new org.apache.thrift.protocol.TCompactProtocol(new org.apache.thrift.transport.TIOStreamTransport(in)));
    } catch (org.apache.thrift.TException te) {
      throw new java.io.IOException(te);
    }
  }

  private static class JobConfigurationStandardSchemeFactory implements SchemeFactory {
    public JobConfigurationStandardScheme getScheme() {
      return new JobConfigurationStandardScheme();
    }
  }

  private static class JobConfigurationStandardScheme extends StandardScheme<JobConfiguration> {

    public void read(org.apache.thrift.protocol.TProtocol iprot, JobConfiguration struct) throws org.apache.thrift.TException {
      org.apache.thrift.protocol.TField schemeField;
      iprot.readStructBegin();
      while (true)
      {
        schemeField = iprot.readFieldBegin();
        if (schemeField.type == org.apache.thrift.protocol.TType.STOP) { 
          break;
        }
        switch (schemeField.id) {
          case 9: // KEY
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.key = new JobKey();
              struct.key.read(iprot);
              struct.setKeyIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 7: // OWNER
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.owner = new Identity();
              struct.owner.read(iprot);
              struct.setOwnerIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 4: // CRON_SCHEDULE
            if (schemeField.type == org.apache.thrift.protocol.TType.STRING) {
              struct.cronSchedule = iprot.readString();
              struct.setCronScheduleIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 5: // CRON_COLLISION_POLICY
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.cronCollisionPolicy = org.apache.airavata.cloud.aurora.client.sdk.CronCollisionPolicy.findByValue(iprot.readI32());
              struct.setCronCollisionPolicyIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 6: // TASK_CONFIG
            if (schemeField.type == org.apache.thrift.protocol.TType.STRUCT) {
              struct.taskConfig = new TaskConfig();
              struct.taskConfig.read(iprot);
              struct.setTaskConfigIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          case 8: // INSTANCE_COUNT
            if (schemeField.type == org.apache.thrift.protocol.TType.I32) {
              struct.instanceCount = iprot.readI32();
              struct.setInstanceCountIsSet(true);
            } else { 
              org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
            }
            break;
          default:
            org.apache.thrift.protocol.TProtocolUtil.skip(iprot, schemeField.type);
        }
        iprot.readFieldEnd();
      }
      iprot.readStructEnd();

      // check for required fields of primitive type, which can't be checked in the validate method
      struct.validate();
    }

    public void write(org.apache.thrift.protocol.TProtocol oprot, JobConfiguration struct) throws org.apache.thrift.TException {
      struct.validate();

      oprot.writeStructBegin(STRUCT_DESC);
      if (struct.cronSchedule != null) {
        if (struct.isSetCronSchedule()) {
          oprot.writeFieldBegin(CRON_SCHEDULE_FIELD_DESC);
          oprot.writeString(struct.cronSchedule);
          oprot.writeFieldEnd();
        }
      }
      if (struct.cronCollisionPolicy != null) {
        oprot.writeFieldBegin(CRON_COLLISION_POLICY_FIELD_DESC);
        oprot.writeI32(struct.cronCollisionPolicy.getValue());
        oprot.writeFieldEnd();
      }
      if (struct.taskConfig != null) {
        oprot.writeFieldBegin(TASK_CONFIG_FIELD_DESC);
        struct.taskConfig.write(oprot);
        oprot.writeFieldEnd();
      }
      if (struct.owner != null) {
        oprot.writeFieldBegin(OWNER_FIELD_DESC);
        struct.owner.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldBegin(INSTANCE_COUNT_FIELD_DESC);
      oprot.writeI32(struct.instanceCount);
      oprot.writeFieldEnd();
      if (struct.key != null) {
        oprot.writeFieldBegin(KEY_FIELD_DESC);
        struct.key.write(oprot);
        oprot.writeFieldEnd();
      }
      oprot.writeFieldStop();
      oprot.writeStructEnd();
    }

  }

  private static class JobConfigurationTupleSchemeFactory implements SchemeFactory {
    public JobConfigurationTupleScheme getScheme() {
      return new JobConfigurationTupleScheme();
    }
  }

  private static class JobConfigurationTupleScheme extends TupleScheme<JobConfiguration> {

    @Override
    public void write(org.apache.thrift.protocol.TProtocol prot, JobConfiguration struct) throws org.apache.thrift.TException {
      TTupleProtocol oprot = (TTupleProtocol) prot;
      BitSet optionals = new BitSet();
      if (struct.isSetKey()) {
        optionals.set(0);
      }
      if (struct.isSetOwner()) {
        optionals.set(1);
      }
      if (struct.isSetCronSchedule()) {
        optionals.set(2);
      }
      if (struct.isSetCronCollisionPolicy()) {
        optionals.set(3);
      }
      if (struct.isSetTaskConfig()) {
        optionals.set(4);
      }
      if (struct.isSetInstanceCount()) {
        optionals.set(5);
      }
      oprot.writeBitSet(optionals, 6);
      if (struct.isSetKey()) {
        struct.key.write(oprot);
      }
      if (struct.isSetOwner()) {
        struct.owner.write(oprot);
      }
      if (struct.isSetCronSchedule()) {
        oprot.writeString(struct.cronSchedule);
      }
      if (struct.isSetCronCollisionPolicy()) {
        oprot.writeI32(struct.cronCollisionPolicy.getValue());
      }
      if (struct.isSetTaskConfig()) {
        struct.taskConfig.write(oprot);
      }
      if (struct.isSetInstanceCount()) {
        oprot.writeI32(struct.instanceCount);
      }
    }

    @Override
    public void read(org.apache.thrift.protocol.TProtocol prot, JobConfiguration struct) throws org.apache.thrift.TException {
      TTupleProtocol iprot = (TTupleProtocol) prot;
      BitSet incoming = iprot.readBitSet(6);
      if (incoming.get(0)) {
        struct.key = new JobKey();
        struct.key.read(iprot);
        struct.setKeyIsSet(true);
      }
      if (incoming.get(1)) {
        struct.owner = new Identity();
        struct.owner.read(iprot);
        struct.setOwnerIsSet(true);
      }
      if (incoming.get(2)) {
        struct.cronSchedule = iprot.readString();
        struct.setCronScheduleIsSet(true);
      }
      if (incoming.get(3)) {
        struct.cronCollisionPolicy = org.apache.airavata.cloud.aurora.client.sdk.CronCollisionPolicy.findByValue(iprot.readI32());
        struct.setCronCollisionPolicyIsSet(true);
      }
      if (incoming.get(4)) {
        struct.taskConfig = new TaskConfig();
        struct.taskConfig.read(iprot);
        struct.setTaskConfigIsSet(true);
      }
      if (incoming.get(5)) {
        struct.instanceCount = iprot.readI32();
        struct.setInstanceCountIsSet(true);
      }
    }
  }

}

