/*
 * Decompiled with CFR 0.152.
 */
package org.dozer.jmx;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.dozer.jmx.JMXPlatform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JMXPlatformImpl
implements JMXPlatform {
    private static final Logger log = LoggerFactory.getLogger(JMXPlatformImpl.class);

    public boolean isAvailable() {
        try {
            Class.forName("java.lang.management.ManagementFactory");
            Class.forName("javax.management.ObjectName");
            Class.forName("javax.management.MBeanServer");
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void registerMBean(String name, Object bean) throws MalformedObjectNameException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectName mbeanObjectName = new ObjectName(name);
        this.unregister(name, mbeanObjectName);
        this.register(name, bean, mbeanObjectName);
    }

    public void unregisterMBean(String name) throws MBeanRegistrationException, MalformedObjectNameException {
        ObjectName mbeanObjectName = new ObjectName(name);
        this.unregister(name, mbeanObjectName);
    }

    private void register(String name, Object bean, ObjectName mbeanObjectName) throws MBeanRegistrationException, NotCompliantMBeanException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(bean, mbeanObjectName);
            log.info("Dozer JMX MBean [" + name + "] auto registered with the Platform MBean Server");
        }
        catch (InstanceAlreadyExistsException e) {
            log.info("JMX MBean instance exists, unable to overwrite [{}].", (Object)name);
        }
    }

    private void unregister(String name, ObjectName mbeanObjectName) throws MBeanRegistrationException {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        boolean isMBeanRegistered = mbs.isRegistered(mbeanObjectName);
        if (isMBeanRegistered) {
            log.info("Unregistering existing Dozer JMX MBean [{}].", (Object)name);
            try {
                mbs.unregisterMBean(mbeanObjectName);
            }
            catch (InstanceNotFoundException e) {
                log.info("JMX MBean not found to unregister [{}].", (Object)name);
            }
        }
    }
}

