/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPClientImpl;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResponseStructure;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.util.encoders.Base64;

public class OCSPCachingClient {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private final long maxTtl;
    private final File diskPath;
    private final String prefix;
    private Map<String, CacheEntry> cache;

    public OCSPCachingClient(long maxTtl, File diskPath, String prefix) {
        this.maxTtl = maxTtl;
        this.diskPath = diskPath;
        this.prefix = prefix == null ? "" : prefix;
        this.cache = new Hashtable<String, CacheEntry>(20);
    }

    public OCSPResult queryForCertificate(URL responder, X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce, int timeout) throws IOException, OCSPException {
        return this.queryForCertificate(responder, toCheckCert, issuerCert, requester, addNonce, timeout, new OCSPClientImpl());
    }

    public OCSPResult queryForCertificate(URL responder, X509Certificate toCheckCert, X509Certificate issuerCert, X509Credential requester, boolean addNonce, int timeout, OCSPClientImpl client) throws IOException, OCSPException {
        if (this.maxTtl < 0L) {
            return client.queryForCertificate(responder, toCheckCert, issuerCert, requester, addNonce, timeout);
        }
        String key = this.createKey(toCheckCert, issuerCert);
        SingleResp cachedResp = this.getCachedResp(key, client, toCheckCert, issuerCert);
        if (cachedResp != null) {
            return new OCSPResult(cachedResp);
        }
        OCSPReq request = client.createRequest(toCheckCert, issuerCert, requester, addNonce);
        OCSPResponseStructure responseWithMeta = client.send(responder, request, timeout);
        OCSPResp fullResponse = responseWithMeta.getResponse();
        byte[] nonce = OCSPClientImpl.extractNonce(request);
        SingleResp singleResp = client.verifyResponse(fullResponse, toCheckCert, issuerCert, nonce);
        this.addToCache(key, responseWithMeta, singleResp);
        return new OCSPResult(singleResp);
    }

    private String createKey(X509Certificate toCheckCert, X509Certificate issuerCert) throws OCSPException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JDK problem: SHA-1 hash not supported by any provider!", e);
        }
        PublicKey issuerKey = issuerCert.getPublicKey();
        digest.update(issuerCert.getSubjectX500Principal().getEncoded());
        digest.update(issuerKey.getEncoded());
        digest.update(toCheckCert.getSerialNumber().toByteArray());
        byte[] shortBytes = digest.digest();
        byte[] ascii = Base64.encode((byte[])shortBytes);
        String ret = new String(ascii, ASCII);
        return ret.replace('/', '_');
    }

    private SingleResp getCachedResp(String key, OCSPClientImpl client, X509Certificate toCheckCert, X509Certificate issuerCert) throws IOException, OCSPException {
        Date now;
        File f;
        CacheEntry cachedResp = this.cache.get(key);
        if (cachedResp == null && this.diskPath != null && (f = new File(this.diskPath, this.prefix + key)).exists()) {
            cachedResp = this.loadFromDisk(f, client, toCheckCert, issuerCert);
        }
        if (cachedResp == null) {
            return null;
        }
        Date nextUpdate = cachedResp.response.getNextUpdate();
        Date maxCacheValidity = new Date(cachedResp.cacheDate.getTime() + this.maxTtl);
        if (nextUpdate != null && maxCacheValidity.after(nextUpdate)) {
            maxCacheValidity = nextUpdate;
        }
        if (maxCacheValidity.after(cachedResp.maxValidity)) {
            maxCacheValidity = cachedResp.maxValidity;
        }
        if ((now = new Date()).after(maxCacheValidity)) {
            this.cache.remove(key);
            if (this.diskPath != null) {
                File f2 = new File(this.diskPath, this.prefix + key);
                f2.delete();
            }
            return null;
        }
        return cachedResp.response;
    }

    private void addToCache(String key, OCSPResponseStructure fullResp, SingleResp singleResp) throws IOException {
        if (fullResp.getMaxCache() == null) {
            fullResp.setMaxCache(singleResp.getNextUpdate());
        }
        this.cache.put(key, new CacheEntry(new Date(), fullResp.getMaxCache(), singleResp));
        if (this.diskPath != null) {
            File f = new File(this.diskPath, this.prefix + key);
            this.storeToDisk(f, fullResp);
        }
    }

    public void clearMemoryCache() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeToDisk(File f, OCSPResponseStructure fullResp) throws IOException {
        if (f.exists()) {
            f.delete();
        }
        Date maxCache = fullResp.getMaxCache();
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        try {
            oos.writeObject(maxCache);
            oos.writeObject(fullResp.getResponse().getEncoded());
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CacheEntry loadFromDisk(File f, OCSPClientImpl client, X509Certificate toCheckCert, X509Certificate issuerCert) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(f));
            Date maxCache = (Date)ois.readObject();
            byte[] resp = (byte[])ois.readObject();
            OCSPResp fullResp = new OCSPResp(resp);
            SingleResp diskResp = client.verifyResponse(fullResp, toCheckCert, issuerCert, null);
            CacheEntry cacheEntry = new CacheEntry(new Date(f.lastModified()), maxCache, diskResp);
            return cacheEntry;
        }
        catch (Exception e) {
            f.delete();
            CacheEntry cacheEntry = null;
            return cacheEntry;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class CacheEntry {
        private Date cacheDate;
        private Date maxValidity;
        private SingleResp response;

        public CacheEntry(Date cacheDate, Date maxValidity, SingleResp response) {
            this.cacheDate = cacheDate;
            this.response = response;
            this.maxValidity = maxValidity;
        }
    }
}

