/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront_2012_03_15.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudfront_2012_03_15.model.CreateInvalidationRequest;
import com.amazonaws.services.cloudfront_2012_03_15.model.InvalidationBatch;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.XMLWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;

public class CreateInvalidationRequestMarshaller
implements Marshaller<Request<CreateInvalidationRequest>, CreateInvalidationRequest> {
    public Request<CreateInvalidationRequest> marshall(CreateInvalidationRequest createInvalidationRequest) {
        InvalidationBatch invalidationBatchInvalidationBatch;
        if (createInvalidationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInvalidationRequest, "AmazonCloudFront");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "2012-03-15/distribution/{DistributionId}/invalidation";
        uriResourcePath = uriResourcePath.replace("{DistributionId}", this.getString(createInvalidationRequest.getDistributionId()));
        if (uriResourcePath.contains("?")) {
            String queryString = uriResourcePath.substring(uriResourcePath.indexOf("?") + 1);
            uriResourcePath = uriResourcePath.substring(0, uriResourcePath.indexOf("?"));
            for (String s : queryString.split("[;&]")) {
                String[] nameValuePair = s.split("=");
                if (nameValuePair.length == 2) {
                    request.addParameter(nameValuePair[0], nameValuePair[1]);
                    continue;
                }
                request.addParameter(s, null);
            }
        }
        request.setResourcePath(uriResourcePath);
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)stringWriter, "http://cloudfront.amazonaws.com/doc/2012-03-15/");
        if (createInvalidationRequest != null && (invalidationBatchInvalidationBatch = createInvalidationRequest.getInvalidationBatch()) != null) {
            List<String> pathsList;
            xmlWriter.startElement("InvalidationBatch");
            if (invalidationBatchInvalidationBatch != null && (pathsList = invalidationBatchInvalidationBatch.getPaths()) != null && pathsList.size() > 0) {
                int pathsListIndex = 1;
                for (String pathsListValue : pathsList) {
                    xmlWriter.startElement("Path");
                    xmlWriter.value(pathsListValue);
                    xmlWriter.endElement();
                    ++pathsListIndex;
                }
            }
            if (invalidationBatchInvalidationBatch.getCallerReference() != null) {
                xmlWriter.startElement("CallerReference").value(invalidationBatchInvalidationBatch.getCallerReference()).endElement();
            }
            xmlWriter.endElement();
        }
        try {
            request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
            request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes().length));
            request.addHeader("Content-Type", "application/xml");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmazonClientException("Unable to marshall request to XML", (Throwable)e);
        }
        return request;
    }

    private String getString(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

