/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

final class ConditionInfo
implements DataSerializable {
    private String conditionId;
    private Map<ConditionWaiter, ConditionWaiter> waiters = new HashMap<ConditionWaiter, ConditionWaiter>(2);

    public ConditionInfo() {
    }

    public ConditionInfo(String conditionId) {
        this.conditionId = conditionId;
    }

    public boolean addWaiter(String caller, int threadId) {
        ConditionWaiter waiter = new ConditionWaiter(caller, threadId);
        return this.waiters.put(waiter, waiter) == null;
    }

    public boolean removeWaiter(String caller, int threadId) {
        return this.waiters.remove(new ConditionWaiter(caller, threadId)) != null;
    }

    public String getConditionId() {
        return this.conditionId;
    }

    public int getAwaitCount() {
        return this.waiters.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startWaiter(String caller, int threadId) {
        ConditionWaiter key = new ConditionWaiter(caller, threadId);
        ConditionWaiter waiter = this.waiters.get(key);
        if (waiter == null) {
            throw new IllegalStateException();
        }
        if (waiter.started) return false;
        waiter.started = true;
        if (!true) return false;
        return true;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.conditionId);
        int len = this.waiters.size();
        out.writeInt(len);
        if (len > 0) {
            for (ConditionWaiter w : this.waiters.values()) {
                out.writeUTF(w.caller);
                out.writeInt(w.threadId);
            }
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.conditionId = in.readUTF();
        int len = in.readInt();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                ConditionWaiter waiter = new ConditionWaiter(in.readUTF(), in.readInt());
                this.waiters.put(waiter, waiter);
            }
        }
    }

    private static class ConditionWaiter {
        String caller;
        int threadId;
        transient boolean started = false;

        ConditionWaiter() {
        }

        ConditionWaiter(String caller, int threadId) {
            this.caller = caller;
            this.threadId = threadId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionWaiter that = (ConditionWaiter)o;
            if (this.threadId != that.threadId) {
                return false;
            }
            return !(this.caller != null ? !this.caller.equals(that.caller) : that.caller != null);
        }

        public int hashCode() {
            int result = this.caller != null ? this.caller.hashCode() : 0;
            result = 31 * result + this.threadId;
            return result;
        }
    }
}

