/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.tx;

import com.hazelcast.map.MapService;
import com.hazelcast.map.operation.ContainsKeyOperation;
import com.hazelcast.map.operation.GetOperation;
import com.hazelcast.map.operation.SizeOperationFactory;
import com.hazelcast.map.tx.MapTransactionLog;
import com.hazelcast.map.tx.TxnDeleteOperation;
import com.hazelcast.map.tx.TxnLockAndGetOperation;
import com.hazelcast.map.tx.TxnSetOperation;
import com.hazelcast.map.tx.VersionedValue;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.AbstractDistributedObject;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.TransactionSupport;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.Map;
import java.util.concurrent.Future;

public abstract class TransactionalMapProxySupport
extends AbstractDistributedObject<MapService>
implements TransactionalObject {
    protected final String name;
    protected final TransactionSupport tx;

    public TransactionalMapProxySupport(String name, MapService mapService, NodeEngine nodeEngine, TransactionSupport transaction) {
        super(nodeEngine, mapService);
        this.name = name;
        this.tx = transaction;
    }

    protected void checkTransactionState() {
        if (!this.tx.getState().equals((Object)Transaction.State.ACTIVE)) {
            throw new TransactionNotActiveException("Transaction is not active!");
        }
    }

    public boolean containsKeyInternal(Data key) {
        ContainsKeyOperation operation = new ContainsKeyOperation(this.name, key);
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            Future f = invocation.invoke();
            return (Boolean)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Object getInternal(Data key) {
        Object cached;
        MapService mapService = (MapService)this.getService();
        boolean nearCacheEnabled = mapService.getMapContainer(this.name).isNearCacheEnabled();
        if (nearCacheEnabled && (cached = mapService.getFromNearCache(this.name, key)) != null) {
            return cached;
        }
        GetOperation operation = new GetOperation(this.name, key);
        NodeEngine nodeEngine = this.getNodeEngine();
        int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
        try {
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            Future f = invocation.invoke();
            return f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public int sizeInternal() {
        NodeEngine nodeEngine = this.getNodeEngine();
        try {
            Map<Integer, Object> results = nodeEngine.getOperationService().invokeOnAllPartitions("hz:impl:mapService", new SizeOperationFactory(this.name));
            int total = 0;
            for (Object result : results.values()) {
                Integer size = (Integer)((MapService)this.getService()).toObject(result);
                total += size.intValue();
            }
            return total;
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    public Data putInternal(Data key, Data value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue == null) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnSetOperation(this.name, key, value, -1L, versionedValue.version), versionedValue.version));
        return versionedValue.value;
    }

    public Data putIfAbsentInternal(Data key, Data value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue == null) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        if (versionedValue.value != null) {
            return versionedValue.value;
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnSetOperation(this.name, key, value, -1L, versionedValue.version), versionedValue.version));
        return versionedValue.value;
    }

    public Data replaceInternal(Data key, Data value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue == null) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        if (versionedValue.value == null) {
            return null;
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnSetOperation(this.name, key, value, -1L, versionedValue.version), versionedValue.version));
        return versionedValue.value;
    }

    public boolean replaceIfSameInternal(Data key, Object oldValue, Data newValue) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue == null) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        if (!((MapService)this.getService()).compare(this.name, oldValue, versionedValue.value)) {
            return false;
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnSetOperation(this.name, key, newValue, -1L, versionedValue.version), versionedValue.version));
        return true;
    }

    public Data removeInternal(Data key) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue == null) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnDeleteOperation(this.name, key, versionedValue.version), versionedValue.version));
        return versionedValue.value;
    }

    public boolean removeIfSameInternal(Data key, Object value) {
        VersionedValue versionedValue = this.lockAndGet(key, this.tx.getTimeoutMillis());
        if (versionedValue == null) {
            throw new TransactionException("Transaction couldn't obtain lock!");
        }
        if (!((MapService)this.getService()).compare(this.name, versionedValue.value, value)) {
            return false;
        }
        this.tx.addTransactionLog(new MapTransactionLog(this.name, key, new TxnDeleteOperation(this.name, key, versionedValue.version), versionedValue.version));
        return true;
    }

    private VersionedValue lockAndGet(Data key, long timeout) {
        NodeEngine nodeEngine = this.getNodeEngine();
        TxnLockAndGetOperation operation = new TxnLockAndGetOperation(this.name, key, timeout, timeout);
        operation.setThreadId(ThreadUtil.getThreadId());
        try {
            int partitionId = nodeEngine.getPartitionService().getPartitionId(key);
            Invocation invocation = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:mapService", (Operation)operation, partitionId).build();
            Future f = invocation.invoke();
            return (VersionedValue)f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public Object getId() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final String getServiceName() {
        return "hz:impl:mapService";
    }
}

