/*
 * Decompiled with CFR 0.152.
 */
package eu.unicore.samly2.validators;

import eu.unicore.samly2.SAMLConstants;
import eu.unicore.samly2.exceptions.SAMLRequesterException;
import eu.unicore.samly2.exceptions.SAMLServerException;
import eu.unicore.samly2.trust.SamlTrustChecker;
import eu.unicore.samly2.validators.AbstractSubjectQueryValidator;
import eu.unicore.samly2.validators.ReplayAttackChecker;
import java.util.HashSet;
import org.apache.xmlbeans.XmlObject;
import xmlbeans.org.oasis.saml2.assertion.AttributeType;
import xmlbeans.org.oasis.saml2.protocol.AttributeQueryDocument;

public class AttributeQueryValidator
extends AbstractSubjectQueryValidator {
    public AttributeQueryValidator(String responderEndpointUri, SamlTrustChecker trustChecker, long requestValidity, ReplayAttackChecker replayChecker) {
        super(responderEndpointUri, trustChecker, requestValidity, replayChecker);
    }

    public void validate(AttributeQueryDocument wrappingDcoument) throws SAMLServerException {
        super.validate((XmlObject)wrappingDcoument, wrappingDcoument.getAttributeQuery());
        AttributeType[] queriedAttrs = wrappingDcoument.getAttributeQuery().getAttributeArray();
        HashSet<String> uniqueAttrs = new HashSet<String>();
        for (AttributeType qa : queriedAttrs) {
            if (uniqueAttrs.contains(qa.getName() + "-||-" + qa.getNameFormat())) {
                throw new SAMLRequesterException(SAMLConstants.SubStatus.STATUS2_INVALID_ATTR, "Invalid query: attribute must be specified only once according to the SAML specification: " + qa.getName());
            }
            uniqueAttrs.add(qa.getName() + "-||-" + qa.getNameFormat());
        }
    }
}

