/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map;

import com.hazelcast.logging.ILogger;
import com.hazelcast.map.MapContainer;
import com.hazelcast.map.MapService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class MapStoreWriteProcessor
implements ScheduledEntryProcessor<Data, Object> {
    private final MapContainer mapContainer;
    private final MapService mapService;

    public MapStoreWriteProcessor(MapContainer mapContainer, MapService mapService) {
        this.mapContainer = mapContainer;
        this.mapService = mapService;
    }

    private Exception tryStore(EntryTaskScheduler<Data, Object> scheduler, ScheduledEntry<Data, Object> entry) {
        Exception exception = null;
        try {
            this.mapContainer.getStore().store(this.mapService.toObject(entry.getKey()), this.mapService.toObject(entry.getValue()));
        }
        catch (Exception e) {
            exception = e;
            scheduler.schedule(this.mapContainer.getWriteDelayMillis(), entry.getKey(), entry.getValue());
        }
        return exception;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        if (entries.isEmpty()) {
            return;
        }
        ILogger logger = this.mapService.getNodeEngine().getLogger(this.getClass());
        if (entries.size() == 1) {
            ScheduledEntry<Data, Object> entry = entries.iterator().next();
            Exception exception = this.tryStore(scheduler, entry);
            if (exception != null) {
                logger.severe(exception);
            }
        } else {
            HashMap<Object, Object> map = new HashMap<Object, Object>(entries.size());
            for (ScheduledEntry<Data, Object> entry : entries) {
                map.put(this.mapService.toObject(entry.getKey()), this.mapService.toObject(entry.getValue()));
            }
            Exception exception = null;
            try {
                this.mapContainer.getStore().storeAll((Map)map);
            }
            catch (Exception e) {
                for (ScheduledEntry<Data, Object> entry : entries) {
                    Exception temp = this.tryStore(scheduler, entry);
                    if (temp == null) continue;
                    exception = temp;
                }
            }
            if (exception != null) {
                logger.severe(exception);
            }
        }
    }
}

