/*
 * Decompiled with CFR 0.152.
 */
package org.apache.airavata.registry.core.app.catalog.resources;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.airavata.common.exception.ApplicationSettingsException;
import org.apache.airavata.common.utils.AiravataUtils;
import org.apache.airavata.registry.core.app.catalog.model.ScpDataMovement;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatAbstractResource;
import org.apache.airavata.registry.core.app.catalog.resources.AppCatalogResource;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogJPAUtils;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogQueryGenerator;
import org.apache.airavata.registry.core.app.catalog.util.AppCatalogResourceType;
import org.apache.airavata.registry.cpi.AppCatalogException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpDataMovementResource
extends AppCatAbstractResource {
    private static final Logger logger = LoggerFactory.getLogger(ScpDataMovementResource.class);
    private String queueDescription;
    private String dataMovementInterfaceId;
    private String securityProtocol;
    private String alternativeScpHostname;
    private int sshPort;
    private Timestamp createdTime;
    private Timestamp updatedTime;

    public Timestamp getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(Timestamp createdTime) {
        this.createdTime = createdTime;
    }

    public Timestamp getUpdatedTime() {
        return this.updatedTime;
    }

    public void setUpdatedTime(Timestamp updatedTime) {
        this.updatedTime = updatedTime;
    }

    @Override
    public void remove(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ScpDataMovement", new Object[0][]);
            generator.setParameter("dataMovementInterfaceId", identifier);
            Query q = generator.deleteQuery(em);
            q.executeUpdate();
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public AppCatalogResource get(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ScpDataMovement", new Object[0][]);
            generator.setParameter("dataMovementInterfaceId", identifier);
            Query q = generator.selectQuery(em);
            ScpDataMovement scpDataMovement = (ScpDataMovement)q.getSingleResult();
            ScpDataMovementResource scpDataMovementResource = (ScpDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.SCP_DATA_MOVEMENT, scpDataMovement);
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            ScpDataMovementResource scpDataMovementResource2 = scpDataMovementResource;
            return scpDataMovementResource2;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public List<AppCatalogResource> get(String fieldName, Object value) throws AppCatalogException {
        ArrayList<AppCatalogResource> scpDataMovementResources = new ArrayList<AppCatalogResource>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ScpDataMovement", new Object[0][]);
            if (fieldName.equals("queueDescription") || fieldName.equals("dataMovementInterfaceId") || fieldName.equals("securityProtocol") || fieldName.equals("alternativeScpHostname") || fieldName.equals("sshPort")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ScpDataMovement scpDataMovement = (ScpDataMovement)result;
                    ScpDataMovementResource scpDataMovementResource = (ScpDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.SCP_DATA_MOVEMENT, scpDataMovement);
                    scpDataMovementResources.add(scpDataMovementResource);
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Scp Data Movement Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Scp Data Movement Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return scpDataMovementResources;
    }

    @Override
    public List<AppCatalogResource> getAll() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getAllIds() throws AppCatalogException {
        return null;
    }

    @Override
    public List<String> getIds(String fieldName, Object value) throws AppCatalogException {
        ArrayList<String> scpDataMovementResourceIDs = new ArrayList<String>();
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            AppCatalogQueryGenerator generator = new AppCatalogQueryGenerator("ScpDataMovement", new Object[0][]);
            if (fieldName.equals("queueDescription") || fieldName.equals("dataMovementInterfaceId") || fieldName.equals("securityProtocol") || fieldName.equals("alternativeScpHostname") || fieldName.equals("sshPort")) {
                generator.setParameter(fieldName, value);
                Query q = generator.selectQuery(em);
                List results = q.getResultList();
                for (Object result : results) {
                    ScpDataMovement scpDataMovement = (ScpDataMovement)result;
                    ScpDataMovementResource scpDataMovementResource = (ScpDataMovementResource)AppCatalogJPAUtils.getResource(AppCatalogResourceType.SCP_DATA_MOVEMENT, scpDataMovement);
                    scpDataMovementResourceIDs.add(scpDataMovementResource.getDataMovementInterfaceId());
                }
            } else {
                em.getTransaction().commit();
                if (em.isOpen()) {
                    if (em.getTransaction().isActive()) {
                        em.getTransaction().rollback();
                    }
                    em.close();
                }
                logger.error("Unsupported field name for Scp Data Movement Resource.", (Throwable)new IllegalArgumentException());
                throw new IllegalArgumentException("Unsupported field name for Scp Data Movement Resource.");
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        return scpDataMovementResourceIDs;
    }

    @Override
    public void save() throws AppCatalogException {
        EntityManager em = null;
        try {
            ScpDataMovement scpDataMovement;
            em = AppCatalogJPAUtils.getEntityManager();
            ScpDataMovement existingScpDataMovement = (ScpDataMovement)em.find(ScpDataMovement.class, (Object)this.dataMovementInterfaceId);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            em = AppCatalogJPAUtils.getEntityManager();
            em.getTransaction().begin();
            if (existingScpDataMovement == null) {
                scpDataMovement = new ScpDataMovement();
                scpDataMovement.setCreationTime(AiravataUtils.getCurrentTimestamp());
            } else {
                scpDataMovement = existingScpDataMovement;
                scpDataMovement.setUpdateTime(AiravataUtils.getCurrentTimestamp());
            }
            scpDataMovement.setQueueDescription(this.getQueueDescription());
            scpDataMovement.setDataMovementInterfaceId(this.getDataMovementInterfaceId());
            scpDataMovement.setSecurityProtocol(this.getSecurityProtocol());
            scpDataMovement.setAlternativeScpHostname(this.getAlternativeScpHostname());
            scpDataMovement.setSshPort(this.getSshPort());
            if (existingScpDataMovement == null) {
                em.persist((Object)scpDataMovement);
            } else {
                em.merge((Object)scpDataMovement);
            }
            em.getTransaction().commit();
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    @Override
    public boolean isExists(Object identifier) throws AppCatalogException {
        EntityManager em = null;
        try {
            em = AppCatalogJPAUtils.getEntityManager();
            ScpDataMovement scpDataMovement = (ScpDataMovement)em.find(ScpDataMovement.class, identifier);
            if (em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
            boolean bl = scpDataMovement != null;
            return bl;
        }
        catch (ApplicationSettingsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AppCatalogException((Throwable)e);
        }
        finally {
            if (em != null && em.isOpen()) {
                if (em.getTransaction().isActive()) {
                    em.getTransaction().rollback();
                }
                em.close();
            }
        }
    }

    public String getQueueDescription() {
        return this.queueDescription;
    }

    public String getDataMovementInterfaceId() {
        return this.dataMovementInterfaceId;
    }

    public String getSecurityProtocol() {
        return this.securityProtocol;
    }

    public String getAlternativeScpHostname() {
        return this.alternativeScpHostname;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setQueueDescription(String queueDescription) {
        this.queueDescription = queueDescription;
    }

    public void setDataMovementInterfaceId(String dataMovementInterfaceId) {
        this.dataMovementInterfaceId = dataMovementInterfaceId;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void setAlternativeScpHostname(String alternativeScpHostname) {
        this.alternativeScpHostname = alternativeScpHostname;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }
}

