/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.config.Ini;
import org.apache.shiro.config.IniFactorySupport;
import org.apache.shiro.config.ReflectionBuilder;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.RealmSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.RealmFactory;
import org.apache.shiro.realm.text.IniRealm;
import org.apache.shiro.util.CollectionUtils;
import org.apache.shiro.util.LifecycleUtils;
import org.apache.shiro.util.Nameable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IniSecurityManagerFactory
extends IniFactorySupport<SecurityManager> {
    public static final String MAIN_SECTION_NAME = "main";
    public static final String SECURITY_MANAGER_NAME = "securityManager";
    public static final String INI_REALM_NAME = "iniRealm";
    private static final transient Logger log = LoggerFactory.getLogger(IniSecurityManagerFactory.class);
    private ReflectionBuilder builder;

    public IniSecurityManagerFactory() {
    }

    public IniSecurityManagerFactory(Ini config) {
        this.setIni(config);
    }

    public IniSecurityManagerFactory(String iniResourcePath) {
        this(Ini.fromResourcePath(iniResourcePath));
    }

    public Map<String, ?> getBeans() {
        return this.builder != null ? Collections.unmodifiableMap(this.builder.getObjects()) : null;
    }

    private SecurityManager getSecurityManagerBean() {
        return this.builder.getBean(SECURITY_MANAGER_NAME, SecurityManager.class);
    }

    @Override
    protected SecurityManager createDefaultInstance() {
        return new DefaultSecurityManager();
    }

    @Override
    protected SecurityManager createInstance(Ini ini) {
        if (CollectionUtils.isEmpty(ini)) {
            throw new NullPointerException("Ini argument cannot be null or empty.");
        }
        SecurityManager securityManager = this.createSecurityManager(ini);
        if (securityManager == null) {
            String msg = SecurityManager.class + " instance cannot be null.";
            throw new ConfigurationException(msg);
        }
        return securityManager;
    }

    private SecurityManager createSecurityManager(Ini ini) {
        Ini.Section mainSection = ini.getSection(MAIN_SECTION_NAME);
        if (CollectionUtils.isEmpty(mainSection)) {
            mainSection = ini.getSection("");
        }
        return this.createSecurityManager(ini, mainSection);
    }

    protected boolean isAutoApplyRealms(SecurityManager securityManager) {
        RealmSecurityManager realmSecurityManager;
        Collection<Realm> realms;
        boolean autoApply = true;
        if (securityManager instanceof RealmSecurityManager && !CollectionUtils.isEmpty(realms = (realmSecurityManager = (RealmSecurityManager)securityManager).getRealms())) {
            log.info("Realms have been explicitly set on the SecurityManager instance - auto-setting of realms will not occur.");
            autoApply = false;
        }
        return autoApply;
    }

    private SecurityManager createSecurityManager(Ini ini, Ini.Section mainSection) {
        Collection<Realm> realms;
        Map<String, ?> defaults = this.createDefaults(ini, mainSection);
        Map<String, ?> objects = this.buildInstances(mainSection, defaults);
        SecurityManager securityManager = this.getSecurityManagerBean();
        boolean autoApplyRealms = this.isAutoApplyRealms(securityManager);
        if (autoApplyRealms && !CollectionUtils.isEmpty(realms = this.getRealms(objects))) {
            this.applyRealmsToSecurityManager(realms, securityManager);
        }
        this.initRealms(securityManager);
        return securityManager;
    }

    private void initRealms(SecurityManager securityManager) {
        Collection<Realm> realms = this.getRealms(securityManager);
        if (!CollectionUtils.isEmpty(realms)) {
            LifecycleUtils.init(realms);
        }
    }

    private Collection<Realm> getRealms(SecurityManager securityManager) {
        this.assertRealmSecurityManager(securityManager);
        return ((RealmSecurityManager)securityManager).getRealms();
    }

    protected Map<String, ?> createDefaults(Ini ini, Ini.Section mainSection) {
        Realm realm;
        LinkedHashMap<String, Object> defaults = new LinkedHashMap<String, Object>();
        SecurityManager securityManager = this.createDefaultInstance();
        defaults.put(SECURITY_MANAGER_NAME, securityManager);
        if (this.shouldImplicitlyCreateRealm(ini) && (realm = this.createRealm(ini)) != null) {
            defaults.put(INI_REALM_NAME, realm);
        }
        return defaults;
    }

    private Map<String, ?> buildInstances(Ini.Section section, Map<String, ?> defaults) {
        this.builder = new ReflectionBuilder(defaults);
        return this.builder.buildObjects(section);
    }

    private void addToRealms(Collection<Realm> realms, RealmFactory factory) {
        LifecycleUtils.init(factory);
        Collection<Realm> factoryRealms = factory.getRealms();
        if (!CollectionUtils.isEmpty(factoryRealms)) {
            realms.addAll(factoryRealms);
        }
    }

    private Collection<Realm> getRealms(Map<String, ?> instances) {
        ArrayList<Realm> realms = new ArrayList<Realm>();
        for (Map.Entry<String, ?> entry : instances.entrySet()) {
            String name = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof RealmFactory) {
                this.addToRealms(realms, (RealmFactory)value);
                continue;
            }
            if (!(value instanceof Realm)) continue;
            Realm realm = (Realm)value;
            String existingName = realm.getName();
            if (existingName == null || existingName.startsWith(realm.getClass().getName())) {
                if (realm instanceof Nameable) {
                    ((Nameable)((Object)realm)).setName(name);
                    log.debug("Applied name '{}' to Nameable realm instance {}", (Object)name, (Object)realm);
                } else {
                    log.info("Realm does not implement the {} interface.  Configured name will not be applied.", (Object)Nameable.class.getName());
                }
            }
            realms.add(realm);
        }
        return realms;
    }

    private void assertRealmSecurityManager(SecurityManager securityManager) {
        if (securityManager == null) {
            throw new NullPointerException("securityManager instance cannot be null");
        }
        if (!(securityManager instanceof RealmSecurityManager)) {
            String msg = "securityManager instance is not a " + RealmSecurityManager.class.getName() + " instance.  This is required to access or configure realms on the instance.";
            throw new ConfigurationException(msg);
        }
    }

    protected void applyRealmsToSecurityManager(Collection<Realm> realms, SecurityManager securityManager) {
        this.assertRealmSecurityManager(securityManager);
        ((RealmSecurityManager)securityManager).setRealms(realms);
    }

    protected boolean shouldImplicitlyCreateRealm(Ini ini) {
        return !CollectionUtils.isEmpty(ini) && (!CollectionUtils.isEmpty(ini.getSection("roles")) || !CollectionUtils.isEmpty(ini.getSection("users")));
    }

    protected Realm createRealm(Ini ini) {
        IniRealm realm = new IniRealm();
        realm.setName(INI_REALM_NAME);
        realm.setIni(ini);
        return realm;
    }
}

