/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.plan;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.prettyprint.IPlanPrettyPrinter;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorPropertiesUtil;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;

public final class PlanStabilityVerifier {
    static final String MSG_CREATED = "created";
    static final String MSG_DELETED = "deleted";
    static final String MSG_OPERATOR_REFERENCE = "operator reference (Mutable) to";
    static final String MSG_OPERATOR_INSTANCE = "operator instance";
    static final String MSG_EXPRESSION_REFERENCE = "expression reference (Mutable) to";
    static final String MSG_EXPRESSION_INSTANCE = "expression instance";
    private static final String ERROR_MESSAGE_TEMPLATE = "%s %s (%s)";
    private static final int COLL_INIT_CAPACITY = 256;
    private final PlanSignatureRecorderVisitor recorderVisitor = new PlanSignatureRecorderVisitor();
    private final PlanStabilityVerifierVisitor verifierVisitor = new PlanStabilityVerifierVisitor();
    private final List<Mutable<ILogicalOperator>> opRefColl = new ArrayList<Mutable<ILogicalOperator>>(256);
    private final List<ILogicalOperator> opColl = new ArrayList<ILogicalOperator>(256);
    private final List<Mutable<ILogicalExpression>> exprRefColl = new ArrayList<Mutable<ILogicalExpression>>(256);
    private final List<ILogicalExpression> exprColl = new ArrayList<ILogicalExpression>(256);
    private final Deque<Mutable<ILogicalOperator>> workQueue = new ArrayDeque<Mutable<ILogicalOperator>>(256);
    private final IPlanPrettyPrinter prettyPrinter;

    public PlanStabilityVerifier(IPlanPrettyPrinter prettyPrinter) {
        this.prettyPrinter = prettyPrinter;
    }

    public void recordPlanSignature(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        this.reset();
        this.walk(opRef, this.recorderVisitor);
    }

    public void comparePlanSignature(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
        if (this.opRefColl.isEmpty()) {
            throw new IllegalStateException();
        }
        try {
            this.walk(opRef, this.verifierVisitor);
            this.ensureEmpty(this.opRefColl, MSG_DELETED, MSG_OPERATOR_REFERENCE, PlanStabilityVerifier::printOperator);
            this.ensureEmpty(this.opColl, MSG_DELETED, MSG_OPERATOR_INSTANCE, PlanStabilityVerifier::printOperator);
            this.ensureEmpty(this.exprRefColl, MSG_DELETED, MSG_EXPRESSION_REFERENCE, PlanStabilityVerifier::printExpression);
            this.ensureEmpty(this.exprColl, MSG_DELETED, MSG_EXPRESSION_INSTANCE, PlanStabilityVerifier::printExpression);
        }
        finally {
            this.reset();
        }
    }

    public void discardPlanSignature() {
        this.reset();
    }

    private void reset() {
        this.opRefColl.clear();
        this.opColl.clear();
        this.exprRefColl.clear();
        this.exprColl.clear();
    }

    private void raiseException(String operationKind, String referenceKind, String entity) throws AlgebricksException {
        String errorMessage = String.format(ERROR_MESSAGE_TEMPLATE, operationKind, referenceKind, entity);
        throw new AlgebricksException(errorMessage);
    }

    private <T> void ensureEmpty(List<T> list, String operationKind, String referenceKind, BiFunction<T, IPlanPrettyPrinter, String> printFunction) throws AlgebricksException {
        int idx = PlanStabilityVerifier.findNonNull(list);
        if (idx >= 0) {
            T listItem = list.get(idx);
            this.raiseException(operationKind, referenceKind, printFunction.apply(listItem, this.prettyPrinter));
        }
    }

    private static <T> int findItem(List<T> list, T item) {
        return PlanStabilityVerifier.indexOf(list, (listItem, paramItem) -> listItem == paramItem, item);
    }

    private static <T> int findNonNull(List<T> list) {
        return PlanStabilityVerifier.indexOf(list, (listItem, none) -> listItem != null, null);
    }

    private static <T, U> int indexOf(List<T> list, BiPredicate<T, U> predicate, U predicateParam) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            T listItem = list.get(i);
            if (!predicate.test(listItem, predicateParam)) continue;
            return i;
        }
        return -1;
    }

    static String printOperator(Mutable<ILogicalOperator> opRef, IPlanPrettyPrinter printer) {
        return PlanStabilityVerifier.printOperator((ILogicalOperator)opRef.getValue(), printer);
    }

    static String printOperator(ILogicalOperator op, IPlanPrettyPrinter printer) {
        try {
            return printer.reset().printOperator((AbstractLogicalOperator)op, false).toString();
        }
        catch (AlgebricksException e) {
            return op.toString();
        }
    }

    static String printExpression(Mutable<ILogicalExpression> exprRef, IPlanPrettyPrinter printer) {
        return PlanStabilityVerifier.printExpression((ILogicalExpression)exprRef.getValue(), printer);
    }

    static String printExpression(ILogicalExpression expr, IPlanPrettyPrinter printer) {
        try {
            return printer.reset().printExpression(expr).toString();
        }
        catch (AlgebricksException e) {
            return expr.toString();
        }
    }

    private void walk(Mutable<ILogicalOperator> opRef, IMutableReferenceVisitor<ILogicalOperator> visitor) throws AlgebricksException {
        if (!this.workQueue.isEmpty()) {
            throw new IllegalStateException();
        }
        Mutable<ILogicalOperator> currentOpRef = opRef;
        do {
            visitor.visit(currentOpRef);
        } while ((currentOpRef = this.workQueue.pollFirst()) != null);
    }

    private static interface IMutableReferenceVisitor<T> {
        public void visit(Mutable<T> var1) throws AlgebricksException;
    }

    private abstract class AbstractStabilityCheckingVisitor
    implements IMutableReferenceVisitor<ILogicalOperator>,
    ILogicalExpressionReferenceTransform {
        private AbstractStabilityCheckingVisitor() {
        }

        @Override
        public void visit(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
            ILogicalOperator op = (ILogicalOperator)opRef.getValue();
            op.acceptExpressionTransform(this);
            for (Mutable<ILogicalOperator> inputOpRef : op.getInputs()) {
                this.addChildToWorkQueue(inputOpRef, true);
            }
            if (op instanceof AbstractOperatorWithNestedPlans) {
                for (ILogicalPlan nestedPlan : ((AbstractOperatorWithNestedPlans)op).getNestedPlans()) {
                    for (Mutable<ILogicalOperator> nestedPlanRoot : nestedPlan.getRoots()) {
                        this.addChildToWorkQueue(nestedPlanRoot, false);
                    }
                }
            }
        }

        protected abstract void visitExpression(Mutable<ILogicalExpression> var1) throws AlgebricksException;

        @Override
        public final boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            this.visitExpression(exprRef);
            return false;
        }

        protected void addChildToWorkQueue(Mutable<ILogicalOperator> childOpRef, boolean addFirst) throws AlgebricksException {
            if (addFirst) {
                PlanStabilityVerifier.this.workQueue.addFirst(childOpRef);
            } else {
                PlanStabilityVerifier.this.workQueue.add(childOpRef);
            }
        }
    }

    private final class PlanStabilityVerifierVisitor
    extends AbstractStabilityCheckingVisitor {
        private PlanStabilityVerifierVisitor() {
        }

        @Override
        public void visit(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
            boolean skipInputs;
            int idx = PlanStabilityVerifier.findItem(PlanStabilityVerifier.this.opRefColl, opRef);
            if (idx < 0) {
                PlanStabilityVerifier.this.raiseException(PlanStabilityVerifier.MSG_CREATED, PlanStabilityVerifier.MSG_OPERATOR_REFERENCE, PlanStabilityVerifier.printOperator(opRef, PlanStabilityVerifier.this.prettyPrinter));
            }
            PlanStabilityVerifier.this.opRefColl.set(idx, null);
            ILogicalOperator op = (ILogicalOperator)opRef.getValue();
            idx = PlanStabilityVerifier.findItem(PlanStabilityVerifier.this.opColl, op);
            if (idx < 0) {
                PlanStabilityVerifier.this.raiseException(PlanStabilityVerifier.MSG_CREATED, PlanStabilityVerifier.MSG_OPERATOR_INSTANCE, PlanStabilityVerifier.printOperator(op, PlanStabilityVerifier.this.prettyPrinter));
            }
            PlanStabilityVerifier.this.opColl.set(idx, null);
            boolean bl = skipInputs = OperatorPropertiesUtil.isMultiOutputOperator(op) && PlanStabilityVerifier.findItem(PlanStabilityVerifier.this.opColl, op) >= 0;
            if (!skipInputs) {
                super.visit(opRef);
            }
        }

        @Override
        protected void visitExpression(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            int idx = PlanStabilityVerifier.findItem(PlanStabilityVerifier.this.exprRefColl, exprRef);
            if (idx < 0) {
                PlanStabilityVerifier.this.raiseException(PlanStabilityVerifier.MSG_CREATED, PlanStabilityVerifier.MSG_EXPRESSION_REFERENCE, PlanStabilityVerifier.printExpression(exprRef, PlanStabilityVerifier.this.prettyPrinter));
            }
            PlanStabilityVerifier.this.exprRefColl.set(idx, null);
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            idx = PlanStabilityVerifier.findItem(PlanStabilityVerifier.this.exprColl, expr);
            if (idx < 0) {
                PlanStabilityVerifier.this.raiseException(PlanStabilityVerifier.MSG_CREATED, PlanStabilityVerifier.MSG_EXPRESSION_INSTANCE, PlanStabilityVerifier.printExpression(expr, PlanStabilityVerifier.this.prettyPrinter));
            }
            PlanStabilityVerifier.this.exprColl.set(idx, null);
        }
    }

    private final class PlanSignatureRecorderVisitor
    extends AbstractStabilityCheckingVisitor {
        private PlanSignatureRecorderVisitor() {
        }

        @Override
        public void visit(Mutable<ILogicalOperator> opRef) throws AlgebricksException {
            ILogicalOperator op = (ILogicalOperator)opRef.getValue();
            boolean skipInputs = OperatorPropertiesUtil.isMultiOutputOperator(op) && PlanStabilityVerifier.findItem(PlanStabilityVerifier.this.opColl, op) >= 0;
            PlanStabilityVerifier.this.opRefColl.add(opRef);
            PlanStabilityVerifier.this.opColl.add(op);
            if (!skipInputs) {
                super.visit(opRef);
            }
        }

        @Override
        protected void addChildToWorkQueue(Mutable<ILogicalOperator> childOpRef, boolean addFirst) throws AlgebricksException {
            ILogicalOperator childOp = (ILogicalOperator)childOpRef.getValue();
            if (!OperatorPropertiesUtil.isMultiOutputOperator(childOp) && PlanStabilityVerifier.this.opColl.contains(childOp)) {
                throw new AlgebricksException("cycle: " + PlanStabilityVerifier.printOperator(childOp, PlanStabilityVerifier.this.prettyPrinter));
            }
            super.addChildToWorkQueue(childOpRef, addFirst);
        }

        @Override
        protected void visitExpression(Mutable<ILogicalExpression> exprRef) {
            PlanStabilityVerifier.this.exprRefColl.add(exprRef);
            PlanStabilityVerifier.this.exprColl.add(exprRef.getValue());
        }
    }
}

