/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.rewrites.visitor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.functions.FunctionSignature;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.ILangExpression;
import org.apache.asterix.lang.common.expression.CallExpr;
import org.apache.asterix.lang.common.expression.GbyVariableExpressionPair;
import org.apache.asterix.lang.common.expression.VariableExpr;
import org.apache.asterix.lang.common.rewrites.LangRewritingContext;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.clause.SelectBlock;
import org.apache.asterix.lang.sqlpp.expression.SelectExpression;
import org.apache.asterix.lang.sqlpp.util.FunctionMapUtil;
import org.apache.asterix.lang.sqlpp.visitor.SqlppSubstituteExpressionVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.AbstractSqlppExpressionScopingVisitor;

public class SubstituteGroupbyExpressionWithVariableVisitor
extends AbstractSqlppExpressionScopingVisitor {
    public SubstituteGroupbyExpressionWithVariableVisitor(LangRewritingContext context) {
        super(context);
    }

    @Override
    public Expression visit(SelectBlock selectBlock, ILangExpression arg) throws CompilationException {
        if (selectBlock.hasGroupbyClause()) {
            HashMap<Expression, VariableExpr> map = new HashMap<Expression, VariableExpr>();
            for (Object gbyPairList : selectBlock.getGroupbyClause().getGbyPairList()) {
                Iterator iterator = gbyPairList.iterator();
                while (iterator.hasNext()) {
                    GbyVariableExpressionPair gbyKeyPair = (GbyVariableExpressionPair)iterator.next();
                    Expression gbyKeyExpr = gbyKeyPair.getExpr();
                    if (gbyKeyExpr.getKind() == Expression.Kind.VARIABLE_EXPRESSION) continue;
                    map.putIfAbsent(gbyKeyExpr, gbyKeyPair.getVar());
                }
            }
            SubstituteGroupbyExpressionVisitor visitor = new SubstituteGroupbyExpressionVisitor(this.context, map);
            if (selectBlock.hasLetHavingClausesAfterGroupby()) {
                for (AbstractClause letHavingClause : selectBlock.getLetHavingListAfterGroupby()) {
                    letHavingClause.accept((ILangVisitor)visitor, (Object)arg);
                }
            }
            selectBlock.getSelectClause().accept(visitor, arg);
            SelectExpression selectExpression = (SelectExpression)arg;
            if (!selectExpression.getSelectSetOperation().hasRightInputs()) {
                if (selectExpression.hasOrderby()) {
                    selectExpression.getOrderbyClause().accept((ILangVisitor)visitor, (Object)arg);
                }
                if (selectExpression.hasLimit()) {
                    selectExpression.getLimitClause().accept((ILangVisitor)visitor, (Object)arg);
                }
            }
        }
        return super.visit(selectBlock, arg);
    }

    private static class SubstituteGroupbyExpressionVisitor
    extends SqlppSubstituteExpressionVisitor {
        private SubstituteGroupbyExpressionVisitor(LangRewritingContext context, Map<Expression, Expression> exprMap) {
            super(context, exprMap);
        }

        @Override
        public Expression visit(CallExpr callExpr, ILangExpression arg) throws CompilationException {
            FunctionSignature signature = callExpr.getFunctionSignature();
            if (FunctionMapUtil.isSql92AggregateFunction(signature)) {
                return callExpr;
            }
            return super.visit(callExpr, arg);
        }
    }
}

