/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.sort;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.EnumFreeSlotPolicy;
import org.apache.hyracks.dataflow.std.buffermanager.FrameFreeSlotPolicyFactory;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFrameMemoryManager;
import org.apache.hyracks.dataflow.std.buffermanager.VariableFramePool;
import org.apache.hyracks.dataflow.std.sort.FrameSorterMergeSort;
import org.apache.hyracks.dataflow.std.sort.HeapSortRunGenerator;
import org.apache.hyracks.dataflow.std.sort.IFrameSorter;
import org.apache.hyracks.dataflow.std.sort.ISorter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HybridTopKSortRunGenerator
extends HeapSortRunGenerator {
    private static final Logger LOG = LogManager.getLogger();
    private static final int SWITCH_TO_FRAME_SORTER_THRESHOLD = 2;
    private IFrameSorter frameSorter = null;
    private int tupleSorterFlushedTimes = 0;

    public HybridTopKSortRunGenerator(IHyracksTaskContext ctx, int frameLimit, int topK, int[] sortFields, INormalizedKeyComputerFactory[] keyNormalizerFactories, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) {
        super(ctx, frameLimit, topK, sortFields, keyNormalizerFactories, comparatorFactories, recordDescriptor);
    }

    @Override
    public ISorter getSorter() {
        if (this.tupleSorter != null) {
            return this.tupleSorter;
        }
        if (this.frameSorter != null) {
            return this.frameSorter;
        }
        return null;
    }

    @Override
    protected RunFileWriter getRunFileWriter() throws HyracksDataException {
        FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(HybridTopKSortRunGenerator.class.getSimpleName());
        return new RunFileWriter(file, this.ctx.getIoManager());
    }

    @Override
    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        if (this.topK <= 0) {
            return;
        }
        this.inAccessor.reset(buffer);
        if (this.tupleSorter != null) {
            boolean isBadK = false;
            for (int i = 0; i < this.inAccessor.getTupleCount(); ++i) {
                if (this.tupleSorter.insertTuple(this.inAccessor, i)) continue;
                this.flushFramesToRun();
                isBadK = true;
                if (this.tupleSorter.insertTuple(this.inAccessor, i)) continue;
                throw new HyracksDataException("The given tuple is too big to insert into the sorting memory.");
            }
            if (isBadK) {
                ++this.tupleSorterFlushedTimes;
                if (this.tupleSorterFlushedTimes > 2) {
                    if (this.tupleSorter.hasRemaining()) {
                        this.flushFramesToRun();
                    }
                    this.tupleSorter.close();
                    this.tupleSorter = null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("clear tupleSorter");
                    }
                }
            }
        } else {
            if (this.frameSorter == null) {
                VariableFrameMemoryManager bufferManager = new VariableFrameMemoryManager(new VariableFramePool((IHyracksFrameMgrContext)this.ctx, (this.frameLimit - 1) * this.ctx.getInitialFrameSize()), FrameFreeSlotPolicyFactory.createFreeSlotPolicy(EnumFreeSlotPolicy.BIGGEST_FIT, this.frameLimit - 1));
                this.frameSorter = new FrameSorterMergeSort(this.ctx, bufferManager, this.frameLimit - 1, this.sortFields, this.nmkFactories, this.comparatorFactories, this.recordDescriptor, this.topK);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("create frameSorter");
                }
            }
            if (!this.frameSorter.insertFrame(buffer)) {
                this.flushFramesToRun();
                if (!this.frameSorter.insertFrame(buffer)) {
                    throw new HyracksDataException("The given frame is too big to insert into the sorting memory.");
                }
            }
        }
    }
}

