/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.rss;

import com.rometools.fetcher.FetcherEvent;
import com.rometools.fetcher.FetcherListener;
import org.apache.asterix.external.input.record.reader.rss.RSSRecordReader;
import org.apache.logging.log4j.Logger;

class FetcherEventListenerImpl
implements FetcherListener {
    private RSSRecordReader reader;
    private Logger LOGGER;

    public FetcherEventListenerImpl(RSSRecordReader reader, Logger LOGGER) {
        this.reader = reader;
        this.LOGGER = LOGGER;
    }

    public void fetcherEvent(FetcherEvent event) {
        String eventType = event.getEventType();
        if ("FEED_POLLED".equals(eventType)) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info("\tEVENT: Feed Polled. URL = " + event.getUrlString());
            }
        } else if ("FEED_RETRIEVED".equals(eventType)) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info("\tEVENT: Feed Retrieved. URL = " + event.getUrlString());
            }
            this.reader.setModified(true);
        } else if ("FEED_UNCHANGED".equals(eventType)) {
            if (this.LOGGER.isInfoEnabled()) {
                this.LOGGER.info("\tEVENT: Feed Unchanged. URL = " + event.getUrlString());
            }
            this.reader.setModified(true);
        }
    }
}

