/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.common.result;

import org.apache.hyracks.api.result.IResultManager;
import org.apache.logging.log4j.Logger;

public class ResultStateSweeper
implements Runnable {
    private final IResultManager resultManager;
    private final long resultSweepThreshold;
    private final Logger logger;

    public ResultStateSweeper(IResultManager resultManager, long resultSweepThreshold, Logger logger) {
        this.resultManager = resultManager;
        this.resultSweepThreshold = resultSweepThreshold;
        this.logger = logger;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                Thread.sleep(this.resultSweepThreshold);
                this.resultManager.sweepExpiredResultSets();
                this.logger.trace("Result state cleanup instance successfully completed.");
            }
            catch (InterruptedException e) {
                this.logger.warn("Result cleaner thread interrupted, shutting down.");
                Thread.currentThread().interrupt();
            }
        }
    }
}

