/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.sync;

import java.io.IOException;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.ioopcallbacks.LSMIOOperationCallback;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.replication.api.PartitionReplica;
import org.apache.asterix.replication.messaging.ComponentMaskTask;
import org.apache.asterix.replication.messaging.DropIndexTask;
import org.apache.asterix.replication.messaging.MarkComponentValidTask;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.replication.sync.FileSynchronizer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.replication.IReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMDiskComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexReplicationJob;
import org.apache.hyracks.storage.am.lsm.common.api.LSMOperationType;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentId;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IndexSynchronizer {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final long MERGE_LSN = -1L;
    public static final long BULKLOAD_LSN = -2L;
    private final IReplicationJob job;
    private final INcApplicationContext appCtx;

    public IndexSynchronizer(IReplicationJob job, INcApplicationContext appCtx) {
        this.job = job;
        this.appCtx = appCtx;
    }

    public void sync(PartitionReplica replica) throws IOException {
        switch (this.job.getJobType()) {
            case LSM_COMPONENT: {
                this.syncComponent(replica);
                break;
            }
            case METADATA: {
                this.syncMetadata(replica);
                break;
            }
            default: {
                throw new IllegalStateException("unrecognized job type: " + this.job.getJobType().name());
            }
        }
    }

    private void syncComponent(PartitionReplica replica) throws IOException {
        if (this.job.getOperation() == IReplicationJob.ReplicationOperation.REPLICATE) {
            this.replicateComponent(replica);
        } else if (this.job.getOperation() == IReplicationJob.ReplicationOperation.DELETE) {
            this.deleteComponent(replica);
        }
    }

    private void syncMetadata(PartitionReplica replica) throws IOException {
        if (this.job.getOperation() == IReplicationJob.ReplicationOperation.REPLICATE) {
            this.replicateIndexMetadata(replica);
        } else if (this.job.getOperation() == IReplicationJob.ReplicationOperation.DELETE) {
            this.deleteIndexMetadata(replica);
        }
    }

    private void replicateComponent(PartitionReplica replica) throws IOException {
        String anyFile = this.job.getAnyFile();
        String indexFile = StoragePathUtil.getFileRelativePath((String)anyFile);
        ComponentMaskTask maskTask = new ComponentMaskTask(indexFile);
        ReplicationProtocol.sendTo(replica, maskTask);
        ReplicationProtocol.waitForAck(replica);
        FileSynchronizer fileSynchronizer = new FileSynchronizer(this.appCtx, replica);
        this.job.getJobFiles().stream().map(StoragePathUtil::getFileRelativePath).forEach(fileSynchronizer::replicate);
        MarkComponentValidTask markValidTask = new MarkComponentValidTask(indexFile, this.getReplicatedComponentLsn(), this.getReplicatedComponentId());
        ReplicationProtocol.sendTo(replica, markValidTask);
        ReplicationProtocol.waitForAck(replica);
        LOGGER.debug("Replicated component ({}) to replica {}", (Object)indexFile, (Object)replica);
    }

    private void deleteComponent(PartitionReplica replica) {
        FileSynchronizer fileSynchronizer = new FileSynchronizer(this.appCtx, replica);
        this.job.getJobFiles().stream().map(StoragePathUtil::getFileRelativePath).forEach(fileSynchronizer::delete);
    }

    private void replicateIndexMetadata(PartitionReplica replica) {
        FileSynchronizer fileSynchronizer = new FileSynchronizer(this.appCtx, replica);
        this.job.getJobFiles().stream().map(StoragePathUtil::getFileRelativePath).forEach(file -> fileSynchronizer.replicate((String)file, true));
    }

    private void deleteIndexMetadata(PartitionReplica replica) throws IOException {
        String file = StoragePathUtil.getFileRelativePath((String)this.job.getAnyFile());
        DropIndexTask task = new DropIndexTask(file);
        ReplicationProtocol.sendTo(replica, task);
        ReplicationProtocol.waitForAck(replica);
    }

    private long getReplicatedComponentLsn() throws HyracksDataException {
        ILSMIndexReplicationJob indexReplJob = (ILSMIndexReplicationJob)this.job;
        if (indexReplJob.getLSMOpType() == LSMOperationType.MERGE) {
            return -1L;
        }
        if (indexReplJob.getLSMOpType() == LSMOperationType.LOAD) {
            return -2L;
        }
        if (indexReplJob.getLSMOpType() != LSMOperationType.FLUSH) {
            return -1L;
        }
        ILSMIndex lsmIndex = indexReplJob.getLSMIndex();
        ILSMIndexOperationContext ctx = indexReplJob.getLSMIndexOperationContext();
        return ((LSMIOOperationCallback)lsmIndex.getIOOperationCallback()).getComponentLSN(ctx.getComponentsToBeReplicated());
    }

    private long getReplicatedComponentId() throws HyracksDataException {
        ILSMIndexReplicationJob indexReplJob = (ILSMIndexReplicationJob)this.job;
        if (indexReplJob.getLSMOpType() != LSMOperationType.FLUSH) {
            return -1L;
        }
        ILSMIndexOperationContext ctx = indexReplJob.getLSMIndexOperationContext();
        LSMComponentId id = (LSMComponentId)((ILSMDiskComponent)ctx.getComponentsToBeReplicated().get(0)).getId();
        return id.getMinId();
    }
}

