/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.hyracks.api.compression.ICompressorDecompressorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.api.util.IoUtil;
import org.apache.hyracks.storage.am.common.api.ITreeIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMComponentFileReferences;
import org.apache.hyracks.storage.am.lsm.common.impls.TreeIndexFactory;
import org.apache.hyracks.storage.common.compression.NoOpCompressorDecompressorFactory;

public class LSMBTreeFileManager
extends AbstractLSMIndexFileManager {
    private static final FilenameFilter btreeFilter = (dir, name) -> !name.startsWith(".") && name.endsWith("b");
    private final TreeIndexFactory<? extends ITreeIndex> btreeFactory;
    private final boolean hasBloomFilter;

    public LSMBTreeFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, boolean hasBloomFilter, ICompressorDecompressorFactory compressorDecompressorFactory) {
        super(ioManager, file, null, compressorDecompressorFactory);
        this.btreeFactory = btreeFactory;
        this.hasBloomFilter = hasBloomFilter;
    }

    public LSMBTreeFileManager(IIOManager ioManager, FileReference file, TreeIndexFactory<? extends ITreeIndex> btreeFactory, boolean hasBloomFilter) {
        this(ioManager, file, btreeFactory, hasBloomFilter, NoOpCompressorDecompressorFactory.INSTANCE);
    }

    public LSMComponentFileReferences getRelFlushFileReference() throws HyracksDataException {
        String baseName = this.getNextComponentSequence(btreeFilter);
        return new LSMComponentFileReferences(this.getFileReference(baseName + "_" + "b"), null, this.hasBloomFilter ? this.getFileReference(baseName + "_" + "f") : null);
    }

    public LSMComponentFileReferences getRelMergeFileReference(String firstFileName, String lastFileName) {
        String baseName = IndexComponentFileReference.getMergeSequence((String)firstFileName, (String)lastFileName);
        return new LSMComponentFileReferences(this.getFileReference(baseName + "_" + "b"), null, this.hasBloomFilter ? this.getFileReference(baseName + "_" + "f") : null);
    }

    public List<LSMComponentFileReferences> cleanupAndGetValidFiles() throws HyracksDataException {
        ArrayList<LSMComponentFileReferences> validFiles = new ArrayList<LSMComponentFileReferences>();
        ArrayList allBTreeFiles = new ArrayList();
        ArrayList allBloomFilterFiles = new ArrayList();
        FilenameFilter transactionFilter = this.getTransactionFileFilter(false);
        this.cleanupAndGetValidFilesInternal(this.getCompoundFilter(transactionFilter, btreeFilter), this.btreeFactory, allBTreeFiles, this.btreeFactory.getBufferCache());
        HashSet<String> btreeFilesSet = new HashSet<String>();
        for (IndexComponentFileReference cmpFileName : allBTreeFiles) {
            int index = cmpFileName.getFileName().lastIndexOf("_");
            btreeFilesSet.add(cmpFileName.getFileName().substring(0, index));
        }
        if (this.hasBloomFilter) {
            this.validateFiles(btreeFilesSet, allBloomFilterFiles, this.getCompoundFilter(transactionFilter, bloomFilterFilter), null, this.btreeFactory.getBufferCache());
            if (allBTreeFiles.size() != allBloomFilterFiles.size()) {
                throw HyracksDataException.create((int)87, (Serializable[])new Serializable[]{this.baseDir});
            }
        }
        if (allBTreeFiles.isEmpty() || this.hasBloomFilter && allBloomFilterFiles.isEmpty()) {
            return validFiles;
        }
        if (!(allBTreeFiles.size() != 1 || this.hasBloomFilter && allBloomFilterFiles.size() != 1)) {
            validFiles.add(new LSMComponentFileReferences(((IndexComponentFileReference)allBTreeFiles.get(0)).getFileRef(), null, this.hasBloomFilter ? ((IndexComponentFileReference)allBloomFilterFiles.get(0)).getFileRef() : null));
            return validFiles;
        }
        Collections.sort(allBTreeFiles);
        if (this.hasBloomFilter) {
            Collections.sort(allBloomFilterFiles);
        }
        ArrayList<IndexComponentFileReference> validComparableBTreeFiles = new ArrayList<IndexComponentFileReference>();
        IndexComponentFileReference lastBTree = (IndexComponentFileReference)allBTreeFiles.get(0);
        validComparableBTreeFiles.add(lastBTree);
        ArrayList<IndexComponentFileReference> validComparableBloomFilterFiles = null;
        IndexComponentFileReference lastBloomFilter = null;
        if (this.hasBloomFilter) {
            validComparableBloomFilterFiles = new ArrayList<IndexComponentFileReference>();
            lastBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(0);
            validComparableBloomFilterFiles.add(lastBloomFilter);
        }
        IndexComponentFileReference currentBloomFilter = null;
        for (int i = 1; i < allBTreeFiles.size(); ++i) {
            IndexComponentFileReference currentBTree = (IndexComponentFileReference)allBTreeFiles.get(i);
            if (this.hasBloomFilter) {
                currentBloomFilter = (IndexComponentFileReference)allBloomFilterFiles.get(i);
            }
            if (currentBTree.isMoreRecentThan(lastBTree) && (!this.hasBloomFilter || currentBloomFilter.isMoreRecentThan(lastBloomFilter))) {
                validComparableBTreeFiles.add(currentBTree);
                lastBTree = currentBTree;
                if (!this.hasBloomFilter) continue;
                validComparableBloomFilterFiles.add(currentBloomFilter);
                lastBloomFilter = currentBloomFilter;
                continue;
            }
            if (currentBTree.isWithin(lastBTree) && (!this.hasBloomFilter || currentBloomFilter.isWithin(lastBloomFilter))) {
                this.delete(this.btreeFactory.getBufferCache(), currentBTree.getFileRef());
                if (!this.hasBloomFilter) continue;
                this.delete(this.btreeFactory.getBufferCache(), currentBloomFilter.getFileRef());
                continue;
            }
            throw HyracksDataException.create((int)84, (Serializable[])new Serializable[]{this.baseDir});
        }
        Collections.sort(validComparableBTreeFiles, this.recencyCmp);
        Iterator btreeFileIter = validComparableBTreeFiles.iterator();
        Iterator bloomFilterFileIter = null;
        if (this.hasBloomFilter) {
            Collections.sort(validComparableBloomFilterFiles, this.recencyCmp);
            bloomFilterFileIter = validComparableBloomFilterFiles.iterator();
        }
        IndexComponentFileReference cmpBTreeFileName = null;
        IndexComponentFileReference cmpBloomFilterFileName = null;
        while (btreeFileIter.hasNext() && (!this.hasBloomFilter || bloomFilterFileIter.hasNext())) {
            cmpBTreeFileName = (IndexComponentFileReference)btreeFileIter.next();
            if (this.hasBloomFilter) {
                cmpBloomFilterFileName = (IndexComponentFileReference)bloomFilterFileIter.next();
            }
            validFiles.add(new LSMComponentFileReferences(cmpBTreeFileName.getFileRef(), null, this.hasBloomFilter ? cmpBloomFilterFileName.getFileRef() : null));
        }
        return validFiles;
    }

    public LSMComponentFileReferences getNewTransactionFileReference() throws IOException {
        String sequence = this.getNextComponentSequence(btreeFilter);
        IoUtil.create((FileReference)this.baseDir.getChild(".T" + sequence));
        String baseName = this.getNextComponentSequence(btreeFilter);
        return new LSMComponentFileReferences(this.baseDir.getChild(baseName + "_" + "b"), null, this.baseDir.getChild(baseName + "_" + "f"));
    }

    public LSMComponentFileReferences getTransactionFileReferenceForCommit() throws HyracksDataException {
        String[] files = this.baseDir.getFile().list(txnFileNameFilter);
        if (files.length == 0) {
            return null;
        }
        if (files.length != 1) {
            throw HyracksDataException.create((int)85, (Serializable[])new Serializable[]{this.baseDir});
        }
        FilenameFilter transactionFilter = this.getTransactionFileFilter(true);
        FileReference txnFile = this.baseDir.getChild(files[0]);
        files = this.baseDir.getFile().list(transactionFilter);
        IoUtil.delete((FileReference)txnFile);
        FileReference bTreeFileRef = null;
        FileReference bloomFilterFileRef = null;
        for (String fileName : files) {
            if (fileName.endsWith("b")) {
                bTreeFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            if (fileName.endsWith("f")) {
                bloomFilterFileRef = this.baseDir.getChild(fileName);
                continue;
            }
            throw HyracksDataException.create((int)86, (Serializable[])new Serializable[]{fileName});
        }
        return new LSMComponentFileReferences(bTreeFileRef, null, bloomFilterFileRef);
    }
}

