/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.base;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.base.temporal.GregorianCalendarSystem;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class ADuration
implements IAObject {
    protected int chrononInMonth;
    protected long chrononInMillisecond;

    public ADuration(int months, long seconds) {
        this.chrononInMonth = months;
        this.chrononInMillisecond = seconds;
    }

    public int getMonths() {
        return this.chrononInMonth;
    }

    public long getMilliseconds() {
        return this.chrononInMillisecond;
    }

    @Override
    public IAType getType() {
        return BuiltinType.ADURATION;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ADuration)) {
            return false;
        }
        ADuration d = (ADuration)o;
        return d.getMonths() == this.chrononInMonth && d.getMilliseconds() == this.chrononInMillisecond;
    }

    public int hashCode() {
        return (int)((long)this.chrononInMonth ^ this.chrononInMillisecond ^ this.chrononInMillisecond >>> 32);
    }

    @Override
    public boolean deepEqual(IAObject obj) {
        return this.equals(obj);
    }

    @Override
    public int hash() {
        return this.hashCode();
    }

    public String toString() {
        StringBuilder sbder = new StringBuilder();
        sbder.append("duration: {");
        GregorianCalendarSystem.getInstance().getDurationExtendStringRepWithTimezoneUntilField(this.chrononInMillisecond, this.chrononInMonth, sbder);
        sbder.append(" }");
        return sbder.toString();
    }

    public ObjectNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ObjectNode json = om.createObjectNode();
        ObjectNode duration = om.createObjectNode();
        duration.put("months", this.chrononInMonth);
        duration.put("milliseconds", this.chrononInMillisecond);
        json.set("ADuration", (JsonNode)duration);
        return json;
    }
}

