/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.translator.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.metadata.utils.KeyFieldTypeUtil;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class ValidateUtil {
    private ValidateUtil() {
    }

    public static void validateFilterField(ARecordType recordType, ARecordType metaType, Integer filterSourceIndicator, List<String> filterField, SourceLocation sourceLoc) throws AlgebricksException {
        ARecordType itemType = filterSourceIndicator == 0 ? recordType : metaType;
        IAType fieldType = itemType.getSubFieldType(filterField);
        if (fieldType == null) {
            throw new CompilationException(1014, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(filterField)});
        }
        switch (fieldType.getTypeTag()) {
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BINARY: 
            case DATE: 
            case TIME: 
            case DATETIME: 
            case UUID: 
            case YEARMONTHDURATION: 
            case DAYTIMEDURATION: {
                break;
            }
            case UNION: {
                throw new CompilationException(1017, new Serializable[]{RecordUtil.toFullyQualifiedName(filterField)});
            }
            default: {
                throw new CompilationException(1018, new Serializable[]{fieldType.getTypeTag().name()});
            }
        }
    }

    public static List<IAType> validatePartitioningExpressions(ARecordType recType, ARecordType metaRecType, List<List<String>> partitioningExprs, List<Integer> keySourceIndicators, boolean autogenerated, SourceLocation sourceLoc) throws AlgebricksException {
        ArrayList<IAType> partitioningExprTypes = new ArrayList(partitioningExprs.size());
        if (autogenerated) {
            if (partitioningExprs.size() > 1) {
                throw new CompilationException(1019, sourceLoc, new Serializable[0]);
            }
            List<String> fieldName = partitioningExprs.get(0);
            IAType fieldType = recType.getSubFieldType(fieldName);
            if (fieldType == null) {
                String unTypeField = fieldName.get(0) == null ? "" : fieldName.get(0);
                throw new CompilationException(1014, sourceLoc, new Serializable[]{unTypeField});
            }
            partitioningExprTypes.add(fieldType);
            ATypeTag pkTypeTag = fieldType.getTypeTag();
            if (pkTypeTag != ATypeTag.UUID) {
                throw new CompilationException(1020, sourceLoc, new Serializable[]{pkTypeTag.name(), ATypeTag.UUID.name()});
            }
        } else {
            partitioningExprTypes = KeyFieldTypeUtil.getKeyTypes((ARecordType)recType, (ARecordType)metaRecType, partitioningExprs, keySourceIndicators);
            block4: for (int i = 0; i < partitioningExprs.size(); ++i) {
                List<String> partitioningExpr = partitioningExprs.get(i);
                IAType fieldType = (IAType)partitioningExprTypes.get(i);
                if (fieldType == null) {
                    throw new CompilationException(1014, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(partitioningExpr)});
                }
                boolean nullable = KeyFieldTypeUtil.chooseSource(keySourceIndicators, (int)i, (ARecordType)recType, (ARecordType)metaRecType).isSubFieldNullable(partitioningExpr);
                if (nullable) {
                    throw new CompilationException(1021, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(partitioningExpr)});
                }
                switch (fieldType.getTypeTag()) {
                    case TINYINT: 
                    case SMALLINT: 
                    case INTEGER: 
                    case BIGINT: 
                    case FLOAT: 
                    case DOUBLE: 
                    case STRING: 
                    case BINARY: 
                    case DATE: 
                    case TIME: 
                    case DATETIME: 
                    case UUID: 
                    case YEARMONTHDURATION: 
                    case DAYTIMEDURATION: {
                        continue block4;
                    }
                    case UNION: {
                        throw new CompilationException(1021, sourceLoc, new Serializable[]{RecordUtil.toFullyQualifiedName(partitioningExpr)});
                    }
                    default: {
                        throw new CompilationException(1022, sourceLoc, new Serializable[]{fieldType.getTypeTag()});
                    }
                }
            }
        }
        return partitioningExprTypes;
    }

    public static void validateKeyFields(ARecordType recType, ARecordType metaRecType, List<List<String>> keyFieldNames, List<Integer> keySourceIndicators, List<IAType> keyFieldTypes, DatasetConfig.IndexType indexType) throws AlgebricksException {
        List fieldTypes = KeyFieldTypeUtil.getKeyTypes((ARecordType)recType, (ARecordType)metaRecType, keyFieldNames, keySourceIndicators);
        int pos = 0;
        boolean openFieldCompositeIdx = false;
        for (IAType fieldType : fieldTypes) {
            List<String> fieldName = keyFieldNames.get(pos);
            if (fieldType == null) {
                fieldType = keyFieldTypes.get(pos);
                if (keyFieldTypes.get(pos) == BuiltinType.AMISSING) {
                    throw new AsterixException("A field with this name  \"" + fieldName + "\" could not be found.");
                }
            } else if (openFieldCompositeIdx) {
                throw new AsterixException("A closed field \"" + fieldName + "\" could be only in a prefix part of the composite index, containing opened field.");
            }
            if (keyFieldTypes.get(pos) != BuiltinType.AMISSING && fieldType.getTypeTag() != keyFieldTypes.get(pos).getTypeTag()) {
                throw new AsterixException("A field \"" + fieldName + "\" is already defined with the type \"" + fieldType + "\"");
            }
            block0 : switch (indexType) {
                case BTREE: {
                    switch (fieldType.getTypeTag()) {
                        case TINYINT: 
                        case SMALLINT: 
                        case INTEGER: 
                        case BIGINT: 
                        case FLOAT: 
                        case DOUBLE: 
                        case STRING: 
                        case BINARY: 
                        case DATE: 
                        case TIME: 
                        case DATETIME: 
                        case UUID: 
                        case YEARMONTHDURATION: 
                        case DAYTIMEDURATION: 
                        case UNION: {
                            break block0;
                        }
                    }
                    throw new AsterixException("The field \"" + fieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the BTree index.");
                }
                case RTREE: {
                    switch (fieldType.getTypeTag()) {
                        case UNION: 
                        case POINT: 
                        case LINE: 
                        case RECTANGLE: 
                        case CIRCLE: 
                        case POLYGON: 
                        case GEOMETRY: {
                            break block0;
                        }
                    }
                    throw new AsterixException("The field \"" + fieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the RTree index.");
                }
                case LENGTH_PARTITIONED_NGRAM_INVIX: {
                    switch (fieldType.getTypeTag()) {
                        case STRING: 
                        case UNION: {
                            break block0;
                        }
                    }
                    throw new AsterixException("The field \"" + fieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Length Partitioned N-Gram index.");
                }
                case LENGTH_PARTITIONED_WORD_INVIX: {
                    switch (fieldType.getTypeTag()) {
                        case STRING: 
                        case UNION: 
                        case MULTISET: 
                        case ARRAY: {
                            break block0;
                        }
                    }
                    throw new AsterixException("The field \"" + fieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Length Partitioned Keyword index.");
                }
                case SINGLE_PARTITION_NGRAM_INVIX: {
                    switch (fieldType.getTypeTag()) {
                        case STRING: 
                        case UNION: {
                            break block0;
                        }
                    }
                    throw new AsterixException("The field \"" + fieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the N-Gram index.");
                }
                case SINGLE_PARTITION_WORD_INVIX: {
                    switch (fieldType.getTypeTag()) {
                        case STRING: 
                        case UNION: 
                        case MULTISET: 
                        case ARRAY: {
                            break block0;
                        }
                    }
                    throw new AsterixException("The field \"" + fieldName + "\" which is of type " + fieldType.getTypeTag() + " cannot be indexed using the Keyword index.");
                }
                default: {
                    throw new AsterixException("Invalid index type: " + indexType + ".");
                }
            }
            ++pos;
        }
    }
}

