/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.util;

import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.expression.RecordConstructor;
import org.apache.asterix.lang.common.util.ConfigurationTypeValidator;
import org.apache.asterix.lang.common.util.ExpressionUtils;
import org.apache.asterix.object.base.AdmObjectNode;
import org.apache.asterix.object.base.IAdmNode;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;

public class FullTextUtil {
    private static final ARecordType FULL_TEXT_CONFIG_RECORD_TYPE = FullTextUtil.getFullTextConfigRecordType();

    private FullTextUtil() {
    }

    private static ARecordType getFullTextConfigRecordType() {
        String[] fieldNames = new String[]{"tokenizer", "filterPipeline"};
        IAType[] fieldTypes = new IAType[]{BuiltinType.ASTRING, new AOrderedListType((IAType)BuiltinType.ASTRING, null)};
        return new ARecordType("fullTextConfigRecordType", fieldNames, fieldTypes, true);
    }

    public static AdmObjectNode validateAndGetConfigNode(RecordConstructor recordConstructor) throws CompilationException {
        ConfigurationTypeValidator validator = new ConfigurationTypeValidator();
        AdmObjectNode node = ExpressionUtils.toNode(recordConstructor);
        validator.validateType((IAType)FULL_TEXT_CONFIG_RECORD_TYPE, (IAdmNode)node);
        return node;
    }

    public static AdmObjectNode getFilterNode(RecordConstructor recordConstructor) throws CompilationException {
        AdmObjectNode node = ExpressionUtils.toNode(recordConstructor);
        return node;
    }
}

