/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.typing;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IExpressionTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.expressions.IMissableTypeComputer;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.properties.TypePropagationPolicy;
import org.apache.hyracks.algebricks.core.algebra.typing.AbstractTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypeEnvPointer;

public class PropagatingTypeEnvironment
extends AbstractTypeEnvironment {
    private final TypePropagationPolicy policy;
    private final IMissableTypeComputer missableTypeComputer;
    private final ITypeEnvPointer[] envPointers;
    private final List<LogicalVariable> nonMissableVariables = new ArrayList<LogicalVariable>();
    private final List<List<LogicalVariable>> correlatedMissableVariableLists = new ArrayList<List<LogicalVariable>>();

    public PropagatingTypeEnvironment(IExpressionTypeComputer expressionTypeComputer, IMissableTypeComputer missableTypeComputer, IMetadataProvider<?, ?> metadataProvider, TypePropagationPolicy policy, ITypeEnvPointer[] envPointers) {
        super(expressionTypeComputer, metadataProvider);
        this.missableTypeComputer = missableTypeComputer;
        this.policy = policy;
        this.envPointers = envPointers;
    }

    @Override
    public Object getVarType(LogicalVariable var) throws AlgebricksException {
        return this.getVarTypeFullList(var, this.nonMissableVariables, this.correlatedMissableVariableLists);
    }

    public List<LogicalVariable> getNonMissableVariables() {
        return this.nonMissableVariables;
    }

    public List<List<LogicalVariable>> getCorrelatedMissableVariableLists() {
        return this.correlatedMissableVariableLists;
    }

    @Override
    public Object getVarType(LogicalVariable var, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists) throws AlgebricksException {
        for (LogicalVariable v : this.nonMissableVariables) {
            if (nonMissableVariableList.contains(v)) continue;
            nonMissableVariableList.add(v);
        }
        Object t = this.getVarTypeFullList(var, nonMissableVariableList, correlatedMissableVariableLists);
        for (List<LogicalVariable> list : correlatedMissableVariableLists) {
            if (correlatedMissableVariableLists.contains(list)) continue;
            correlatedMissableVariableLists.add(list);
        }
        return t;
    }

    private Object getVarTypeFullList(LogicalVariable var, List<LogicalVariable> nonMissableVariableList, List<List<LogicalVariable>> correlatedMissableVariableLists) throws AlgebricksException {
        Object t = this.varTypeMap.get(var);
        if (t != null) {
            return t;
        }
        return this.policy.getVarType(var, this.missableTypeComputer, nonMissableVariableList, correlatedMissableVariableLists, this.envPointers);
    }

    @Override
    public boolean substituteProducedVariable(LogicalVariable v1, LogicalVariable v2) throws AlgebricksException {
        boolean result = super.substituteProducedVariable(v1, v2);
        if (this.nonMissableVariables.remove(v1)) {
            this.nonMissableVariables.add(v2);
        }
        for (List<LogicalVariable> missableVarList : this.correlatedMissableVariableLists) {
            if (!missableVarList.remove(v1)) continue;
            missableVarList.add(v2);
        }
        return result;
    }
}

