/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalExpressionReferenceTransform;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.core.algebra.visitors.LogicalExpressionReferenceTransformVisitor;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class InlineVariablesRule
implements IAlgebraicRewriteRule {
    private Map<LogicalVariable, ILogicalExpression> varAssignRhs = new HashMap<LogicalVariable, ILogicalExpression>();
    protected InlineVariablesVisitor inlineVisitor = new InlineVariablesVisitor(this.varAssignRhs);
    protected Set<FunctionIdentifier> doNotInlineFuncs = new HashSet<FunctionIdentifier>();
    private boolean hasRun = false;
    private final Map<ILogicalOperator, Boolean> subTreesDone = new HashMap<ILogicalOperator, Boolean>();

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) {
        return false;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        if (this.hasRun) {
            return false;
        }
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)opRef.getValue())) {
            return false;
        }
        this.prepare(context);
        boolean modified = this.inlineVariables(opRef, context);
        if (this.performFinalAction()) {
            modified = true;
        }
        this.hasRun = true;
        return modified;
    }

    protected void prepare(IOptimizationContext context) {
        this.varAssignRhs.clear();
        this.inlineVisitor.setContext(context);
        this.subTreesDone.clear();
    }

    protected boolean performBottomUpAction(AbstractLogicalOperator op) throws AlgebricksException {
        if (!op.requiresVariableReferenceExpressions()) {
            this.inlineVisitor.setOperator((ILogicalOperator)op);
            return (Boolean)op.accept((ILogicalOperatorVisitor)this.inlineVisitor, (Object)this.inlineVisitor);
        }
        return false;
    }

    protected boolean performFinalAction() throws AlgebricksException {
        return false;
    }

    private boolean inlineVariables(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (this.subTreesDone.containsKey(op)) {
            return this.subTreesDone.get(op);
        }
        if (op.getOperatorTag() == LogicalOperatorTag.ASSIGN) {
            AssignOperator assignOp = (AssignOperator)op;
            List vars = assignOp.getVariables();
            List exprs = assignOp.getExpressions();
            for (int i = 0; i < vars.size(); ++i) {
                AbstractFunctionCallExpression funcExpr;
                ILogicalExpression expr = (ILogicalExpression)((Mutable)exprs.get(i)).getValue();
                if (expr.getExpressionTag() == LogicalExpressionTag.FUNCTION_CALL && (this.doNotInlineFuncs.contains((funcExpr = (AbstractFunctionCallExpression)expr).getFunctionIdentifier()) || !funcExpr.isFunctional())) continue;
                this.varAssignRhs.put((LogicalVariable)vars.get(i), (ILogicalExpression)((Mutable)exprs.get(i)).getValue());
            }
        }
        boolean modified = false;
        for (Mutable inputOpRef : op.getInputs()) {
            if (!this.inlineVariables((Mutable<ILogicalOperator>)inputOpRef, context)) continue;
            modified = true;
        }
        if (op.getOperatorTag() == LogicalOperatorTag.SUBPLAN || op.getOperatorTag() == LogicalOperatorTag.WINDOW) {
            List nestedPlans = ((AbstractOperatorWithNestedPlans)op).getNestedPlans();
            for (ILogicalPlan nestedPlan : nestedPlans) {
                for (Mutable root : nestedPlan.getRoots()) {
                    if (this.inlineVariables((Mutable<ILogicalOperator>)root, context)) {
                        modified = true;
                    }
                    HashSet producedVars = new HashSet();
                    VariableUtilities.getProducedVariables((ILogicalOperator)((ILogicalOperator)root.getValue()), producedVars);
                    this.varAssignRhs.keySet().removeAll(producedVars);
                }
            }
        }
        if (op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
            HashSet rightLiveVars = new HashSet();
            VariableUtilities.getLiveVariables((ILogicalOperator)((ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue()), rightLiveVars);
            this.varAssignRhs.keySet().removeAll(rightLiveVars);
        }
        if (this.performBottomUpAction(op)) {
            modified = true;
        }
        if (modified) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
            context.removeFromAlreadyCompared((ILogicalOperator)opRef.getValue());
        }
        if (op.getOperatorTag() == LogicalOperatorTag.REPLICATE || op.getOperatorTag() == LogicalOperatorTag.SPLIT) {
            this.subTreesDone.put((ILogicalOperator)op, modified);
        }
        return modified;
    }

    public static class InlineVariablesVisitor
    extends LogicalExpressionReferenceTransformVisitor
    implements ILogicalExpressionReferenceTransform {
        private final Map<LogicalVariable, ILogicalExpression> varAssignRhs;
        private final Set<LogicalVariable> liveVars = new HashSet<LogicalVariable>();
        private final List<LogicalVariable> rhsUsedVars = new ArrayList<LogicalVariable>();
        private ILogicalOperator op;
        private IOptimizationContext context;
        private LogicalVariable targetVar;

        public InlineVariablesVisitor(Map<LogicalVariable, ILogicalExpression> varAssignRhs) {
            this.varAssignRhs = varAssignRhs;
        }

        public void setTargetVariable(LogicalVariable targetVar) {
            this.targetVar = targetVar;
        }

        public void setContext(IOptimizationContext context) {
            this.context = context;
        }

        public void setOperator(ILogicalOperator op) {
            this.op = op;
            this.liveVars.clear();
        }

        public Boolean visitWindowOperator(WindowOperator op, ILogicalExpressionReferenceTransform arg) throws AlgebricksException {
            return op.acceptExpressionTransform(arg, false);
        }

        public boolean transform(Mutable<ILogicalExpression> exprRef) throws AlgebricksException {
            ILogicalExpression e = (ILogicalExpression)exprRef.getValue();
            switch (e.getExpressionTag()) {
                case VARIABLE: {
                    return this.transformVariableReferenceExpression(exprRef, ((VariableReferenceExpression)e).getVariableReference());
                }
                case FUNCTION_CALL: {
                    return this.transformFunctionCallExpression((AbstractFunctionCallExpression)e);
                }
            }
            return false;
        }

        private boolean transformFunctionCallExpression(AbstractFunctionCallExpression fce) throws AlgebricksException {
            boolean modified = false;
            for (Mutable arg : fce.getArguments()) {
                if (!this.transform((Mutable<ILogicalExpression>)arg)) continue;
                modified = true;
            }
            return modified;
        }

        private boolean transformVariableReferenceExpression(Mutable<ILogicalExpression> exprRef, LogicalVariable var) throws AlgebricksException {
            if (this.targetVar != null && var != this.targetVar) {
                return false;
            }
            if (this.context.shouldNotBeInlined(var)) {
                return false;
            }
            ILogicalExpression rhs = this.varAssignRhs.get(var);
            if (rhs == null) {
                return false;
            }
            if (this.liveVars.isEmpty()) {
                VariableUtilities.getLiveVariables((ILogicalOperator)this.op, this.liveVars);
            }
            this.rhsUsedVars.clear();
            rhs.getUsedVariables(this.rhsUsedVars);
            for (LogicalVariable rhsUsedVar : this.rhsUsedVars) {
                if (this.liveVars.contains(rhsUsedVar)) continue;
                return false;
            }
            exprRef.setValue((Object)rhs.cloneExpression());
            return true;
        }
    }
}

