/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.metadata.utils;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.common.exceptions.AsterixException;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.metadata.entities.Function;
import org.apache.asterix.metadata.entities.Index;
import org.apache.asterix.metadata.utils.ArrayIndexUtil;
import org.apache.asterix.metadata.utils.MetadataUtil;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.AOrderedListType;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.TypeSignature;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;

public class TypeUtil {
    private static final char TYPE_NAME_DELIMITER = '$';
    private static final String DATASET_INLINE_TYPE_PREFIX = "$d$t$";
    private static final String FUNCTION_INLINE_TYPE_PREFIX = "$f$t$";

    private TypeUtil() {
    }

    public static Pair<ARecordType, ARecordType> createEnforcedType(ARecordType recordType, ARecordType metaType, List<Index> indexes) throws AlgebricksException {
        EnforcedTypeBuilder enforcedTypeBuilder = new EnforcedTypeBuilder();
        ARecordType enforcedRecordType = recordType;
        block5: for (Index index : indexes) {
            if (!index.isSecondaryIndex() || !index.getIndexDetails().isOverridingKeyFieldTypes()) continue;
            switch (Index.IndexCategory.of(index.getIndexType())) {
                case VALUE: {
                    enforcedRecordType = TypeUtil.appendValueIndexType(enforcedRecordType, (Index.ValueIndexDetails)index.getIndexDetails(), enforcedTypeBuilder);
                    continue block5;
                }
                case TEXT: {
                    enforcedRecordType = TypeUtil.appendTextIndexType(enforcedRecordType, (Index.TextIndexDetails)index.getIndexDetails(), enforcedTypeBuilder);
                    continue block5;
                }
                case ARRAY: {
                    enforcedRecordType = TypeUtil.appendArrayIndexTypes(enforcedRecordType, (Index.ArrayIndexDetails)index.getIndexDetails(), enforcedTypeBuilder);
                    continue block5;
                }
            }
            throw new CompilationException(ErrorCode.COMPILATION_UNKNOWN_INDEX_TYPE, new Serializable[]{String.valueOf(index.getIndexType())});
        }
        TypeUtil.validateRecord((IAType)enforcedRecordType);
        return new Pair((Object)enforcedRecordType, (Object)metaType);
    }

    private static ARecordType appendValueIndexType(ARecordType enforcedRecordType, Index.ValueIndexDetails valueIndexDetails, EnforcedTypeBuilder enforcedTypeBuilder) throws AlgebricksException {
        List<List<String>> keyFieldNames = valueIndexDetails.getKeyFieldNames();
        List<IAType> keyFieldTypes = valueIndexDetails.getKeyFieldTypes();
        List<Integer> keySources = valueIndexDetails.getKeyFieldSourceIndicators();
        for (int i = 0; i < keyFieldNames.size(); ++i) {
            if (keySources.get(i) != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Indexing an open field is only supported on the record part"});
            }
            enforcedTypeBuilder.reset(enforcedRecordType, keyFieldNames.get(i), Collections.nCopies(keyFieldNames.get(i).size(), 0), keyFieldTypes.get(i));
            TypeUtil.validateRecord((IAType)enforcedRecordType);
            enforcedRecordType = enforcedTypeBuilder.build();
        }
        return enforcedRecordType;
    }

    private static ARecordType appendTextIndexType(ARecordType enforcedRecordType, Index.TextIndexDetails textIndexDetails, EnforcedTypeBuilder enforcedTypeBuilder) throws AlgebricksException {
        List<List<String>> keyFieldNames = textIndexDetails.getKeyFieldNames();
        List<IAType> keyFieldTypes = textIndexDetails.getKeyFieldTypes();
        List<Integer> keySources = textIndexDetails.getKeyFieldSourceIndicators();
        for (int i = 0; i < keyFieldNames.size(); ++i) {
            if (keySources.get(i) != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Indexing an open field is only supported on the record part"});
            }
            enforcedTypeBuilder.reset(enforcedRecordType, keyFieldNames.get(i), Collections.nCopies(keyFieldNames.get(i).size(), 0), keyFieldTypes.get(i));
            TypeUtil.validateRecord((IAType)enforcedRecordType);
            enforcedRecordType = enforcedTypeBuilder.build();
        }
        return enforcedRecordType;
    }

    private static ARecordType appendArrayIndexTypes(ARecordType enforcedRecordType, Index.ArrayIndexDetails arrayIndexDetails, EnforcedTypeBuilder enforcedTypeBuilder) throws AlgebricksException {
        for (Index.ArrayIndexElement e : arrayIndexDetails.getElementList()) {
            if (e.getSourceIndicator() != 0) {
                throw new CompilationException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Indexing an open field is only supported on the record part"});
            }
            List<List<String>> unnestList = e.getUnnestList();
            List<List<String>> projectList = e.getProjectList();
            List<IAType> typeList = e.getTypeList();
            for (int i = 0; i < projectList.size(); ++i) {
                List<String> project = projectList.get(i);
                enforcedTypeBuilder.reset(enforcedRecordType, ArrayIndexUtil.getFlattenedKeyFieldNames(unnestList, project), ArrayIndexUtil.getArrayDepthIndicator(unnestList, project), typeList.get(i));
                TypeUtil.validateRecord((IAType)enforcedRecordType);
                enforcedRecordType = enforcedTypeBuilder.build();
            }
        }
        return enforcedRecordType;
    }

    private static Map<String, IAType> createRecordNameTypeMap(ARecordType recordType) {
        LinkedHashMap<String, IAType> recordNameTypesMap = new LinkedHashMap<String, IAType>();
        for (int j = 0; j < recordType.getFieldNames().length; ++j) {
            recordNameTypesMap.put(recordType.getFieldNames()[j], recordType.getFieldTypes()[j]);
        }
        return recordNameTypesMap;
    }

    private static IAType keepUnknown(IAType originalRecordType, ARecordType updatedRecordType) {
        if (originalRecordType.getTypeTag() == ATypeTag.UNION) {
            return AUnionType.createUnknownableType((IAType)updatedRecordType, (String)updatedRecordType.getTypeName());
        }
        return updatedRecordType;
    }

    private static void validateRecord(IAType enforcedDatasetRecordType) {
        if (enforcedDatasetRecordType.getTypeTag() != ATypeTag.OBJECT) {
            throw new IllegalStateException("The dataset type must be a record type to be able to build an index");
        }
    }

    private static void validateNestedRecord(IAType nestedRecordType, List<String> fieldName) throws AsterixException {
        IAType actualType = TypeComputeUtils.getActualType((IAType)nestedRecordType);
        if (actualType.getTypeTag() != ATypeTag.OBJECT) {
            String fName = String.join((CharSequence)".", fieldName);
            throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Field accessor is not defined for \"" + fName + "\" of type " + actualType.getTypeTag()});
        }
    }

    public static IAType createQuantifiedType(IAType primeType, boolean nullable, boolean missable) {
        if (primeType != null) {
            switch (primeType.getTypeTag()) {
                case ANY: 
                case UNION: 
                case NULL: 
                case MISSING: {
                    throw new IllegalArgumentException(primeType.getDisplayName());
                }
            }
        }
        IAType resType = primeType;
        if (nullable && missable) {
            resType = AUnionType.createUnknownableType((IAType)resType);
        } else if (nullable) {
            resType = AUnionType.createNullableType((IAType)resType);
        } else if (missable) {
            resType = AUnionType.createMissableType((IAType)resType);
        }
        return resType;
    }

    public static boolean isReservedInlineTypeName(String typeName) {
        return typeName.length() > 0 && typeName.charAt(0) == '$';
    }

    public static String createDatasetInlineTypeName(String datasetName, boolean forMetaItemType) {
        char typeChar = forMetaItemType ? (char)'m' : 'i';
        return DATASET_INLINE_TYPE_PREFIX + typeChar + "$" + datasetName;
    }

    public static boolean isDatasetInlineTypeName(Dataset dataset, DataverseName typeDataverseName, String typeName) {
        return TypeUtil.isInlineTypeName(dataset.getDataverseName(), typeDataverseName, typeName, DATASET_INLINE_TYPE_PREFIX);
    }

    private static boolean isInlineTypeName(DataverseName entityDataverseName, DataverseName typeDataverseName, String typeName, String inlineTypePrefix) {
        return entityDataverseName.equals((Object)typeDataverseName) && typeName.startsWith(inlineTypePrefix);
    }

    public static String createFunctionParameterTypeName(String functionName, int arity, int parameterIndex) {
        StringBuilder sb = new StringBuilder(FUNCTION_INLINE_TYPE_PREFIX.length() + functionName.length() + 8);
        sb.append(FUNCTION_INLINE_TYPE_PREFIX).append(functionName).append('$').append(arity);
        if (parameterIndex >= 0) {
            sb.append('$').append(parameterIndex);
        } else if (parameterIndex != -1) {
            throw new IllegalArgumentException(String.valueOf(parameterIndex));
        }
        return sb.toString();
    }

    public static boolean isFunctionInlineTypeName(Function function, DataverseName typeDataverseName, String typeName) {
        return TypeUtil.isInlineTypeName(function.getDataverseName(), typeDataverseName, typeName, FUNCTION_INLINE_TYPE_PREFIX);
    }

    public static String getFullyQualifiedDisplayName(DataverseName dataverseName, String typeName) {
        return MetadataUtil.getFullyQualifiedDisplayName(dataverseName, typeName);
    }

    public static List<TypeSignature> getFunctionInlineTypes(Function function) {
        List<TypeSignature> parameterTypes;
        List<TypeSignature> inlineTypes = Collections.emptyList();
        TypeSignature returnType = function.getReturnType();
        if (returnType != null && TypeUtil.isFunctionInlineTypeName(function, returnType.getDataverseName(), returnType.getName())) {
            inlineTypes = new ArrayList<TypeSignature>();
            inlineTypes.add(returnType);
        }
        if ((parameterTypes = function.getParameterTypes()) != null) {
            for (TypeSignature parameterType : parameterTypes) {
                if (parameterType == null || !TypeUtil.isFunctionInlineTypeName(function, parameterType.getDataverseName(), parameterType.getName())) continue;
                if (inlineTypes.isEmpty()) {
                    inlineTypes = new ArrayList<TypeSignature>();
                }
                inlineTypes.add(parameterType);
            }
        }
        return inlineTypes;
    }

    private static class EnforcedTypeBuilder {
        private final Deque<Triple<IAType, String, Integer>> typeStack = new ArrayDeque<Triple<IAType, String, Integer>>();
        private List<Integer> keyDepthIndicators;
        private List<String> keyFieldNames;
        private ARecordType baseRecordType;
        private IAType keyFieldType;
        private String bridgeNameFoundFromOpenTypeBuild;
        private IAType endOfOpenTypeBuild;
        private int indexOfOpenPart;

        private EnforcedTypeBuilder() {
        }

        public void reset(ARecordType baseRecordType, List<String> keyFieldNames, List<Integer> keyDepthIndicators, IAType keyFieldType) {
            this.baseRecordType = baseRecordType;
            this.keyFieldNames = keyFieldNames;
            this.keyDepthIndicators = keyDepthIndicators;
            this.keyFieldType = keyFieldType;
        }

        public ARecordType build() throws AlgebricksException {
            boolean isOpen = this.constructNestedTypeStack();
            IAType newTypeToAdd = isOpen ? this.buildNewForOpenType() : this.buildNewForFullyClosedType();
            return this.buildRestOfRecord(newTypeToAdd);
        }

        private boolean constructNestedTypeStack() throws AlgebricksException {
            ARecordType typeIntermediate = this.baseRecordType;
            ArrayList<String> subFieldName = new ArrayList<String>();
            for (int i = 0; i < this.keyFieldNames.size() - 1; ++i) {
                this.typeStack.push((Triple<IAType, String, Integer>)new Triple((Object)typeIntermediate, (Object)this.keyFieldNames.get(i), (Object)(i == 0 ? 0 : this.keyDepthIndicators.get(i - 1))));
                this.bridgeNameFoundFromOpenTypeBuild = typeIntermediate.getTypeName();
                if (i == 0 || this.keyDepthIndicators.get(i - 1) == 0) {
                    subFieldName.add(this.keyFieldNames.get(i));
                } else {
                    for (int j = 0; j < this.keyDepthIndicators.get(i - 1); ++j) {
                        if ((typeIntermediate = TypeComputeUtils.extractListItemType((IAType)typeIntermediate)) != null) continue;
                        String fName = String.join((CharSequence)".", subFieldName);
                        throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Wrong level of array nesting for field: " + fName});
                    }
                    subFieldName.add(this.keyFieldNames.get(i));
                }
                typeIntermediate = TypeComputeUtils.getActualType((IAType)typeIntermediate);
                typeIntermediate = typeIntermediate.getSubFieldType(subFieldName.subList(i, subFieldName.size()));
                if (typeIntermediate == null) {
                    this.endOfOpenTypeBuild = null;
                    this.indexOfOpenPart = i;
                    return true;
                }
                ATypeTag tt = TypeComputeUtils.getActualType((IAType)typeIntermediate).getTypeTag();
                if (tt == ATypeTag.OBJECT || tt == ATypeTag.ARRAY || tt == ATypeTag.MULTISET) continue;
                String fName = String.join((CharSequence)".", subFieldName);
                throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Field accessor is not defined for \"" + fName + "\" of type " + tt});
            }
            this.endOfOpenTypeBuild = typeIntermediate;
            this.indexOfOpenPart = this.keyFieldNames.size() - 1;
            return false;
        }

        private IAType buildNewForOpenType() {
            int depthOfOpenType = this.keyDepthIndicators.subList(this.indexOfOpenPart + 1, this.keyDepthIndicators.size()).stream().filter(i -> i != 0).findFirst().orElse(0);
            IAType resultant = EnforcedTypeBuilder.nestArrayType(this.keyFieldType, depthOfOpenType);
            resultant = EnforcedTypeBuilder.nestArrayType((IAType)new ARecordType(this.keyFieldNames.get(this.keyFieldNames.size() - 2), new String[]{this.keyFieldNames.get(this.keyFieldNames.size() - 1)}, new IAType[]{AUnionType.createUnknownableType((IAType)resultant)}, true), this.keyDepthIndicators.get(this.indexOfOpenPart));
            for (int i2 = this.keyFieldNames.size() - 3; i2 > this.indexOfOpenPart - 1; --i2) {
                resultant = EnforcedTypeBuilder.nestArrayType((IAType)new ARecordType(this.keyFieldNames.get(i2), new String[]{this.keyFieldNames.get(i2 + 1)}, new IAType[]{AUnionType.createUnknownableType((IAType)resultant)}, true), this.keyDepthIndicators.get(i2));
            }
            Triple<IAType, String, Integer> gapTriple = this.typeStack.pop();
            ARecordType parentRecord = (ARecordType)EnforcedTypeBuilder.unnestArrayType(TypeComputeUtils.getActualType((IAType)((IAType)gapTriple.first)), (Integer)gapTriple.third);
            IAType[] parentFieldTypes = (IAType[])ArrayUtils.addAll((Object[])((IAType[])parentRecord.getFieldTypes().clone()), (Object[])new IAType[]{AUnionType.createUnknownableType((IAType)resultant)});
            resultant = new ARecordType(this.bridgeNameFoundFromOpenTypeBuild, (String[])ArrayUtils.addAll((Object[])parentRecord.getFieldNames(), (Object[])new String[]{resultant.getTypeName()}), parentFieldTypes, true);
            resultant = EnforcedTypeBuilder.keepUnknown((IAType)gapTriple.first, EnforcedTypeBuilder.nestArrayType(resultant, (Integer)gapTriple.third));
            return resultant;
        }

        private IAType buildNewForFullyClosedType() throws AsterixException {
            IAType typeIntermediate = TypeComputeUtils.getActualType((IAType)this.endOfOpenTypeBuild);
            int depthOfOpenType = this.indexOfOpenPart == 0 ? 0 : this.keyDepthIndicators.get(this.indexOfOpenPart - 1);
            int depthOfKeyType = this.keyDepthIndicators.get(this.indexOfOpenPart);
            ARecordType lastNestedRecord = (ARecordType)EnforcedTypeBuilder.unnestArrayType(typeIntermediate, depthOfOpenType);
            Map<String, IAType> recordNameTypesMap = EnforcedTypeBuilder.createRecordNameTypeMap(lastNestedRecord);
            IAType enforcedFieldType = recordNameTypesMap.get(this.keyFieldNames.get(this.keyFieldNames.size() - 1));
            if (enforcedFieldType != null && enforcedFieldType.getTypeTag() == ATypeTag.UNION && ((AUnionType)enforcedFieldType).isUnknownableType()) {
                enforcedFieldType = ((AUnionType)enforcedFieldType).getActualType();
            }
            if (enforcedFieldType != null && !ATypeHierarchy.canPromote((ATypeTag)enforcedFieldType.getTypeTag(), (ATypeTag)this.keyFieldType.getTypeTag())) {
                throw new AsterixException(ErrorCode.COMPILATION_ERROR, new Serializable[]{"Cannot enforce field \"" + String.join((CharSequence)".", this.keyFieldNames) + "\" to have type " + this.keyFieldType});
            }
            if (enforcedFieldType == null) {
                recordNameTypesMap.put(this.keyFieldNames.get(this.keyFieldNames.size() - 1), AUnionType.createUnknownableType((IAType)EnforcedTypeBuilder.nestArrayType(this.keyFieldType, depthOfKeyType)));
            }
            IAType resultant = EnforcedTypeBuilder.nestArrayType((IAType)new ARecordType(lastNestedRecord.getTypeName(), recordNameTypesMap.keySet().toArray(new String[0]), recordNameTypesMap.values().toArray(new IAType[0]), lastNestedRecord.isOpen()), depthOfOpenType);
            return EnforcedTypeBuilder.keepUnknown(this.endOfOpenTypeBuild, resultant);
        }

        private ARecordType buildRestOfRecord(IAType newTypeToAdd) {
            IAType resultant = TypeComputeUtils.getActualType((IAType)newTypeToAdd);
            while (!this.typeStack.isEmpty()) {
                Triple<IAType, String, Integer> typeFromStack = this.typeStack.pop();
                IAType typeIntermediate = EnforcedTypeBuilder.unnestArrayType((IAType)typeFromStack.first, (Integer)typeFromStack.third);
                ARecordType recordType = (ARecordType)typeIntermediate;
                IAType[] fieldTypes = (IAType[])recordType.getFieldTypes().clone();
                fieldTypes[recordType.getFieldIndex((String)((String)typeFromStack.second))] = resultant;
                typeIntermediate = EnforcedTypeBuilder.nestArrayType((IAType)new ARecordType(recordType.getTypeName() + "_enforced", recordType.getFieldNames(), fieldTypes, recordType.isOpen()), (Integer)typeFromStack.third);
                resultant = EnforcedTypeBuilder.keepUnknown((IAType)typeFromStack.first, typeIntermediate);
            }
            return (ARecordType)resultant;
        }

        private static Map<String, IAType> createRecordNameTypeMap(ARecordType recordType) {
            LinkedHashMap<String, IAType> recordNameTypesMap = new LinkedHashMap<String, IAType>();
            for (int j = 0; j < recordType.getFieldNames().length; ++j) {
                recordNameTypesMap.put(recordType.getFieldNames()[j], recordType.getFieldTypes()[j]);
            }
            return recordNameTypesMap;
        }

        private static IAType keepUnknown(IAType originalRecordType, IAType updatedRecordType) {
            if (originalRecordType.getTypeTag() == ATypeTag.UNION) {
                return AUnionType.createUnknownableType((IAType)updatedRecordType, (String)updatedRecordType.getTypeName());
            }
            return updatedRecordType;
        }

        private static IAType nestArrayType(IAType originalType, int depthOfArrays) {
            IAType resultant = originalType;
            for (int i = 0; i < depthOfArrays; ++i) {
                resultant = new AOrderedListType(resultant, i == depthOfArrays - 1 ? originalType.getTypeName() : null);
            }
            return resultant;
        }

        private static IAType unnestArrayType(IAType originalType, int depthOfArrays) {
            IAType resultant = originalType;
            for (int i = 0; i < depthOfArrays; ++i) {
                if ((resultant = TypeComputeUtils.extractListItemType((IAType)resultant)) == null) continue;
                resultant = TypeComputeUtils.getActualType((IAType)resultant);
            }
            return resultant;
        }
    }
}

