/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.opcallbacks;

import org.apache.asterix.common.exceptions.ACIDException;
import org.apache.asterix.common.transactions.AbstractOperationCallback;
import org.apache.asterix.common.transactions.DatasetId;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.common.transactions.ITransactionSubsystem;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexFrameWriter;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class LockThenSearchOperationCallback
extends AbstractOperationCallback
implements ISearchOperationCallback {
    private final ILSMIndexFrameWriter operatorNodePushable;
    private int pkHash;

    public LockThenSearchOperationCallback(DatasetId datasetId, long resourceId, int[] entityIdFields, ITransactionSubsystem txnSubsystem, ITransactionContext txnCtx, IOperatorNodePushable operatorNodePushable) {
        super(datasetId, resourceId, entityIdFields, txnCtx, txnSubsystem.getLockManager());
        this.operatorNodePushable = (ILSMIndexFrameWriter)operatorNodePushable;
    }

    public boolean proceed(ITupleReference tuple) throws HyracksDataException {
        return true;
    }

    public void reconcile(ITupleReference tuple) throws HyracksDataException {
    }

    public void cancel(ITupleReference tuple) throws HyracksDataException {
    }

    public void complete(ITupleReference tuple) throws HyracksDataException {
    }

    public void before(ITupleReference tuple) throws HyracksDataException {
        this.pkHash = this.computePrimaryKeyHashValue(tuple, this.primaryKeyFields);
        try {
            if (this.operatorNodePushable != null) {
                boolean tryLockSucceed = this.lockManager.tryLock(this.datasetId, this.pkHash, (byte)4, this.txnCtx);
                if (!tryLockSucceed) {
                    this.operatorNodePushable.flushPartialFrame();
                    this.lockManager.lock(this.datasetId, this.pkHash, (byte)4, this.txnCtx);
                }
            } else {
                this.lockManager.lock(this.datasetId, this.pkHash, (byte)4, this.txnCtx);
            }
        }
        catch (ACIDException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void release() throws ACIDException {
        this.lockManager.unlock(this.datasetId, this.pkHash, (byte)4, this.txnCtx);
    }
}

