/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.active;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.asterix.active.ActiveEvent;
import org.apache.asterix.active.EntityId;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.asterix.active.IActiveNotificationHandler;
import org.apache.asterix.active.message.ActivePartitionMessage;
import org.apache.asterix.app.active.ActiveEntityEventsListener;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IJobLifecycleListener;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.api.util.SingleThreadEventProcessor;
import org.apache.hyracks.util.ExitUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ActiveNotificationHandler
extends SingleThreadEventProcessor<ActiveEvent>
implements IActiveNotificationHandler,
IJobLifecycleListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Level level = Level.DEBUG;
    public static final String ACTIVE_ENTITY_PROPERTY_NAME = "ActiveJob";
    private final Map<EntityId, IActiveEntityEventsListener> entityEventListeners;
    private final Map<JobId, EntityId> jobId2EntityId = new HashMap<JobId, EntityId>();
    private boolean initialized = false;
    private boolean suspended = false;

    public ActiveNotificationHandler() {
        super(ActiveNotificationHandler.class.getSimpleName());
        this.entityEventListeners = new HashMap<EntityId, IActiveEntityEventsListener>();
    }

    protected void handle(ActiveEvent event) {
        EntityId entityId = this.jobId2EntityId.get(event.getJobId());
        if (entityId != null) {
            IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "Next event is of type " + event.getEventKind());
            }
            if (event.getEventKind() == ActiveEvent.Kind.JOB_FINISHED) {
                LOGGER.log(level, "Removing the job");
                this.jobId2EntityId.remove(event.getJobId());
            }
            if (listener != null) {
                LOGGER.log(level, "Notifying the listener");
                listener.notify(event);
            }
        } else {
            LOGGER.log(Level.ERROR, "Entity not found for received message for job " + event.getJobId());
        }
    }

    public void notifyJobCreation(JobId jobId, JobSpecification jobSpecification) throws HyracksDataException {
        Serializable property;
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "notifyJobCreation(JobId jobId, JobSpecification jobSpecification) was called with jobId = " + jobId);
        }
        if (!((property = jobSpecification.getProperty(ACTIVE_ENTITY_PROPERTY_NAME)) instanceof EntityId)) {
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "Job is not of type active job. property found to be: " + property);
            }
            return;
        }
        EntityId entityId = (EntityId)property;
        this.monitorJob(jobId, entityId);
        boolean found = this.jobId2EntityId.get(jobId) != null;
        LOGGER.log(level, "Job was found to be: " + (found ? "Active" : "Inactive"));
        this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_CREATED, entityId, (Object)jobSpecification));
    }

    private synchronized void monitorJob(JobId jobId, EntityId entityId) {
        boolean found;
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "monitorJob(JobId jobId, ActiveJob activeJob) called with job id: " + jobId);
        }
        boolean bl = found = this.jobId2EntityId.get(jobId) != null;
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "Job was found to be: " + (found ? "Active" : "Inactive"));
        }
        if (this.entityEventListeners.containsKey(entityId)) {
            if (this.jobId2EntityId.containsKey(jobId)) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("Job is already being monitored for job: " + jobId);
                }
                return;
            }
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "monitoring started for job id: " + jobId);
            }
        } else if (LOGGER.isEnabled(level)) {
            LOGGER.info("No listener was found for the entity: " + entityId);
        }
        this.jobId2EntityId.put(jobId, entityId);
    }

    public synchronized void notifyJobStart(JobId jobId) throws HyracksException {
        EntityId entityId = this.jobId2EntityId.get(jobId);
        if (entityId != null) {
            this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_STARTED, entityId, null));
        }
    }

    public synchronized void notifyJobFinish(JobId jobId, JobStatus jobStatus, List<Exception> exceptions) throws HyracksException {
        EntityId entityId;
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "Getting notified of job finish for JobId: " + jobId);
        }
        if ((entityId = this.jobId2EntityId.get(jobId)) != null) {
            this.add(new ActiveEvent(jobId, ActiveEvent.Kind.JOB_FINISHED, entityId, (Object)Pair.of((Object)jobStatus, exceptions)));
        } else if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "no need to notify job finish");
        }
    }

    public void receive(ActivePartitionMessage message) {
        this.add(new ActiveEvent(message.getJobId(), ActiveEvent.Kind.PARTITION_EVENT, message.getActiveRuntimeId().getEntityId(), (Object)message));
    }

    public IActiveEntityEventsListener getListener(EntityId entityId) {
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "getActiveEntityListener(EntityId entityId) was called with entity " + entityId);
        }
        IActiveEntityEventsListener listener = this.entityEventListeners.get(entityId);
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "Listener found: " + listener);
        }
        return this.entityEventListeners.get(entityId);
    }

    public synchronized IActiveEntityEventsListener[] getEventListeners() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getEventListeners() was called");
            LOGGER.trace("returning " + this.entityEventListeners.size() + " Listeners");
        }
        return this.entityEventListeners.values().toArray(new IActiveEntityEventsListener[this.entityEventListeners.size()]);
    }

    public synchronized void registerListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        if (this.suspended) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_NOTIFICATION_HANDLER_IS_SUSPENDED, new Serializable[0]);
        }
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "registerListener(IActiveEntityEventsListener listener) was called for the entity " + listener.getEntityId());
        }
        if (this.entityEventListeners.containsKey(listener.getEntityId())) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_ENTITY_IS_ALREADY_REGISTERED, new Serializable[]{listener.getEntityId()});
        }
        this.entityEventListeners.put(listener.getEntityId(), listener);
    }

    public synchronized void unregisterListener(IActiveEntityEventsListener listener) throws HyracksDataException {
        IActiveEntityEventsListener registeredListener;
        if (this.suspended) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_NOTIFICATION_HANDLER_IS_SUSPENDED, new Serializable[0]);
        }
        if (LOGGER.isEnabled(level)) {
            LOGGER.log(level, "unregisterListener(IActiveEntityEventsListener listener) was called for the entity " + listener.getEntityId());
        }
        if ((registeredListener = this.entityEventListeners.remove(listener.getEntityId())) == null) {
            throw new RuntimeDataException(ErrorCode.ACTIVE_ENTITY_LISTENER_IS_NOT_REGISTERED, new Serializable[]{listener.getEntityId()});
        }
        if (registeredListener.isActive() && !registeredListener.isSuspended()) {
            this.entityEventListeners.put(registeredListener.getEntityId(), registeredListener);
            throw new RuntimeDataException(ErrorCode.CANNOT_DERIGESTER_ACTIVE_ENTITY_LISTENER, new Serializable[]{listener.getEntityId()});
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) throws HyracksDataException {
        if (this.initialized) {
            throw new RuntimeDataException(ErrorCode.DOUBLE_INITIALIZATION_OF_ACTIVE_NOTIFICATION_HANDLER, new Serializable[0]);
        }
        this.initialized = initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() {
        LOGGER.info("Starting active recovery");
        IActiveEntityEventsListener[] iActiveEntityEventsListenerArray = this.getEventListeners();
        int n = iActiveEntityEventsListenerArray.length;
        for (int i = 0; i < n; ++i) {
            IActiveEntityEventsListener listener;
            IActiveEntityEventsListener iActiveEntityEventsListener = listener = iActiveEntityEventsListenerArray[i];
            synchronized (iActiveEntityEventsListener) {
                if (LOGGER.isEnabled(level)) {
                    LOGGER.log(level, "Entity " + listener.getEntityId() + " is " + listener.getState());
                }
                listener.notifyAll();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend(MetadataProvider mdProvider) throws HyracksDataException {
        ActiveNotificationHandler activeNotificationHandler = this;
        synchronized (activeNotificationHandler) {
            if (this.suspended) {
                throw new RuntimeDataException(ErrorCode.ACTIVE_EVENT_HANDLER_ALREADY_SUSPENDED, new Serializable[0]);
            }
            LOGGER.log(level, "Suspending active events handler");
            this.suspended = true;
        }
        Collection<IActiveEntityEventsListener> registeredListeners = this.entityEventListeners.values();
        for (IActiveEntityEventsListener listener : registeredListeners) {
            this.suspendForDdlOrHalt(listener, mdProvider, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume(MetadataProvider mdProvider) {
        LOGGER.log(level, "Resuming active events handler");
        for (IActiveEntityEventsListener listener : this.entityEventListeners.values()) {
            this.resumeOrHalt(listener, mdProvider);
        }
        Object object = this;
        synchronized (object) {
            this.suspended = false;
        }
    }

    public void suspendForDdlOrHalt(IActiveEntityEventsListener listener, MetadataProvider metadataProvider, Dataset targetDataset) {
        try {
            EntityId entityId = listener.getEntityId();
            LOGGER.log(level, "Suspending {}", (Object)entityId);
            LOGGER.log(level, "Acquiring locks for {}", (Object)entityId);
            ((ActiveEntityEventsListener)listener).acquireSuspendLocks(metadataProvider, targetDataset);
            LOGGER.log(level, "locks acquired for {}", (Object)entityId);
            ((ActiveEntityEventsListener)listener).suspend(metadataProvider);
            LOGGER.log(level, "{} suspended", (Object)entityId);
        }
        catch (Throwable th) {
            LOGGER.error("Suspend active failed", th);
            ExitUtil.halt((int)17);
        }
    }

    public void resumeOrHalt(IActiveEntityEventsListener listener, MetadataProvider metadataProvider) {
        try {
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, "Resuming " + listener.getEntityId());
            }
            ((ActiveEntityEventsListener)listener).resume(metadataProvider);
            if (LOGGER.isEnabled(level)) {
                LOGGER.log(level, listener.getEntityId() + " resumed");
            }
        }
        catch (Throwable th) {
            LOGGER.error("Resume active failed", th);
            ExitUtil.halt((int)18);
        }
    }
}

