/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class AzureKeyCredential {
    private final ClientLogger logger = new ClientLogger(AzureKeyCredential.class);
    private String key;

    public AzureKeyCredential(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (key.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'key' cannot be empty."));
        }
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public AzureKeyCredential update(String key) {
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (key.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'key' cannot be empty."));
        }
        this.key = key;
        return this;
    }
}

